/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Sections_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_SECTIONS_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_SECTIONS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CSection;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSections_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CSections_Base(void);
    // destructor
    virtual ~CSections_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSection C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSection > > TSection;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Section
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSection > > TSection
    ///  Check whether the Section data member has been assigned a value.
    bool IsSetSection(void) const;
    /// Check whether it is safe or not to call GetSection method.
    bool CanGetSection(void) const;
    void ResetSection(void);
    const TSection& GetSection(void) const;
    TSection& SetSection(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSections_Base(const CSections_Base&);
    CSections_Base& operator=(const CSections_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CSection > > m_Section;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSections_Base::IsSetSection(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSections_Base::CanGetSection(void) const
{
    return true;
}

inline
const CSections_Base::TSection& CSections_Base::GetSection(void) const
{
    return m_Section;
}

inline
CSections_Base::TSection& CSections_Base::SetSection(void)
{
    m_set_State[0] |= 0x1;
    return m_Section;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_SECTIONS_BASE_HPP
