/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Root_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ROOT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ROOT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CRoot_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CRoot_Base(void);
    // destructor
    virtual ~CRoot_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TEncoding;
        typedef NCBI_NS_STD::string TDefinitionURL;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_encoding,
            e_definitionURL
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TEncoding
        ///  Check whether the Encoding data member has been assigned a value.
        bool IsSetEncoding(void) const;
        /// Check whether it is safe or not to call GetEncoding method.
        bool CanGetEncoding(void) const;
        void ResetEncoding(void);
        const TEncoding& GetEncoding(void) const;
        void SetEncoding(const TEncoding& value);
        void SetEncoding(TEncoding&& value);
        TEncoding& SetEncoding(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDefinitionURL
        ///  Check whether the DefinitionURL data member has been assigned a value.
        bool IsSetDefinitionURL(void) const;
        /// Check whether it is safe or not to call GetDefinitionURL method.
        bool CanGetDefinitionURL(void) const;
        void ResetDefinitionURL(void);
        const TDefinitionURL& GetDefinitionURL(void) const;
        void SetDefinitionURL(const TDefinitionURL& value);
        void SetDefinitionURL(TDefinitionURL&& value);
        TDefinitionURL& SetDefinitionURL(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Encoding;
        NCBI_NS_STD::string m_DefinitionURL;
    };
    // types
    typedef C_Attlist TAttlist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_root
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    ///  Check whether the Root data member has been assigned a value.
    bool IsSetRoot(void) const;
    /// Check whether it is safe or not to call GetRoot method.
    bool CanGetRoot(void) const;
    void ResetRoot(void);
    void SetRoot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRoot_Base(const CRoot_Base&);
    CRoot_Base& operator=(const CRoot_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRoot_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CRoot_Base::C_Attlist::TId& CRoot_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CRoot_Base::C_Attlist::SetId(const CRoot_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CRoot_Base::C_Attlist::SetId(CRoot_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CRoot_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CRoot_Base::C_Attlist::TId& CRoot_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CRoot_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CRoot_Base::C_Attlist::TXref& CRoot_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CRoot_Base::C_Attlist::SetXref(const CRoot_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CRoot_Base::C_Attlist::SetXref(CRoot_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CRoot_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CRoot_Base::C_Attlist::TXref& CRoot_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CRoot_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CRoot_Base::C_Attlist::TClass& CRoot_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CRoot_Base::C_Attlist::SetClass(const CRoot_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CRoot_Base::C_Attlist::SetClass(CRoot_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CRoot_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CRoot_Base::C_Attlist::TClass& CRoot_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CRoot_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CRoot_Base::C_Attlist::TStyle& CRoot_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CRoot_Base::C_Attlist::SetStyle(const CRoot_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CRoot_Base::C_Attlist::SetStyle(CRoot_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CRoot_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CRoot_Base::C_Attlist::TStyle& CRoot_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CRoot_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CRoot_Base::C_Attlist::THref& CRoot_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CRoot_Base::C_Attlist::SetHref(const CRoot_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CRoot_Base::C_Attlist::SetHref(CRoot_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CRoot_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CRoot_Base::C_Attlist::THref& CRoot_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CRoot_Base::C_Attlist::IsSetEncoding(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetEncoding(void) const
{
    return IsSetEncoding();
}

inline
const CRoot_Base::C_Attlist::TEncoding& CRoot_Base::C_Attlist::GetEncoding(void) const
{
    if (!CanGetEncoding()) {
        ThrowUnassigned(5);
    }
    return m_Encoding;
}

inline
void CRoot_Base::C_Attlist::SetEncoding(const CRoot_Base::C_Attlist::TEncoding& value)
{
    m_Encoding = value;
    m_set_State[0] |= 0xc00;
}

inline
void CRoot_Base::C_Attlist::SetEncoding(CRoot_Base::C_Attlist::TEncoding&& value)
{
    m_Encoding = std::forward<CRoot_Base::C_Attlist::TEncoding>(value);
    m_set_State[0] |= 0xc00;
}

inline
CRoot_Base::C_Attlist::TEncoding& CRoot_Base::C_Attlist::SetEncoding(void)
{
#ifdef _DEBUG
    if (!IsSetEncoding()) {
        m_Encoding = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Encoding;
}

inline
bool CRoot_Base::C_Attlist::IsSetDefinitionURL(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRoot_Base::C_Attlist::CanGetDefinitionURL(void) const
{
    return IsSetDefinitionURL();
}

inline
const CRoot_Base::C_Attlist::TDefinitionURL& CRoot_Base::C_Attlist::GetDefinitionURL(void) const
{
    if (!CanGetDefinitionURL()) {
        ThrowUnassigned(6);
    }
    return m_DefinitionURL;
}

inline
void CRoot_Base::C_Attlist::SetDefinitionURL(const CRoot_Base::C_Attlist::TDefinitionURL& value)
{
    m_DefinitionURL = value;
    m_set_State[0] |= 0x3000;
}

inline
void CRoot_Base::C_Attlist::SetDefinitionURL(CRoot_Base::C_Attlist::TDefinitionURL&& value)
{
    m_DefinitionURL = std::forward<CRoot_Base::C_Attlist::TDefinitionURL>(value);
    m_set_State[0] |= 0x3000;
}

inline
CRoot_Base::C_Attlist::TDefinitionURL& CRoot_Base::C_Attlist::SetDefinitionURL(void)
{
#ifdef _DEBUG
    if (!IsSetDefinitionURL()) {
        m_DefinitionURL = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_DefinitionURL;
}

inline
bool CRoot_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CRoot_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CRoot_Base::TAttlist& CRoot_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CRoot_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CRoot_Base::TAttlist& CRoot_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    SetRoot();
    return (*m_Attlist);
}

inline
bool CRoot_Base::IsSetRoot(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRoot_Base::CanGetRoot(void) const
{
    return false;
}

inline
void CRoot_Base::ResetRoot(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CRoot_Base::SetRoot(void)
{
    m_set_State[0] |= 0xc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ROOT_BASE_HPP
