/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PubmedData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDDATA_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CArticleIdList;
class CHistory;
class CObjectList;
class CPublicationStatus;
class CReferenceList;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPubmedData_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPubmedData_Base(void);
    // destructor
    virtual ~CPubmedData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CHistory THistory;
    typedef CPublicationStatus TPublicationStatus;
    typedef CArticleIdList TArticleIdList;
    typedef CObjectList TObjectList;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > TReferenceList;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_History,
        e_PublicationStatus,
        e_ArticleIdList,
        e_ObjectList,
        e_ReferenceList
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CHistory THistory
    ///  Check whether the History data member has been assigned a value.
    bool IsSetHistory(void) const;
    /// Check whether it is safe or not to call GetHistory method.
    bool CanGetHistory(void) const;
    void ResetHistory(void);
    const THistory& GetHistory(void) const;
    void SetHistory(THistory& value);
    THistory& SetHistory(void);

    /// mandatory
    /// typedef CPublicationStatus TPublicationStatus
    ///  Check whether the PublicationStatus data member has been assigned a value.
    bool IsSetPublicationStatus(void) const;
    /// Check whether it is safe or not to call GetPublicationStatus method.
    bool CanGetPublicationStatus(void) const;
    void ResetPublicationStatus(void);
    const TPublicationStatus& GetPublicationStatus(void) const;
    void SetPublicationStatus(TPublicationStatus& value);
    TPublicationStatus& SetPublicationStatus(void);

    /// mandatory
    /// typedef CArticleIdList TArticleIdList
    ///  Check whether the ArticleIdList data member has been assigned a value.
    bool IsSetArticleIdList(void) const;
    /// Check whether it is safe or not to call GetArticleIdList method.
    bool CanGetArticleIdList(void) const;
    void ResetArticleIdList(void);
    const TArticleIdList& GetArticleIdList(void) const;
    void SetArticleIdList(TArticleIdList& value);
    TArticleIdList& SetArticleIdList(void);

    /// optional
    /// typedef CObjectList TObjectList
    ///  Check whether the ObjectList data member has been assigned a value.
    bool IsSetObjectList(void) const;
    /// Check whether it is safe or not to call GetObjectList method.
    bool CanGetObjectList(void) const;
    void ResetObjectList(void);
    const TObjectList& GetObjectList(void) const;
    void SetObjectList(TObjectList& value);
    TObjectList& SetObjectList(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > TReferenceList
    ///  Check whether the ReferenceList data member has been assigned a value.
    bool IsSetReferenceList(void) const;
    /// Check whether it is safe or not to call GetReferenceList method.
    bool CanGetReferenceList(void) const;
    void ResetReferenceList(void);
    const TReferenceList& GetReferenceList(void) const;
    TReferenceList& SetReferenceList(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmedData_Base(const CPubmedData_Base&);
    CPubmedData_Base& operator=(const CPubmedData_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< THistory > m_History;
    NCBI_NS_NCBI::CRef< TPublicationStatus > m_PublicationStatus;
    NCBI_NS_NCBI::CRef< TArticleIdList > m_ArticleIdList;
    NCBI_NS_NCBI::CRef< TObjectList > m_ObjectList;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CReferenceList > > m_ReferenceList;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubmedData_Base::IsSetHistory(void) const
{
    return m_History.NotEmpty();
}

inline
bool CPubmedData_Base::CanGetHistory(void) const
{
    return IsSetHistory();
}

inline
const CPubmedData_Base::THistory& CPubmedData_Base::GetHistory(void) const
{
    if (!CanGetHistory()) {
        ThrowUnassigned(0);
    }
    return (*m_History);
}

inline
bool CPubmedData_Base::IsSetPublicationStatus(void) const
{
    return m_PublicationStatus.NotEmpty();
}

inline
bool CPubmedData_Base::CanGetPublicationStatus(void) const
{
    return true;
}

inline
const CPubmedData_Base::TPublicationStatus& CPubmedData_Base::GetPublicationStatus(void) const
{
    if ( !m_PublicationStatus ) {
        const_cast<CPubmedData_Base*>(this)->ResetPublicationStatus();
    }
    return (*m_PublicationStatus);
}

inline
CPubmedData_Base::TPublicationStatus& CPubmedData_Base::SetPublicationStatus(void)
{
    if ( !m_PublicationStatus ) {
        ResetPublicationStatus();
    }
    return (*m_PublicationStatus);
}

inline
bool CPubmedData_Base::IsSetArticleIdList(void) const
{
    return m_ArticleIdList.NotEmpty();
}

inline
bool CPubmedData_Base::CanGetArticleIdList(void) const
{
    return true;
}

inline
const CPubmedData_Base::TArticleIdList& CPubmedData_Base::GetArticleIdList(void) const
{
    if ( !m_ArticleIdList ) {
        const_cast<CPubmedData_Base*>(this)->ResetArticleIdList();
    }
    return (*m_ArticleIdList);
}

inline
CPubmedData_Base::TArticleIdList& CPubmedData_Base::SetArticleIdList(void)
{
    if ( !m_ArticleIdList ) {
        ResetArticleIdList();
    }
    return (*m_ArticleIdList);
}

inline
bool CPubmedData_Base::IsSetObjectList(void) const
{
    return m_ObjectList.NotEmpty();
}

inline
bool CPubmedData_Base::CanGetObjectList(void) const
{
    return IsSetObjectList();
}

inline
const CPubmedData_Base::TObjectList& CPubmedData_Base::GetObjectList(void) const
{
    if (!CanGetObjectList()) {
        ThrowUnassigned(3);
    }
    return (*m_ObjectList);
}

inline
bool CPubmedData_Base::IsSetReferenceList(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPubmedData_Base::CanGetReferenceList(void) const
{
    return true;
}

inline
const CPubmedData_Base::TReferenceList& CPubmedData_Base::GetReferenceList(void) const
{
    return m_ReferenceList;
}

inline
CPubmedData_Base::TReferenceList& CPubmedData_Base::SetReferenceList(void)
{
    m_set_State[0] |= 0x100;
    return m_ReferenceList;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDDATA_BASE_HPP
