/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PubmedArticleSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDARTICLESET_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDARTICLESET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CDeleteCitation;
class CPubmedArticle;
class CPubmedBookArticle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ================================================================= 
/// ================================================================= 
///   ================= Set-level elements ============================ 
class CPubmedArticleSet_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPubmedArticleSet_Base(void);
    // destructor
    virtual ~CPubmedArticleSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_PP : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_PP(void);
        // destructor
        ~C_PP(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_E_PP : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_E_PP(void);
            // destructor
            ~C_E_PP(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,        ///< No variant selected
                e_PubmedArticle,
                e_PubmedBookArticle
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 3 ///< == e_PubmedBookArticle+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef CPubmedArticle TPubmedArticle;
            typedef CPubmedBookArticle TPubmedBookArticle;
        
            // getters
            // setters
        
            // typedef CPubmedArticle TPubmedArticle
            bool IsPubmedArticle(void) const;
            const TPubmedArticle& GetPubmedArticle(void) const;
            TPubmedArticle& SetPubmedArticle(void);
            void SetPubmedArticle(TPubmedArticle& value);
        
            // typedef CPubmedBookArticle TPubmedBookArticle
            bool IsPubmedBookArticle(void) const;
            const TPubmedBookArticle& GetPubmedBookArticle(void) const;
            TPubmedBookArticle& SetPubmedBookArticle(void);
            void SetPubmedBookArticle(TPubmedBookArticle& value);
        
        
        private:
            // copy constructor and assignment operator
            C_E_PP(const C_E_PP& );
            C_E_PP& operator=(const C_E_PP& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
        // types
        typedef C_E_PP C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_PP > > TPP;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_PP
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_PP > > TPP
        ///  Check whether the PP data member has been assigned a value.
        bool IsSetPP(void) const;
        /// Check whether it is safe or not to call GetPP method.
        bool CanGetPP(void) const;
        void ResetPP(void);
        const TPP& GetPP(void) const;
        TPP& SetPP(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_PP(const C_PP&);
        C_PP& operator=(const C_PP&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_PP > > m_PP;
    };
    // types
    typedef C_PP TPP;
    typedef CDeleteCitation TDeleteCitation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_PP,
        e_DeleteCitation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_PP TPP
    ///  Check whether the PP data member has been assigned a value.
    bool IsSetPP(void) const;
    /// Check whether it is safe or not to call GetPP method.
    bool CanGetPP(void) const;
    void ResetPP(void);
    const TPP& GetPP(void) const;
    void SetPP(TPP& value);
    TPP& SetPP(void);

    /// optional
    /// typedef CDeleteCitation TDeleteCitation
    ///  Check whether the DeleteCitation data member has been assigned a value.
    bool IsSetDeleteCitation(void) const;
    /// Check whether it is safe or not to call GetDeleteCitation method.
    bool CanGetDeleteCitation(void) const;
    void ResetDeleteCitation(void);
    const TDeleteCitation& GetDeleteCitation(void) const;
    void SetDeleteCitation(TDeleteCitation& value);
    TDeleteCitation& SetDeleteCitation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmedArticleSet_Base(const CPubmedArticleSet_Base&);
    CPubmedArticleSet_Base& operator=(const CPubmedArticleSet_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TPP > m_PP;
    NCBI_NS_NCBI::CRef< TDeleteCitation > m_DeleteCitation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPubmedArticleSet_Base::C_PP::C_E_PP::E_Choice CPubmedArticleSet_Base::C_PP::C_E_PP::Which(void) const
{
    return m_choice;
}

inline
void CPubmedArticleSet_Base::C_PP::C_E_PP::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPubmedArticleSet_Base::C_PP::C_E_PP::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPubmedArticleSet_Base::C_PP::C_E_PP::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPubmedArticleSet_Base::C_PP::C_E_PP::IsPubmedArticle(void) const
{
    return m_choice == e_PubmedArticle;
}

inline
bool CPubmedArticleSet_Base::C_PP::C_E_PP::IsPubmedBookArticle(void) const
{
    return m_choice == e_PubmedBookArticle;
}

inline
bool CPubmedArticleSet_Base::C_PP::IsSetPP(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPubmedArticleSet_Base::C_PP::CanGetPP(void) const
{
    return true;
}

inline
const CPubmedArticleSet_Base::C_PP::TPP& CPubmedArticleSet_Base::C_PP::GetPP(void) const
{
    return m_PP;
}

inline
CPubmedArticleSet_Base::C_PP::TPP& CPubmedArticleSet_Base::C_PP::SetPP(void)
{
    m_set_State[0] |= 0x1;
    return m_PP;
}

inline
bool CPubmedArticleSet_Base::IsSetPP(void) const
{
    return m_PP.NotEmpty();
}

inline
bool CPubmedArticleSet_Base::CanGetPP(void) const
{
    return true;
}

inline
const CPubmedArticleSet_Base::TPP& CPubmedArticleSet_Base::GetPP(void) const
{
    if ( !m_PP ) {
        const_cast<CPubmedArticleSet_Base*>(this)->ResetPP();
    }
    return (*m_PP);
}

inline
CPubmedArticleSet_Base::TPP& CPubmedArticleSet_Base::SetPP(void)
{
    if ( !m_PP ) {
        ResetPP();
    }
    return (*m_PP);
}

inline
bool CPubmedArticleSet_Base::IsSetDeleteCitation(void) const
{
    return m_DeleteCitation.NotEmpty();
}

inline
bool CPubmedArticleSet_Base::CanGetDeleteCitation(void) const
{
    return IsSetDeleteCitation();
}

inline
const CPubmedArticleSet_Base::TDeleteCitation& CPubmedArticleSet_Base::GetDeleteCitation(void) const
{
    if (!CanGetDeleteCitation()) {
        ThrowUnassigned(1);
    }
    return (*m_DeleteCitation);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBMEDARTICLESET_BASE_HPP
