/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PublicationType_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PUBLICATIONTYPE_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PUBLICATIONTYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPublicationType_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPublicationType_Base(void);
    // destructor
    virtual ~CPublicationType_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TUI;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_UI
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TUI
        ///  Check whether the UI data member has been assigned a value.
        bool IsSetUI(void) const;
        /// Check whether it is safe or not to call GetUI method.
        bool CanGetUI(void) const;
        void ResetUI(void);
        const TUI& GetUI(void) const;
        void SetUI(const TUI& value);
        void SetUI(TUI&& value);
        TUI& SetUI(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_UI;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TPublicationType;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_PublicationType
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TPublicationType
    ///  Check whether the PublicationType data member has been assigned a value.
    bool IsSetPublicationType(void) const;
    /// Check whether it is safe or not to call GetPublicationType method.
    bool CanGetPublicationType(void) const;
    void ResetPublicationType(void);
    const TPublicationType& GetPublicationType(void) const;
    void SetPublicationType(const TPublicationType& value);
    void SetPublicationType(TPublicationType&& value);
    TPublicationType& SetPublicationType(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPublicationType_Base(const CPublicationType_Base&);
    CPublicationType_Base& operator=(const CPublicationType_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_PublicationType;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPublicationType_Base::C_Attlist::IsSetUI(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPublicationType_Base::C_Attlist::CanGetUI(void) const
{
    return IsSetUI();
}

inline
const CPublicationType_Base::C_Attlist::TUI& CPublicationType_Base::C_Attlist::GetUI(void) const
{
    if (!CanGetUI()) {
        ThrowUnassigned(0);
    }
    return m_UI;
}

inline
void CPublicationType_Base::C_Attlist::SetUI(const CPublicationType_Base::C_Attlist::TUI& value)
{
    m_UI = value;
    m_set_State[0] |= 0x3;
}

inline
void CPublicationType_Base::C_Attlist::SetUI(CPublicationType_Base::C_Attlist::TUI&& value)
{
    m_UI = std::forward<CPublicationType_Base::C_Attlist::TUI>(value);
    m_set_State[0] |= 0x3;
}

inline
CPublicationType_Base::C_Attlist::TUI& CPublicationType_Base::C_Attlist::SetUI(void)
{
#ifdef _DEBUG
    if (!IsSetUI()) {
        m_UI = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_UI;
}

inline
bool CPublicationType_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CPublicationType_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CPublicationType_Base::TAttlist& CPublicationType_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CPublicationType_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CPublicationType_Base::TAttlist& CPublicationType_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CPublicationType_Base::IsSetPublicationType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPublicationType_Base::CanGetPublicationType(void) const
{
    return IsSetPublicationType();
}

inline
const CPublicationType_Base::TPublicationType& CPublicationType_Base::GetPublicationType(void) const
{
    if (!CanGetPublicationType()) {
        ThrowUnassigned(1);
    }
    return m_PublicationType;
}

inline
void CPublicationType_Base::SetPublicationType(const CPublicationType_Base::TPublicationType& value)
{
    m_PublicationType = value;
    m_set_State[0] |= 0xc;
}

inline
void CPublicationType_Base::SetPublicationType(CPublicationType_Base::TPublicationType&& value)
{
    m_PublicationType = std::forward<CPublicationType_Base::TPublicationType>(value);
    m_set_State[0] |= 0xc;
}

inline
CPublicationType_Base::TPublicationType& CPublicationType_Base::SetPublicationType(void)
{
#ifdef _DEBUG
    if (!IsSetPublicationType()) {
        m_PublicationType = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_PublicationType;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PUBLICATIONTYPE_BASE_HPP
