/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PMID_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_PMID_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_PMID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CPMID_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CPMID_Base(void);
    // destructor
    virtual ~CPMID_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TVersion;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Version
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TVersion
        ///  Check whether the Version data member has been assigned a value.
        bool IsSetVersion(void) const;
        /// Check whether it is safe or not to call GetVersion method.
        bool CanGetVersion(void) const;
        void ResetVersion(void);
        const TVersion& GetVersion(void) const;
        void SetVersion(const TVersion& value);
        void SetVersion(TVersion&& value);
        TVersion& SetVersion(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Version;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TPMID;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_PMID
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TPMID
    ///  Check whether the PMID data member has been assigned a value.
    bool IsSetPMID(void) const;
    /// Check whether it is safe or not to call GetPMID method.
    bool CanGetPMID(void) const;
    void ResetPMID(void);
    const TPMID& GetPMID(void) const;
    void SetPMID(const TPMID& value);
    void SetPMID(TPMID&& value);
    TPMID& SetPMID(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPMID_Base(const CPMID_Base&);
    CPMID_Base& operator=(const CPMID_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_PMID;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPMID_Base::C_Attlist::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPMID_Base::C_Attlist::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
const CPMID_Base::C_Attlist::TVersion& CPMID_Base::C_Attlist::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(0);
    }
    return m_Version;
}

inline
void CPMID_Base::C_Attlist::SetVersion(const CPMID_Base::C_Attlist::TVersion& value)
{
    m_Version = value;
    m_set_State[0] |= 0x3;
}

inline
void CPMID_Base::C_Attlist::SetVersion(CPMID_Base::C_Attlist::TVersion&& value)
{
    m_Version = std::forward<CPMID_Base::C_Attlist::TVersion>(value);
    m_set_State[0] |= 0x3;
}

inline
CPMID_Base::C_Attlist::TVersion& CPMID_Base::C_Attlist::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        m_Version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Version;
}

inline
bool CPMID_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CPMID_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CPMID_Base::TAttlist& CPMID_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CPMID_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CPMID_Base::TAttlist& CPMID_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CPMID_Base::IsSetPMID(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPMID_Base::CanGetPMID(void) const
{
    return IsSetPMID();
}

inline
const CPMID_Base::TPMID& CPMID_Base::GetPMID(void) const
{
    if (!CanGetPMID()) {
        ThrowUnassigned(1);
    }
    return m_PMID;
}

inline
void CPMID_Base::SetPMID(const CPMID_Base::TPMID& value)
{
    m_PMID = value;
    m_set_State[0] |= 0xc;
}

inline
void CPMID_Base::SetPMID(CPMID_Base::TPMID&& value)
{
    m_PMID = std::forward<CPMID_Base::TPMID>(value);
    m_set_State[0] |= 0xc;
}

inline
CPMID_Base::TPMID& CPMID_Base::SetPMID(void)
{
#ifdef _DEBUG
    if (!IsSetPMID()) {
        m_PMID = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_PMID;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_PMID_BASE_HPP
