/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file NlmUniqueID_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_NLMUNIQUEID_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_NLMUNIQUEID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CNlmUniqueID_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CNlmUniqueID_Base(void);
    // destructor
    virtual ~CNlmUniqueID_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::string Tdata;

    /// Constructor from the primitive type
    CNlmUniqueID_Base(const Tdata& value);
    /// Assignment operator.
    void operator=(const Tdata& value);

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::string Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    void Set(const Tdata& value);
    void Set(Tdata&& value);
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CNlmUniqueID_Base(const CNlmUniqueID_Base&);
    CNlmUniqueID_Base& operator=(const CNlmUniqueID_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::string m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CNlmUniqueID_Base::CNlmUniqueID_Base(const Tdata& value)
{
    Set(value);
}

inline
void CNlmUniqueID_Base::operator=(const Tdata& value)
{
    Set(value);
}

inline
bool CNlmUniqueID_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CNlmUniqueID_Base::CanGet(void) const
{
    return IsSet();
}

inline
const CNlmUniqueID_Base::Tdata& CNlmUniqueID_Base::Get(void) const
{
    if (!CanGet()) {
        ThrowUnassigned(0);
    }
    return m_data;
}

inline
void CNlmUniqueID_Base::Set(const CNlmUniqueID_Base::Tdata& value)
{
    m_data = value;
    m_set_State[0] |= 0x3;
}

inline
void CNlmUniqueID_Base::Set(CNlmUniqueID_Base::Tdata&& value)
{
    m_data = std::forward<CNlmUniqueID_Base::Tdata>(value);
    m_set_State[0] |= 0x3;
}

inline
CNlmUniqueID_Base::Tdata& CNlmUniqueID_Base::Set(void)
{
#ifdef _DEBUG
    if (!IsSet()) {
        m_data = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CNlmUniqueID_Base::operator const CNlmUniqueID_Base::Tdata& (void) const
{
    return m_data;
}

inline
CNlmUniqueID_Base::operator CNlmUniqueID_Base::Tdata& (void)
{
#ifdef _DEBUG
    if (!IsSet()) {
        m_data = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_NLMUNIQUEID_BASE_HPP
