/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mstack_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MSTACK_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MSTACK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objtools/eutils/efetch/MstackExpression.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMstack_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMstack_Base(void);
    // destructor
    virtual ~CMstack_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_stackalign {
            eAttlist_stackalign_left         = 1,
            eAttlist_stackalign_center       = 2,
            eAttlist_stackalign_right        = 3,
            eAttlist_stackalign_decimalpoint = 4
        };
        
        /// Access to EAttlist_stackalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_stackalign)(void);
        
        enum EAttlist_charalign {
            eAttlist_charalign_left   = 1,
            eAttlist_charalign_center = 2,
            eAttlist_charalign_right  = 3
        };
        
        /// Access to EAttlist_charalign's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_charalign)(void);
        
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string TAlign;
        typedef EAttlist_stackalign TStackalign;
        typedef EAttlist_charalign TCharalign;
        typedef NCBI_NS_STD::string TCharspacing;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_align,
            e_stackalign,
            e_charalign,
            e_charspacing
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 12> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TAlign
        ///  Check whether the Align data member has been assigned a value.
        bool IsSetAlign(void) const;
        /// Check whether it is safe or not to call GetAlign method.
        bool CanGetAlign(void) const;
        void ResetAlign(void);
        const TAlign& GetAlign(void) const;
        void SetAlign(const TAlign& value);
        void SetAlign(TAlign&& value);
        TAlign& SetAlign(void);
    
        /// optional
        /// typedef EAttlist_stackalign TStackalign
        ///  Check whether the Stackalign data member has been assigned a value.
        bool IsSetStackalign(void) const;
        /// Check whether it is safe or not to call GetStackalign method.
        bool CanGetStackalign(void) const;
        void ResetStackalign(void);
        TStackalign GetStackalign(void) const;
        void SetStackalign(TStackalign value);
        TStackalign& SetStackalign(void);
    
        /// optional
        /// typedef EAttlist_charalign TCharalign
        ///  Check whether the Charalign data member has been assigned a value.
        bool IsSetCharalign(void) const;
        /// Check whether it is safe or not to call GetCharalign method.
        bool CanGetCharalign(void) const;
        void ResetCharalign(void);
        TCharalign GetCharalign(void) const;
        void SetCharalign(TCharalign value);
        TCharalign& SetCharalign(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TCharspacing
        ///  Check whether the Charspacing data member has been assigned a value.
        bool IsSetCharspacing(void) const;
        /// Check whether it is safe or not to call GetCharspacing method.
        bool CanGetCharspacing(void) const;
        void ResetCharspacing(void);
        const TCharspacing& GetCharspacing(void) const;
        void SetCharspacing(const TCharspacing& value);
        void SetCharspacing(TCharspacing&& value);
        TCharspacing& SetCharspacing(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Align;
        EAttlist_stackalign m_Stackalign;
        EAttlist_charalign m_Charalign;
        NCBI_NS_STD::string m_Charspacing;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_E_MstackExpression : public CMstackExpression
    {
        typedef CMstackExpression Tparent;
    public:
        C_E_MstackExpression(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MstackExpression > > TMstackExpression;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_MstackExpression
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MstackExpression > > TMstackExpression
    ///  Check whether the MstackExpression data member has been assigned a value.
    bool IsSetMstackExpression(void) const;
    /// Check whether it is safe or not to call GetMstackExpression method.
    bool CanGetMstackExpression(void) const;
    void ResetMstackExpression(void);
    const TMstackExpression& GetMstackExpression(void) const;
    TMstackExpression& SetMstackExpression(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMstack_Base(const CMstack_Base&);
    CMstack_Base& operator=(const CMstack_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E_MstackExpression > > m_MstackExpression;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMstack_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMstack_Base::C_Attlist::TId& CMstack_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMstack_Base::C_Attlist::SetId(const CMstack_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMstack_Base::C_Attlist::SetId(CMstack_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMstack_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMstack_Base::C_Attlist::TId& CMstack_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMstack_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMstack_Base::C_Attlist::TXref& CMstack_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMstack_Base::C_Attlist::SetXref(const CMstack_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMstack_Base::C_Attlist::SetXref(CMstack_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMstack_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMstack_Base::C_Attlist::TXref& CMstack_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMstack_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMstack_Base::C_Attlist::TClass& CMstack_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMstack_Base::C_Attlist::SetClass(const CMstack_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMstack_Base::C_Attlist::SetClass(CMstack_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMstack_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMstack_Base::C_Attlist::TClass& CMstack_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMstack_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMstack_Base::C_Attlist::TStyle& CMstack_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMstack_Base::C_Attlist::SetStyle(const CMstack_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMstack_Base::C_Attlist::SetStyle(CMstack_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMstack_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMstack_Base::C_Attlist::TStyle& CMstack_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMstack_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMstack_Base::C_Attlist::THref& CMstack_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMstack_Base::C_Attlist::SetHref(const CMstack_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMstack_Base::C_Attlist::SetHref(CMstack_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMstack_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMstack_Base::C_Attlist::THref& CMstack_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMstack_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMstack_Base::C_Attlist::TMathcolor& CMstack_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMstack_Base::C_Attlist::SetMathcolor(const CMstack_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMstack_Base::C_Attlist::SetMathcolor(CMstack_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMstack_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMstack_Base::C_Attlist::TMathcolor& CMstack_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMstack_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMstack_Base::C_Attlist::TMathbackground& CMstack_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMstack_Base::C_Attlist::SetMathbackground(const CMstack_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMstack_Base::C_Attlist::SetMathbackground(CMstack_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMstack_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMstack_Base::C_Attlist::TMathbackground& CMstack_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMstack_Base::C_Attlist::IsSetAlign(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetAlign(void) const
{
    return IsSetAlign();
}

inline
const CMstack_Base::C_Attlist::TAlign& CMstack_Base::C_Attlist::GetAlign(void) const
{
    if (!CanGetAlign()) {
        ThrowUnassigned(7);
    }
    return m_Align;
}

inline
void CMstack_Base::C_Attlist::SetAlign(const CMstack_Base::C_Attlist::TAlign& value)
{
    m_Align = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMstack_Base::C_Attlist::SetAlign(CMstack_Base::C_Attlist::TAlign&& value)
{
    m_Align = std::forward<CMstack_Base::C_Attlist::TAlign>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMstack_Base::C_Attlist::TAlign& CMstack_Base::C_Attlist::SetAlign(void)
{
#ifdef _DEBUG
    if (!IsSetAlign()) {
        m_Align = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Align;
}

inline
bool CMstack_Base::C_Attlist::IsSetStackalign(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetStackalign(void) const
{
    return IsSetStackalign();
}

inline
void CMstack_Base::C_Attlist::ResetStackalign(void)
{
    m_Stackalign = (EAttlist_stackalign)(0);
    m_set_State[0] &= ~0x30000;
}

inline
CMstack_Base::C_Attlist::TStackalign CMstack_Base::C_Attlist::GetStackalign(void) const
{
    if (!CanGetStackalign()) {
        ThrowUnassigned(8);
    }
    return m_Stackalign;
}

inline
void CMstack_Base::C_Attlist::SetStackalign(CMstack_Base::C_Attlist::TStackalign value)
{
    m_Stackalign = value;
    m_set_State[0] |= 0x30000;
}

inline
CMstack_Base::C_Attlist::TStackalign& CMstack_Base::C_Attlist::SetStackalign(void)
{
#ifdef _DEBUG
    if (!IsSetStackalign()) {
        memset(&m_Stackalign,UnassignedByte(),sizeof(m_Stackalign));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Stackalign;
}

inline
bool CMstack_Base::C_Attlist::IsSetCharalign(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetCharalign(void) const
{
    return IsSetCharalign();
}

inline
void CMstack_Base::C_Attlist::ResetCharalign(void)
{
    m_Charalign = (EAttlist_charalign)(0);
    m_set_State[0] &= ~0xc0000;
}

inline
CMstack_Base::C_Attlist::TCharalign CMstack_Base::C_Attlist::GetCharalign(void) const
{
    if (!CanGetCharalign()) {
        ThrowUnassigned(9);
    }
    return m_Charalign;
}

inline
void CMstack_Base::C_Attlist::SetCharalign(CMstack_Base::C_Attlist::TCharalign value)
{
    m_Charalign = value;
    m_set_State[0] |= 0xc0000;
}

inline
CMstack_Base::C_Attlist::TCharalign& CMstack_Base::C_Attlist::SetCharalign(void)
{
#ifdef _DEBUG
    if (!IsSetCharalign()) {
        memset(&m_Charalign,UnassignedByte(),sizeof(m_Charalign));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Charalign;
}

inline
bool CMstack_Base::C_Attlist::IsSetCharspacing(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMstack_Base::C_Attlist::CanGetCharspacing(void) const
{
    return IsSetCharspacing();
}

inline
const CMstack_Base::C_Attlist::TCharspacing& CMstack_Base::C_Attlist::GetCharspacing(void) const
{
    if (!CanGetCharspacing()) {
        ThrowUnassigned(10);
    }
    return m_Charspacing;
}

inline
void CMstack_Base::C_Attlist::SetCharspacing(const CMstack_Base::C_Attlist::TCharspacing& value)
{
    m_Charspacing = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMstack_Base::C_Attlist::SetCharspacing(CMstack_Base::C_Attlist::TCharspacing&& value)
{
    m_Charspacing = std::forward<CMstack_Base::C_Attlist::TCharspacing>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMstack_Base::C_Attlist::TCharspacing& CMstack_Base::C_Attlist::SetCharspacing(void)
{
#ifdef _DEBUG
    if (!IsSetCharspacing()) {
        m_Charspacing = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Charspacing;
}

inline
CMstack_Base::C_E_MstackExpression::C_E_MstackExpression(void)
{
}

inline
bool CMstack_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMstack_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMstack_Base::TAttlist& CMstack_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMstack_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMstack_Base::TAttlist& CMstack_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMstack_Base::IsSetMstackExpression(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMstack_Base::CanGetMstackExpression(void) const
{
    return true;
}

inline
const CMstack_Base::TMstackExpression& CMstack_Base::GetMstackExpression(void) const
{
    return m_MstackExpression;
}

inline
CMstack_Base::TMstackExpression& CMstack_Base::SetMstackExpression(void)
{
    m_set_State[0] |= 0x4;
    return m_MstackExpression;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MSTACK_BASE_HPP
