/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mpadded_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_MPADDED_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_MPADDED_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objtools/eutils/efetch/ImpliedMrow.hpp>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMpadded_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CMpadded_Base(void);
    // destructor
    virtual ~CMpadded_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
        typedef NCBI_NS_STD::string TMathcolor;
        typedef NCBI_NS_STD::string TMathbackground;
        typedef NCBI_NS_STD::string THeight;
        typedef NCBI_NS_STD::string TDepth;
        typedef NCBI_NS_STD::string TWidth;
        typedef NCBI_NS_STD::string TLspace;
        typedef NCBI_NS_STD::string TVoffset;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href,
            e_mathcolor,
            e_mathbackground,
            e_height,
            e_depth,
            e_width,
            e_lspace,
            e_voffset
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathcolor
        ///  Check whether the Mathcolor data member has been assigned a value.
        bool IsSetMathcolor(void) const;
        /// Check whether it is safe or not to call GetMathcolor method.
        bool CanGetMathcolor(void) const;
        void ResetMathcolor(void);
        const TMathcolor& GetMathcolor(void) const;
        void SetMathcolor(const TMathcolor& value);
        void SetMathcolor(TMathcolor&& value);
        TMathcolor& SetMathcolor(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TMathbackground
        ///  Check whether the Mathbackground data member has been assigned a value.
        bool IsSetMathbackground(void) const;
        /// Check whether it is safe or not to call GetMathbackground method.
        bool CanGetMathbackground(void) const;
        void ResetMathbackground(void);
        const TMathbackground& GetMathbackground(void) const;
        void SetMathbackground(const TMathbackground& value);
        void SetMathbackground(TMathbackground&& value);
        TMathbackground& SetMathbackground(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THeight
        ///  Check whether the Height data member has been assigned a value.
        bool IsSetHeight(void) const;
        /// Check whether it is safe or not to call GetHeight method.
        bool CanGetHeight(void) const;
        void ResetHeight(void);
        const THeight& GetHeight(void) const;
        void SetHeight(const THeight& value);
        void SetHeight(THeight&& value);
        THeight& SetHeight(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TDepth
        ///  Check whether the Depth data member has been assigned a value.
        bool IsSetDepth(void) const;
        /// Check whether it is safe or not to call GetDepth method.
        bool CanGetDepth(void) const;
        void ResetDepth(void);
        const TDepth& GetDepth(void) const;
        void SetDepth(const TDepth& value);
        void SetDepth(TDepth&& value);
        TDepth& SetDepth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TWidth
        ///  Check whether the Width data member has been assigned a value.
        bool IsSetWidth(void) const;
        /// Check whether it is safe or not to call GetWidth method.
        bool CanGetWidth(void) const;
        void ResetWidth(void);
        const TWidth& GetWidth(void) const;
        void SetWidth(const TWidth& value);
        void SetWidth(TWidth&& value);
        TWidth& SetWidth(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TLspace
        ///  Check whether the Lspace data member has been assigned a value.
        bool IsSetLspace(void) const;
        /// Check whether it is safe or not to call GetLspace method.
        bool CanGetLspace(void) const;
        void ResetLspace(void);
        const TLspace& GetLspace(void) const;
        void SetLspace(const TLspace& value);
        void SetLspace(TLspace&& value);
        TLspace& SetLspace(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TVoffset
        ///  Check whether the Voffset data member has been assigned a value.
        bool IsSetVoffset(void) const;
        /// Check whether it is safe or not to call GetVoffset method.
        bool CanGetVoffset(void) const;
        void ResetVoffset(void);
        const TVoffset& GetVoffset(void) const;
        void SetVoffset(const TVoffset& value);
        void SetVoffset(TVoffset&& value);
        TVoffset& SetVoffset(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
        NCBI_NS_STD::string m_Mathcolor;
        NCBI_NS_STD::string m_Mathbackground;
        NCBI_NS_STD::string m_Height;
        NCBI_NS_STD::string m_Depth;
        NCBI_NS_STD::string m_Width;
        NCBI_NS_STD::string m_Lspace;
        NCBI_NS_STD::string m_Voffset;
    };
    typedef CImpliedMrow C_Mpadded;
    // types
    typedef C_Attlist TAttlist;
    typedef C_Mpadded TMpadded;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_mpadded
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_Mpadded TMpadded
    ///  Check whether the Mpadded data member has been assigned a value.
    bool IsSetMpadded(void) const;
    /// Check whether it is safe or not to call GetMpadded method.
    bool CanGetMpadded(void) const;
    void ResetMpadded(void);
    const TMpadded& GetMpadded(void) const;
    void SetMpadded(TMpadded& value);
    TMpadded& SetMpadded(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMpadded_Base(const CMpadded_Base&);
    CMpadded_Base& operator=(const CMpadded_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TMpadded > m_Mpadded;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMpadded_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CMpadded_Base::C_Attlist::TId& CMpadded_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CMpadded_Base::C_Attlist::SetId(const CMpadded_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CMpadded_Base::C_Attlist::SetId(CMpadded_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CMpadded_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CMpadded_Base::C_Attlist::TId& CMpadded_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CMpadded_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CMpadded_Base::C_Attlist::TXref& CMpadded_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CMpadded_Base::C_Attlist::SetXref(const CMpadded_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CMpadded_Base::C_Attlist::SetXref(CMpadded_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CMpadded_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CMpadded_Base::C_Attlist::TXref& CMpadded_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CMpadded_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CMpadded_Base::C_Attlist::TClass& CMpadded_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CMpadded_Base::C_Attlist::SetClass(const CMpadded_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CMpadded_Base::C_Attlist::SetClass(CMpadded_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CMpadded_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CMpadded_Base::C_Attlist::TClass& CMpadded_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CMpadded_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CMpadded_Base::C_Attlist::TStyle& CMpadded_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CMpadded_Base::C_Attlist::SetStyle(const CMpadded_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CMpadded_Base::C_Attlist::SetStyle(CMpadded_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CMpadded_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CMpadded_Base::C_Attlist::TStyle& CMpadded_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CMpadded_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CMpadded_Base::C_Attlist::THref& CMpadded_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CMpadded_Base::C_Attlist::SetHref(const CMpadded_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CMpadded_Base::C_Attlist::SetHref(CMpadded_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CMpadded_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CMpadded_Base::C_Attlist::THref& CMpadded_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CMpadded_Base::C_Attlist::IsSetMathcolor(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetMathcolor(void) const
{
    return IsSetMathcolor();
}

inline
const CMpadded_Base::C_Attlist::TMathcolor& CMpadded_Base::C_Attlist::GetMathcolor(void) const
{
    if (!CanGetMathcolor()) {
        ThrowUnassigned(5);
    }
    return m_Mathcolor;
}

inline
void CMpadded_Base::C_Attlist::SetMathcolor(const CMpadded_Base::C_Attlist::TMathcolor& value)
{
    m_Mathcolor = value;
    m_set_State[0] |= 0xc00;
}

inline
void CMpadded_Base::C_Attlist::SetMathcolor(CMpadded_Base::C_Attlist::TMathcolor&& value)
{
    m_Mathcolor = std::forward<CMpadded_Base::C_Attlist::TMathcolor>(value);
    m_set_State[0] |= 0xc00;
}

inline
CMpadded_Base::C_Attlist::TMathcolor& CMpadded_Base::C_Attlist::SetMathcolor(void)
{
#ifdef _DEBUG
    if (!IsSetMathcolor()) {
        m_Mathcolor = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Mathcolor;
}

inline
bool CMpadded_Base::C_Attlist::IsSetMathbackground(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetMathbackground(void) const
{
    return IsSetMathbackground();
}

inline
const CMpadded_Base::C_Attlist::TMathbackground& CMpadded_Base::C_Attlist::GetMathbackground(void) const
{
    if (!CanGetMathbackground()) {
        ThrowUnassigned(6);
    }
    return m_Mathbackground;
}

inline
void CMpadded_Base::C_Attlist::SetMathbackground(const CMpadded_Base::C_Attlist::TMathbackground& value)
{
    m_Mathbackground = value;
    m_set_State[0] |= 0x3000;
}

inline
void CMpadded_Base::C_Attlist::SetMathbackground(CMpadded_Base::C_Attlist::TMathbackground&& value)
{
    m_Mathbackground = std::forward<CMpadded_Base::C_Attlist::TMathbackground>(value);
    m_set_State[0] |= 0x3000;
}

inline
CMpadded_Base::C_Attlist::TMathbackground& CMpadded_Base::C_Attlist::SetMathbackground(void)
{
#ifdef _DEBUG
    if (!IsSetMathbackground()) {
        m_Mathbackground = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Mathbackground;
}

inline
bool CMpadded_Base::C_Attlist::IsSetHeight(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetHeight(void) const
{
    return IsSetHeight();
}

inline
const CMpadded_Base::C_Attlist::THeight& CMpadded_Base::C_Attlist::GetHeight(void) const
{
    if (!CanGetHeight()) {
        ThrowUnassigned(7);
    }
    return m_Height;
}

inline
void CMpadded_Base::C_Attlist::SetHeight(const CMpadded_Base::C_Attlist::THeight& value)
{
    m_Height = value;
    m_set_State[0] |= 0xc000;
}

inline
void CMpadded_Base::C_Attlist::SetHeight(CMpadded_Base::C_Attlist::THeight&& value)
{
    m_Height = std::forward<CMpadded_Base::C_Attlist::THeight>(value);
    m_set_State[0] |= 0xc000;
}

inline
CMpadded_Base::C_Attlist::THeight& CMpadded_Base::C_Attlist::SetHeight(void)
{
#ifdef _DEBUG
    if (!IsSetHeight()) {
        m_Height = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Height;
}

inline
bool CMpadded_Base::C_Attlist::IsSetDepth(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetDepth(void) const
{
    return IsSetDepth();
}

inline
const CMpadded_Base::C_Attlist::TDepth& CMpadded_Base::C_Attlist::GetDepth(void) const
{
    if (!CanGetDepth()) {
        ThrowUnassigned(8);
    }
    return m_Depth;
}

inline
void CMpadded_Base::C_Attlist::SetDepth(const CMpadded_Base::C_Attlist::TDepth& value)
{
    m_Depth = value;
    m_set_State[0] |= 0x30000;
}

inline
void CMpadded_Base::C_Attlist::SetDepth(CMpadded_Base::C_Attlist::TDepth&& value)
{
    m_Depth = std::forward<CMpadded_Base::C_Attlist::TDepth>(value);
    m_set_State[0] |= 0x30000;
}

inline
CMpadded_Base::C_Attlist::TDepth& CMpadded_Base::C_Attlist::SetDepth(void)
{
#ifdef _DEBUG
    if (!IsSetDepth()) {
        m_Depth = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Depth;
}

inline
bool CMpadded_Base::C_Attlist::IsSetWidth(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetWidth(void) const
{
    return IsSetWidth();
}

inline
const CMpadded_Base::C_Attlist::TWidth& CMpadded_Base::C_Attlist::GetWidth(void) const
{
    if (!CanGetWidth()) {
        ThrowUnassigned(9);
    }
    return m_Width;
}

inline
void CMpadded_Base::C_Attlist::SetWidth(const CMpadded_Base::C_Attlist::TWidth& value)
{
    m_Width = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMpadded_Base::C_Attlist::SetWidth(CMpadded_Base::C_Attlist::TWidth&& value)
{
    m_Width = std::forward<CMpadded_Base::C_Attlist::TWidth>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMpadded_Base::C_Attlist::TWidth& CMpadded_Base::C_Attlist::SetWidth(void)
{
#ifdef _DEBUG
    if (!IsSetWidth()) {
        m_Width = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Width;
}

inline
bool CMpadded_Base::C_Attlist::IsSetLspace(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetLspace(void) const
{
    return IsSetLspace();
}

inline
const CMpadded_Base::C_Attlist::TLspace& CMpadded_Base::C_Attlist::GetLspace(void) const
{
    if (!CanGetLspace()) {
        ThrowUnassigned(10);
    }
    return m_Lspace;
}

inline
void CMpadded_Base::C_Attlist::SetLspace(const CMpadded_Base::C_Attlist::TLspace& value)
{
    m_Lspace = value;
    m_set_State[0] |= 0x300000;
}

inline
void CMpadded_Base::C_Attlist::SetLspace(CMpadded_Base::C_Attlist::TLspace&& value)
{
    m_Lspace = std::forward<CMpadded_Base::C_Attlist::TLspace>(value);
    m_set_State[0] |= 0x300000;
}

inline
CMpadded_Base::C_Attlist::TLspace& CMpadded_Base::C_Attlist::SetLspace(void)
{
#ifdef _DEBUG
    if (!IsSetLspace()) {
        m_Lspace = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Lspace;
}

inline
bool CMpadded_Base::C_Attlist::IsSetVoffset(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CMpadded_Base::C_Attlist::CanGetVoffset(void) const
{
    return IsSetVoffset();
}

inline
const CMpadded_Base::C_Attlist::TVoffset& CMpadded_Base::C_Attlist::GetVoffset(void) const
{
    if (!CanGetVoffset()) {
        ThrowUnassigned(11);
    }
    return m_Voffset;
}

inline
void CMpadded_Base::C_Attlist::SetVoffset(const CMpadded_Base::C_Attlist::TVoffset& value)
{
    m_Voffset = value;
    m_set_State[0] |= 0xc00000;
}

inline
void CMpadded_Base::C_Attlist::SetVoffset(CMpadded_Base::C_Attlist::TVoffset&& value)
{
    m_Voffset = std::forward<CMpadded_Base::C_Attlist::TVoffset>(value);
    m_set_State[0] |= 0xc00000;
}

inline
CMpadded_Base::C_Attlist::TVoffset& CMpadded_Base::C_Attlist::SetVoffset(void)
{
#ifdef _DEBUG
    if (!IsSetVoffset()) {
        m_Voffset = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Voffset;
}

inline
bool CMpadded_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CMpadded_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CMpadded_Base::TAttlist& CMpadded_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CMpadded_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CMpadded_Base::TAttlist& CMpadded_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CMpadded_Base::IsSetMpadded(void) const
{
    return m_Mpadded.NotEmpty();
}

inline
bool CMpadded_Base::CanGetMpadded(void) const
{
    return true;
}

inline
const CMpadded_Base::TMpadded& CMpadded_Base::GetMpadded(void) const
{
    if ( !m_Mpadded ) {
        const_cast<CMpadded_Base*>(this)->ResetMpadded();
    }
    return (*m_Mpadded);
}

inline
CMpadded_Base::TMpadded& CMpadded_Base::SetMpadded(void)
{
    if ( !m_Mpadded ) {
        ResetMpadded();
    }
    return (*m_Mpadded);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_MPADDED_BASE_HPP
