/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Journal_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_JOURNAL_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_JOURNAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CISOAbbreviation;
class CISSN;
class CJournalIssue;
class CPubmedTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CJournal_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CJournal_Base(void);
    // destructor
    virtual ~CJournal_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CISSN TISSN;
    typedef CJournalIssue TJournalIssue;
    typedef CPubmedTitle TTitle;
    typedef CISOAbbreviation TISOAbbreviation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ISSN,
        e_JournalIssue,
        e_Title,
        e_ISOAbbreviation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CISSN TISSN
    ///  Check whether the ISSN data member has been assigned a value.
    bool IsSetISSN(void) const;
    /// Check whether it is safe or not to call GetISSN method.
    bool CanGetISSN(void) const;
    void ResetISSN(void);
    const TISSN& GetISSN(void) const;
    void SetISSN(TISSN& value);
    TISSN& SetISSN(void);
    void SetISSN(const NCBI_NS_STD::string& value);

    /// mandatory
    /// typedef CJournalIssue TJournalIssue
    ///  Check whether the JournalIssue data member has been assigned a value.
    bool IsSetJournalIssue(void) const;
    /// Check whether it is safe or not to call GetJournalIssue method.
    bool CanGetJournalIssue(void) const;
    void ResetJournalIssue(void);
    const TJournalIssue& GetJournalIssue(void) const;
    void SetJournalIssue(TJournalIssue& value);
    TJournalIssue& SetJournalIssue(void);

    /// optional
    /// typedef CPubmedTitle TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(TTitle& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef CISOAbbreviation TISOAbbreviation
    ///  Check whether the ISOAbbreviation data member has been assigned a value.
    bool IsSetISOAbbreviation(void) const;
    /// Check whether it is safe or not to call GetISOAbbreviation method.
    bool CanGetISOAbbreviation(void) const;
    void ResetISOAbbreviation(void);
    const TISOAbbreviation& GetISOAbbreviation(void) const;
    void SetISOAbbreviation(TISOAbbreviation& value);
    TISOAbbreviation& SetISOAbbreviation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CJournal_Base(const CJournal_Base&);
    CJournal_Base& operator=(const CJournal_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TISSN > m_ISSN;
    NCBI_NS_NCBI::CRef< TJournalIssue > m_JournalIssue;
    NCBI_NS_NCBI::CRef< TTitle > m_Title;
    NCBI_NS_NCBI::CRef< TISOAbbreviation > m_ISOAbbreviation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CJournal_Base::IsSetISSN(void) const
{
    return m_ISSN.NotEmpty();
}

inline
bool CJournal_Base::CanGetISSN(void) const
{
    return IsSetISSN();
}

inline
const CJournal_Base::TISSN& CJournal_Base::GetISSN(void) const
{
    if (!CanGetISSN()) {
        ThrowUnassigned(0);
    }
    return (*m_ISSN);
}

inline
bool CJournal_Base::IsSetJournalIssue(void) const
{
    return m_JournalIssue.NotEmpty();
}

inline
bool CJournal_Base::CanGetJournalIssue(void) const
{
    return true;
}

inline
const CJournal_Base::TJournalIssue& CJournal_Base::GetJournalIssue(void) const
{
    if ( !m_JournalIssue ) {
        const_cast<CJournal_Base*>(this)->ResetJournalIssue();
    }
    return (*m_JournalIssue);
}

inline
CJournal_Base::TJournalIssue& CJournal_Base::SetJournalIssue(void)
{
    if ( !m_JournalIssue ) {
        ResetJournalIssue();
    }
    return (*m_JournalIssue);
}

inline
bool CJournal_Base::IsSetTitle(void) const
{
    return m_Title.NotEmpty();
}

inline
bool CJournal_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CJournal_Base::TTitle& CJournal_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(2);
    }
    return (*m_Title);
}

inline
bool CJournal_Base::IsSetISOAbbreviation(void) const
{
    return m_ISOAbbreviation.NotEmpty();
}

inline
bool CJournal_Base::CanGetISOAbbreviation(void) const
{
    return IsSetISOAbbreviation();
}

inline
const CJournal_Base::TISOAbbreviation& CJournal_Base::GetISOAbbreviation(void) const
{
    if (!CanGetISOAbbreviation()) {
        ThrowUnassigned(3);
    }
    return (*m_ISOAbbreviation);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_JOURNAL_BASE_HPP
