/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Identifier_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_IDENTIFIER_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_IDENTIFIER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CIdentifier_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CIdentifier_Base(void);
    // destructor
    virtual ~CIdentifier_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TSource;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_Source
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef NCBI_NS_STD::string TSource
        ///  Check whether the Source data member has been assigned a value.
        bool IsSetSource(void) const;
        /// Check whether it is safe or not to call GetSource method.
        bool CanGetSource(void) const;
        void ResetSource(void);
        const TSource& GetSource(void) const;
        void SetSource(const TSource& value);
        void SetSource(TSource&& value);
        TSource& SetSource(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Source;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef NCBI_NS_STD::string TIdentifier;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_Identifier
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef NCBI_NS_STD::string TIdentifier
    ///  Check whether the Identifier data member has been assigned a value.
    bool IsSetIdentifier(void) const;
    /// Check whether it is safe or not to call GetIdentifier method.
    bool CanGetIdentifier(void) const;
    void ResetIdentifier(void);
    const TIdentifier& GetIdentifier(void) const;
    void SetIdentifier(const TIdentifier& value);
    void SetIdentifier(TIdentifier&& value);
    TIdentifier& SetIdentifier(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CIdentifier_Base(const CIdentifier_Base&);
    CIdentifier_Base& operator=(const CIdentifier_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_STD::string m_Identifier;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CIdentifier_Base::C_Attlist::IsSetSource(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CIdentifier_Base::C_Attlist::CanGetSource(void) const
{
    return IsSetSource();
}

inline
const CIdentifier_Base::C_Attlist::TSource& CIdentifier_Base::C_Attlist::GetSource(void) const
{
    if (!CanGetSource()) {
        ThrowUnassigned(0);
    }
    return m_Source;
}

inline
void CIdentifier_Base::C_Attlist::SetSource(const CIdentifier_Base::C_Attlist::TSource& value)
{
    m_Source = value;
    m_set_State[0] |= 0x3;
}

inline
void CIdentifier_Base::C_Attlist::SetSource(CIdentifier_Base::C_Attlist::TSource&& value)
{
    m_Source = std::forward<CIdentifier_Base::C_Attlist::TSource>(value);
    m_set_State[0] |= 0x3;
}

inline
CIdentifier_Base::C_Attlist::TSource& CIdentifier_Base::C_Attlist::SetSource(void)
{
#ifdef _DEBUG
    if (!IsSetSource()) {
        m_Source = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Source;
}

inline
bool CIdentifier_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CIdentifier_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CIdentifier_Base::TAttlist& CIdentifier_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CIdentifier_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CIdentifier_Base::TAttlist& CIdentifier_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CIdentifier_Base::IsSetIdentifier(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CIdentifier_Base::CanGetIdentifier(void) const
{
    return IsSetIdentifier();
}

inline
const CIdentifier_Base::TIdentifier& CIdentifier_Base::GetIdentifier(void) const
{
    if (!CanGetIdentifier()) {
        ThrowUnassigned(1);
    }
    return m_Identifier;
}

inline
void CIdentifier_Base::SetIdentifier(const CIdentifier_Base::TIdentifier& value)
{
    m_Identifier = value;
    m_set_State[0] |= 0xc;
}

inline
void CIdentifier_Base::SetIdentifier(CIdentifier_Base::TIdentifier&& value)
{
    m_Identifier = std::forward<CIdentifier_Base::TIdentifier>(value);
    m_set_State[0] |= 0xc;
}

inline
CIdentifier_Base::TIdentifier& CIdentifier_Base::SetIdentifier(void)
{
#ifdef _DEBUG
    if (!IsSetIdentifier()) {
        m_Identifier = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Identifier;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_IDENTIFIER_BASE_HPP
