/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Csymbol_content_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_CSYMBOL_CONTENT_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_CSYMBOL_CONTENT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CMaction;
class CMaligngroup;
class CMalignmark;
class CMenclose;
class CMerror;
class CMfenced;
class CMfrac;
class CMglyph;
class CMi;
class CMlongdiv;
class CMmultiscripts;
class CMn;
class CMo;
class CMover;
class CMpadded;
class CMphantom;
class CMroot;
class CMrow;
class CMs;
class CMspace;
class CMsqrt;
class CMstack;
class CMstyle;
class CMsub;
class CMsubsup;
class CMsup;
class CMtable;
class CMtext;
class CMunder;
class CMunderover;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCsymbol_content_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CCsymbol_content_Base(void);
    // destructor
    virtual ~CCsymbol_content_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_E : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_E(void);
        // destructor
        ~C_E(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class C_PresentationExpression : public NCBI_NS_NCBI::CSerialObject
        {
            typedef NCBI_NS_NCBI::CSerialObject Tparent;
        public:
            // constructor
            C_PresentationExpression(void);
            // destructor
            ~C_PresentationExpression(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            /////////////////////////////////////////////////////////////////////////////
            class C_TokenExpression : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_TokenExpression(void);
                // destructor
                ~C_TokenExpression(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Mi,
                    e_Mn,
                    e_Mo,
                    e_Mtext,
                    e_Mspace,
                    e_Ms
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 7 ///< == e_Ms+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CMi TMi;
                typedef CMn TMn;
                typedef CMo TMo;
                typedef CMtext TMtext;
                typedef CMspace TMspace;
                typedef CMs TMs;
            
                // getters
                // setters
            
                // typedef CMi TMi
                bool IsMi(void) const;
                const TMi& GetMi(void) const;
                TMi& SetMi(void);
                void SetMi(TMi& value);
            
                // typedef CMn TMn
                bool IsMn(void) const;
                const TMn& GetMn(void) const;
                TMn& SetMn(void);
                void SetMn(TMn& value);
            
                // typedef CMo TMo
                bool IsMo(void) const;
                const TMo& GetMo(void) const;
                TMo& SetMo(void);
                void SetMo(TMo& value);
            
                // typedef CMtext TMtext
                bool IsMtext(void) const;
                const TMtext& GetMtext(void) const;
                TMtext& SetMtext(void);
                void SetMtext(TMtext& value);
            
                // typedef CMspace TMspace
                bool IsMspace(void) const;
                const TMspace& GetMspace(void) const;
                TMspace& SetMspace(void);
            
                // typedef CMs TMs
                bool IsMs(void) const;
                const TMs& GetMs(void) const;
                TMs& SetMs(void);
                void SetMs(TMs& value);
            
            
            private:
                // copy constructor and assignment operator
                C_TokenExpression(const C_TokenExpression& );
                C_TokenExpression& operator=(const C_TokenExpression& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
            /////////////////////////////////////////////////////////////////////////////
            class C_MalignExpression : public NCBI_NS_NCBI::CSerialObject
            {
                typedef NCBI_NS_NCBI::CSerialObject Tparent;
            public:
                // constructor
                C_MalignExpression(void);
                // destructor
                ~C_MalignExpression(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
            
                /// Choice variants.
                enum E_Choice {
                    e_not_set = 0,  ///< No variant selected
                    e_Maligngroup,
                    e_Malignmark
                };
                /// Maximum+1 value of the choice variant enumerator.
                enum E_ChoiceStopper {
                    e_MaxChoice = 3 ///< == e_Malignmark+1
                };
            
                /// Reset the whole object
                void Reset(void);
            
                /// Reset the selection (set it to e_not_set).
                void ResetSelection(void);
            
                /// Which variant is currently selected.
                E_Choice Which(void) const;
            
                /// Verify selection, throw exception if it differs from the expected.
                void CheckSelected(E_Choice index) const;
            
                /// Throw 'InvalidSelection' exception.
                NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
            
                /// Retrieve selection name (for diagnostic purposes).
                static NCBI_NS_STD::string SelectionName(E_Choice index);
            
                /// Select the requested variant if needed.
                void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
                /// Select the requested variant if needed,
                /// allocating CObject variants from memory pool.
                void Select(E_Choice index,
                            NCBI_NS_NCBI::EResetVariant reset,
                            NCBI_NS_NCBI::CObjectMemoryPool* pool);
            
                // types
                typedef CMaligngroup TMaligngroup;
                typedef CMalignmark TMalignmark;
            
                // getters
                // setters
            
                // typedef CMaligngroup TMaligngroup
                bool IsMaligngroup(void) const;
                const TMaligngroup& GetMaligngroup(void) const;
                TMaligngroup& SetMaligngroup(void);
            
                // typedef CMalignmark TMalignmark
                bool IsMalignmark(void) const;
                const TMalignmark& GetMalignmark(void) const;
                TMalignmark& SetMalignmark(void);
            
            
            private:
                // copy constructor and assignment operator
                C_MalignExpression(const C_MalignExpression& );
                C_MalignExpression& operator=(const C_MalignExpression& );
                // choice state
                E_Choice m_choice;
                // helper methods
                void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
            
                static const char* const sm_SelectionNames[];
                // data
                NCBI_NS_NCBI::CSerialObject *m_object;
            };
        
            /// Choice variants.
            enum E_Choice {
                e_not_set = 0,       ///< No variant selected
                e_TokenExpression,
                e_MalignExpression,
                e_Mrow,
                e_Mfrac,
                e_Msqrt,
                e_Mroot,
                e_Mstyle,
                e_Merror,
                e_Mpadded,
                e_Mphantom,
                e_Mfenced,
                e_Menclose,
                e_Msub,
                e_Msup,
                e_Msubsup,
                e_Munder,
                e_Mover,
                e_Munderover,
                e_Mmultiscripts,
                e_Mtable,
                e_Mstack,
                e_Mlongdiv,
                e_Maction
            };
            /// Maximum+1 value of the choice variant enumerator.
            enum E_ChoiceStopper {
                e_MaxChoice = 24 ///< == e_Maction+1
            };
        
            /// Reset the whole object
            void Reset(void);
        
            /// Reset the selection (set it to e_not_set).
            void ResetSelection(void);
        
            /// Which variant is currently selected.
            E_Choice Which(void) const;
        
            /// Verify selection, throw exception if it differs from the expected.
            void CheckSelected(E_Choice index) const;
        
            /// Throw 'InvalidSelection' exception.
            NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
        
            /// Retrieve selection name (for diagnostic purposes).
            static NCBI_NS_STD::string SelectionName(E_Choice index);
        
            /// Select the requested variant if needed.
            void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
            /// Select the requested variant if needed,
            /// allocating CObject variants from memory pool.
            void Select(E_Choice index,
                        NCBI_NS_NCBI::EResetVariant reset,
                        NCBI_NS_NCBI::CObjectMemoryPool* pool);
        
            // types
            typedef C_TokenExpression TTokenExpression;
            typedef C_MalignExpression TMalignExpression;
            typedef CMrow TMrow;
            typedef CMfrac TMfrac;
            typedef CMsqrt TMsqrt;
            typedef CMroot TMroot;
            typedef CMstyle TMstyle;
            typedef CMerror TMerror;
            typedef CMpadded TMpadded;
            typedef CMphantom TMphantom;
            typedef CMfenced TMfenced;
            typedef CMenclose TMenclose;
            typedef CMsub TMsub;
            typedef CMsup TMsup;
            typedef CMsubsup TMsubsup;
            typedef CMunder TMunder;
            typedef CMover TMover;
            typedef CMunderover TMunderover;
            typedef CMmultiscripts TMmultiscripts;
            typedef CMtable TMtable;
            typedef CMstack TMstack;
            typedef CMlongdiv TMlongdiv;
            typedef CMaction TMaction;
        
            // getters
            // setters
        
            // typedef C_TokenExpression TTokenExpression
            bool IsTokenExpression(void) const;
            const TTokenExpression& GetTokenExpression(void) const;
            TTokenExpression& SetTokenExpression(void);
            void SetTokenExpression(TTokenExpression& value);
        
            // typedef C_MalignExpression TMalignExpression
            bool IsMalignExpression(void) const;
            const TMalignExpression& GetMalignExpression(void) const;
            TMalignExpression& SetMalignExpression(void);
            void SetMalignExpression(TMalignExpression& value);
        
            // typedef CMrow TMrow
            bool IsMrow(void) const;
            const TMrow& GetMrow(void) const;
            TMrow& SetMrow(void);
            void SetMrow(TMrow& value);
        
            // typedef CMfrac TMfrac
            bool IsMfrac(void) const;
            const TMfrac& GetMfrac(void) const;
            TMfrac& SetMfrac(void);
            void SetMfrac(TMfrac& value);
        
            // typedef CMsqrt TMsqrt
            bool IsMsqrt(void) const;
            const TMsqrt& GetMsqrt(void) const;
            TMsqrt& SetMsqrt(void);
            void SetMsqrt(TMsqrt& value);
        
            // typedef CMroot TMroot
            bool IsMroot(void) const;
            const TMroot& GetMroot(void) const;
            TMroot& SetMroot(void);
            void SetMroot(TMroot& value);
        
            // typedef CMstyle TMstyle
            bool IsMstyle(void) const;
            const TMstyle& GetMstyle(void) const;
            TMstyle& SetMstyle(void);
            void SetMstyle(TMstyle& value);
        
            // typedef CMerror TMerror
            bool IsMerror(void) const;
            const TMerror& GetMerror(void) const;
            TMerror& SetMerror(void);
            void SetMerror(TMerror& value);
        
            // typedef CMpadded TMpadded
            bool IsMpadded(void) const;
            const TMpadded& GetMpadded(void) const;
            TMpadded& SetMpadded(void);
            void SetMpadded(TMpadded& value);
        
            // typedef CMphantom TMphantom
            bool IsMphantom(void) const;
            const TMphantom& GetMphantom(void) const;
            TMphantom& SetMphantom(void);
            void SetMphantom(TMphantom& value);
        
            // typedef CMfenced TMfenced
            bool IsMfenced(void) const;
            const TMfenced& GetMfenced(void) const;
            TMfenced& SetMfenced(void);
            void SetMfenced(TMfenced& value);
        
            // typedef CMenclose TMenclose
            bool IsMenclose(void) const;
            const TMenclose& GetMenclose(void) const;
            TMenclose& SetMenclose(void);
            void SetMenclose(TMenclose& value);
        
            // typedef CMsub TMsub
            bool IsMsub(void) const;
            const TMsub& GetMsub(void) const;
            TMsub& SetMsub(void);
            void SetMsub(TMsub& value);
        
            // typedef CMsup TMsup
            bool IsMsup(void) const;
            const TMsup& GetMsup(void) const;
            TMsup& SetMsup(void);
            void SetMsup(TMsup& value);
        
            // typedef CMsubsup TMsubsup
            bool IsMsubsup(void) const;
            const TMsubsup& GetMsubsup(void) const;
            TMsubsup& SetMsubsup(void);
            void SetMsubsup(TMsubsup& value);
        
            // typedef CMunder TMunder
            bool IsMunder(void) const;
            const TMunder& GetMunder(void) const;
            TMunder& SetMunder(void);
            void SetMunder(TMunder& value);
        
            // typedef CMover TMover
            bool IsMover(void) const;
            const TMover& GetMover(void) const;
            TMover& SetMover(void);
            void SetMover(TMover& value);
        
            // typedef CMunderover TMunderover
            bool IsMunderover(void) const;
            const TMunderover& GetMunderover(void) const;
            TMunderover& SetMunderover(void);
            void SetMunderover(TMunderover& value);
        
            // typedef CMmultiscripts TMmultiscripts
            bool IsMmultiscripts(void) const;
            const TMmultiscripts& GetMmultiscripts(void) const;
            TMmultiscripts& SetMmultiscripts(void);
            void SetMmultiscripts(TMmultiscripts& value);
        
            // typedef CMtable TMtable
            bool IsMtable(void) const;
            const TMtable& GetMtable(void) const;
            TMtable& SetMtable(void);
            void SetMtable(TMtable& value);
        
            // typedef CMstack TMstack
            bool IsMstack(void) const;
            const TMstack& GetMstack(void) const;
            TMstack& SetMstack(void);
            void SetMstack(TMstack& value);
        
            // typedef CMlongdiv TMlongdiv
            bool IsMlongdiv(void) const;
            const TMlongdiv& GetMlongdiv(void) const;
            TMlongdiv& SetMlongdiv(void);
            void SetMlongdiv(TMlongdiv& value);
        
            // typedef CMaction TMaction
            bool IsMaction(void) const;
            const TMaction& GetMaction(void) const;
            TMaction& SetMaction(void);
            void SetMaction(TMaction& value);
        
        
        private:
            // copy constructor and assignment operator
            C_PresentationExpression(const C_PresentationExpression& );
            C_PresentationExpression& operator=(const C_PresentationExpression& );
            // choice state
            E_Choice m_choice;
            // helper methods
            void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
        
            static const char* const sm_SelectionNames[];
            // data
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,             ///< No variant selected
            e__CharData,
            e_Mglyph,
            e_PresentationExpression
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_PresentationExpression+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static NCBI_NS_STD::string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset = NCBI_NS_NCBI::eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    NCBI_NS_NCBI::EResetVariant reset,
                    NCBI_NS_NCBI::CObjectMemoryPool* pool);
    
        // types
        typedef NCBI_NS_STD::string T_CharData;
        typedef CMglyph TMglyph;
        typedef C_PresentationExpression TPresentationExpression;
    
        // getters
        // setters
    
        // typedef NCBI_NS_STD::string T_CharData
        bool Is_CharData(void) const;
        const T_CharData& Get_CharData(void) const;
        T_CharData& Set_CharData(void);
        void Set_CharData(const T_CharData& value);
    
        // typedef CMglyph TMglyph
        bool IsMglyph(void) const;
        const TMglyph& GetMglyph(void) const;
        TMglyph& SetMglyph(void);
    
        // typedef C_PresentationExpression TPresentationExpression
        bool IsPresentationExpression(void) const;
        const TPresentationExpression& GetPresentationExpression(void) const;
        TPresentationExpression& SetPresentationExpression(void);
        void SetPresentationExpression(TPresentationExpression& value);
    
    
    private:
        // copy constructor and assignment operator
        C_E(const C_E& );
        C_E& operator=(const C_E& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, NCBI_NS_NCBI::CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E > > Tdata;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E > > Tdata
    ///  Check whether the  data member has been assigned a value.
    bool IsSet(void) const;
    /// Check whether it is safe or not to call Get method.
    bool CanGet(void) const;
    void Reset(void);
    const Tdata& Get(void) const;
    Tdata& Set(void);

    /// Conversion operator to 'const Tdata' type.
    operator const Tdata& (void) const;
    /// Conversion operator to 'Tdata' type.
    operator Tdata& (void);



private:
    // Prohibit copy constructor and assignment operator
    CCsymbol_content_Base(const CCsymbol_content_Base&);
    CCsymbol_content_Base& operator=(const CCsymbol_content_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< C_E > > m_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::E_Choice CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::Which(void) const
{
    return m_choice;
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::IsMi(void) const
{
    return m_choice == e_Mi;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::IsMn(void) const
{
    return m_choice == e_Mn;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::IsMo(void) const
{
    return m_choice == e_Mo;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::IsMtext(void) const
{
    return m_choice == e_Mtext;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::IsMspace(void) const
{
    return m_choice == e_Mspace;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_TokenExpression::IsMs(void) const
{
    return m_choice == e_Ms;
}

inline
CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::E_Choice CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::Which(void) const
{
    return m_choice;
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::IsMaligngroup(void) const
{
    return m_choice == e_Maligngroup;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::C_MalignExpression::IsMalignmark(void) const
{
    return m_choice == e_Malignmark;
}

inline
CCsymbol_content_Base::C_E::C_PresentationExpression::E_Choice CCsymbol_content_Base::C_E::C_PresentationExpression::Which(void) const
{
    return m_choice;
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCsymbol_content_Base::C_E::C_PresentationExpression::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsTokenExpression(void) const
{
    return m_choice == e_TokenExpression;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMalignExpression(void) const
{
    return m_choice == e_MalignExpression;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMrow(void) const
{
    return m_choice == e_Mrow;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMfrac(void) const
{
    return m_choice == e_Mfrac;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMsqrt(void) const
{
    return m_choice == e_Msqrt;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMroot(void) const
{
    return m_choice == e_Mroot;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMstyle(void) const
{
    return m_choice == e_Mstyle;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMerror(void) const
{
    return m_choice == e_Merror;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMpadded(void) const
{
    return m_choice == e_Mpadded;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMphantom(void) const
{
    return m_choice == e_Mphantom;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMfenced(void) const
{
    return m_choice == e_Mfenced;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMenclose(void) const
{
    return m_choice == e_Menclose;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMsub(void) const
{
    return m_choice == e_Msub;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMsup(void) const
{
    return m_choice == e_Msup;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMsubsup(void) const
{
    return m_choice == e_Msubsup;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMunder(void) const
{
    return m_choice == e_Munder;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMover(void) const
{
    return m_choice == e_Mover;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMunderover(void) const
{
    return m_choice == e_Munderover;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMmultiscripts(void) const
{
    return m_choice == e_Mmultiscripts;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMtable(void) const
{
    return m_choice == e_Mtable;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMstack(void) const
{
    return m_choice == e_Mstack;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMlongdiv(void) const
{
    return m_choice == e_Mlongdiv;
}

inline
bool CCsymbol_content_Base::C_E::C_PresentationExpression::IsMaction(void) const
{
    return m_choice == e_Maction;
}

inline
CCsymbol_content_Base::C_E::E_Choice CCsymbol_content_Base::C_E::Which(void) const
{
    return m_choice;
}

inline
void CCsymbol_content_Base::C_E::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CCsymbol_content_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CCsymbol_content_Base::C_E::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CCsymbol_content_Base::C_E::Is_CharData(void) const
{
    return m_choice == e__CharData;
}

inline
const CCsymbol_content_Base::C_E::T_CharData& CCsymbol_content_Base::C_E::Get_CharData(void) const
{
    CheckSelected(e__CharData);
    return *m_string;
}

inline
CCsymbol_content_Base::C_E::T_CharData& CCsymbol_content_Base::C_E::Set_CharData(void)
{
    Select(e__CharData, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CCsymbol_content_Base::C_E::IsMglyph(void) const
{
    return m_choice == e_Mglyph;
}

inline
bool CCsymbol_content_Base::C_E::IsPresentationExpression(void) const
{
    return m_choice == e_PresentationExpression;
}

inline
bool CCsymbol_content_Base::IsSet(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCsymbol_content_Base::CanGet(void) const
{
    return true;
}

inline
const CCsymbol_content_Base::Tdata& CCsymbol_content_Base::Get(void) const
{
    return m_data;
}

inline
CCsymbol_content_Base::Tdata& CCsymbol_content_Base::Set(void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

inline
CCsymbol_content_Base::operator const CCsymbol_content_Base::Tdata& (void) const
{
    return m_data;
}

inline
CCsymbol_content_Base::operator CCsymbol_content_Base::Tdata& (void)
{
    m_set_State[0] |= 0x1;
    return m_data;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_CSYMBOL_CONTENT_BASE_HPP
