/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file CommentsCorrectionsList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_COMMENTSCORRECTIONSLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_COMMENTSCORRECTIONSLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CCommentsCorrections;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCommentsCorrectionsList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CCommentsCorrectionsList_Base(void);
    // destructor
    virtual ~CCommentsCorrectionsList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCommentsCorrections C_E;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CCommentsCorrections > > TCommentsCorrections;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_CommentsCorrections
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CCommentsCorrections > > TCommentsCorrections
    ///  Check whether the CommentsCorrections data member has been assigned a value.
    bool IsSetCommentsCorrections(void) const;
    /// Check whether it is safe or not to call GetCommentsCorrections method.
    bool CanGetCommentsCorrections(void) const;
    void ResetCommentsCorrections(void);
    const TCommentsCorrections& GetCommentsCorrections(void) const;
    TCommentsCorrections& SetCommentsCorrections(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCommentsCorrectionsList_Base(const CCommentsCorrectionsList_Base&);
    CCommentsCorrectionsList_Base& operator=(const CCommentsCorrectionsList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CCommentsCorrections > > m_CommentsCorrections;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCommentsCorrectionsList_Base::IsSetCommentsCorrections(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCommentsCorrectionsList_Base::CanGetCommentsCorrections(void) const
{
    return true;
}

inline
const CCommentsCorrectionsList_Base::TCommentsCorrections& CCommentsCorrectionsList_Base::GetCommentsCorrections(void) const
{
    return m_CommentsCorrections;
}

inline
CCommentsCorrectionsList_Base::TCommentsCorrections& CCommentsCorrectionsList_Base::SetCommentsCorrections(void)
{
    m_set_State[0] |= 0x1;
    return m_CommentsCorrections;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_COMMENTSCORRECTIONSLIST_BASE_HPP
