/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cerror_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_CERROR_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_CERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CContExp;
class CCsymbol;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCerror_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CCerror_Base(void);
    // destructor
    virtual ~CCerror_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class C_Attlist : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef NCBI_NS_STD::string TId;
        typedef NCBI_NS_STD::string TXref;
        typedef NCBI_NS_STD::string TClass;
        typedef NCBI_NS_STD::string TStyle;
        typedef NCBI_NS_STD::string THref;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_id,
            e_xref,
            e_class,
            e_style,
            e_href
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::string TId
        ///  Check whether the Id data member has been assigned a value.
        bool IsSetId(void) const;
        /// Check whether it is safe or not to call GetId method.
        bool CanGetId(void) const;
        void ResetId(void);
        const TId& GetId(void) const;
        void SetId(const TId& value);
        void SetId(TId&& value);
        TId& SetId(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TXref
        ///  Check whether the Xref data member has been assigned a value.
        bool IsSetXref(void) const;
        /// Check whether it is safe or not to call GetXref method.
        bool CanGetXref(void) const;
        void ResetXref(void);
        const TXref& GetXref(void) const;
        void SetXref(const TXref& value);
        void SetXref(TXref&& value);
        TXref& SetXref(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TClass
        ///  Check whether the Class data member has been assigned a value.
        bool IsSetClass(void) const;
        /// Check whether it is safe or not to call GetClass method.
        bool CanGetClass(void) const;
        void ResetClass(void);
        const TClass& GetClass(void) const;
        void SetClass(const TClass& value);
        void SetClass(TClass&& value);
        TClass& SetClass(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string TStyle
        ///  Check whether the Style data member has been assigned a value.
        bool IsSetStyle(void) const;
        /// Check whether it is safe or not to call GetStyle method.
        bool CanGetStyle(void) const;
        void ResetStyle(void);
        const TStyle& GetStyle(void) const;
        void SetStyle(const TStyle& value);
        void SetStyle(TStyle&& value);
        TStyle& SetStyle(void);
    
        /// optional
        /// typedef NCBI_NS_STD::string THref
        ///  Check whether the Href data member has been assigned a value.
        bool IsSetHref(void) const;
        /// Check whether it is safe or not to call GetHref method.
        bool CanGetHref(void) const;
        void ResetHref(void);
        const THref& GetHref(void) const;
        void SetHref(const THref& value);
        void SetHref(THref&& value);
        THref& SetHref(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::string m_Id;
        NCBI_NS_STD::string m_Xref;
        NCBI_NS_STD::string m_Class;
        NCBI_NS_STD::string m_Style;
        NCBI_NS_STD::string m_Href;
    };
    /////////////////////////////////////////////////////////////////////////////
    class C_ContExp : public NCBI_NS_NCBI::CSerialObject
    {
        typedef NCBI_NS_NCBI::CSerialObject Tparent;
    public:
        // constructor
        C_ContExp(void);
        // destructor
        ~C_ContExp(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CContExp C_E;
        typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CContExp > > TContExp;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_ContExp
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CContExp > > TContExp
        ///  Check whether the ContExp data member has been assigned a value.
        bool IsSetContExp(void) const;
        /// Check whether it is safe or not to call GetContExp method.
        bool CanGetContExp(void) const;
        void ResetContExp(void);
        const TContExp& GetContExp(void) const;
        TContExp& SetContExp(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_ContExp(const C_ContExp&);
        C_ContExp& operator=(const C_ContExp&);
    
        // data
        Uint4 m_set_State[1];
        NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CContExp > > m_ContExp;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef CCsymbol TCsymbol;
    typedef C_ContExp TContExp;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Attlist,
        e_csymbol,
        e_ContExp
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef CCsymbol TCsymbol
    ///  Check whether the Csymbol data member has been assigned a value.
    bool IsSetCsymbol(void) const;
    /// Check whether it is safe or not to call GetCsymbol method.
    bool CanGetCsymbol(void) const;
    void ResetCsymbol(void);
    const TCsymbol& GetCsymbol(void) const;
    void SetCsymbol(TCsymbol& value);
    TCsymbol& SetCsymbol(void);

    /// optional
    /// typedef C_ContExp TContExp
    ///  Check whether the ContExp data member has been assigned a value.
    bool IsSetContExp(void) const;
    /// Check whether it is safe or not to call GetContExp method.
    bool CanGetContExp(void) const;
    void ResetContExp(void);
    const TContExp& GetContExp(void) const;
    void SetContExp(TContExp& value);
    TContExp& SetContExp(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCerror_Base(const CCerror_Base&);
    CCerror_Base& operator=(const CCerror_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TAttlist > m_Attlist;
    NCBI_NS_NCBI::CRef< TCsymbol > m_Csymbol;
    NCBI_NS_NCBI::CRef< TContExp > m_ContExp;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCerror_Base::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCerror_Base::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CCerror_Base::C_Attlist::TId& CCerror_Base::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CCerror_Base::C_Attlist::SetId(const CCerror_Base::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CCerror_Base::C_Attlist::SetId(CCerror_Base::C_Attlist::TId&& value)
{
    m_Id = std::forward<CCerror_Base::C_Attlist::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CCerror_Base::C_Attlist::TId& CCerror_Base::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CCerror_Base::C_Attlist::IsSetXref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCerror_Base::C_Attlist::CanGetXref(void) const
{
    return IsSetXref();
}

inline
const CCerror_Base::C_Attlist::TXref& CCerror_Base::C_Attlist::GetXref(void) const
{
    if (!CanGetXref()) {
        ThrowUnassigned(1);
    }
    return m_Xref;
}

inline
void CCerror_Base::C_Attlist::SetXref(const CCerror_Base::C_Attlist::TXref& value)
{
    m_Xref = value;
    m_set_State[0] |= 0xc;
}

inline
void CCerror_Base::C_Attlist::SetXref(CCerror_Base::C_Attlist::TXref&& value)
{
    m_Xref = std::forward<CCerror_Base::C_Attlist::TXref>(value);
    m_set_State[0] |= 0xc;
}

inline
CCerror_Base::C_Attlist::TXref& CCerror_Base::C_Attlist::SetXref(void)
{
#ifdef _DEBUG
    if (!IsSetXref()) {
        m_Xref = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Xref;
}

inline
bool CCerror_Base::C_Attlist::IsSetClass(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCerror_Base::C_Attlist::CanGetClass(void) const
{
    return IsSetClass();
}

inline
const CCerror_Base::C_Attlist::TClass& CCerror_Base::C_Attlist::GetClass(void) const
{
    if (!CanGetClass()) {
        ThrowUnassigned(2);
    }
    return m_Class;
}

inline
void CCerror_Base::C_Attlist::SetClass(const CCerror_Base::C_Attlist::TClass& value)
{
    m_Class = value;
    m_set_State[0] |= 0x30;
}

inline
void CCerror_Base::C_Attlist::SetClass(CCerror_Base::C_Attlist::TClass&& value)
{
    m_Class = std::forward<CCerror_Base::C_Attlist::TClass>(value);
    m_set_State[0] |= 0x30;
}

inline
CCerror_Base::C_Attlist::TClass& CCerror_Base::C_Attlist::SetClass(void)
{
#ifdef _DEBUG
    if (!IsSetClass()) {
        m_Class = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Class;
}

inline
bool CCerror_Base::C_Attlist::IsSetStyle(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCerror_Base::C_Attlist::CanGetStyle(void) const
{
    return IsSetStyle();
}

inline
const CCerror_Base::C_Attlist::TStyle& CCerror_Base::C_Attlist::GetStyle(void) const
{
    if (!CanGetStyle()) {
        ThrowUnassigned(3);
    }
    return m_Style;
}

inline
void CCerror_Base::C_Attlist::SetStyle(const CCerror_Base::C_Attlist::TStyle& value)
{
    m_Style = value;
    m_set_State[0] |= 0xc0;
}

inline
void CCerror_Base::C_Attlist::SetStyle(CCerror_Base::C_Attlist::TStyle&& value)
{
    m_Style = std::forward<CCerror_Base::C_Attlist::TStyle>(value);
    m_set_State[0] |= 0xc0;
}

inline
CCerror_Base::C_Attlist::TStyle& CCerror_Base::C_Attlist::SetStyle(void)
{
#ifdef _DEBUG
    if (!IsSetStyle()) {
        m_Style = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Style;
}

inline
bool CCerror_Base::C_Attlist::IsSetHref(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCerror_Base::C_Attlist::CanGetHref(void) const
{
    return IsSetHref();
}

inline
const CCerror_Base::C_Attlist::THref& CCerror_Base::C_Attlist::GetHref(void) const
{
    if (!CanGetHref()) {
        ThrowUnassigned(4);
    }
    return m_Href;
}

inline
void CCerror_Base::C_Attlist::SetHref(const CCerror_Base::C_Attlist::THref& value)
{
    m_Href = value;
    m_set_State[0] |= 0x300;
}

inline
void CCerror_Base::C_Attlist::SetHref(CCerror_Base::C_Attlist::THref&& value)
{
    m_Href = std::forward<CCerror_Base::C_Attlist::THref>(value);
    m_set_State[0] |= 0x300;
}

inline
CCerror_Base::C_Attlist::THref& CCerror_Base::C_Attlist::SetHref(void)
{
#ifdef _DEBUG
    if (!IsSetHref()) {
        m_Href = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Href;
}

inline
bool CCerror_Base::C_ContExp::IsSetContExp(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCerror_Base::C_ContExp::CanGetContExp(void) const
{
    return true;
}

inline
const CCerror_Base::C_ContExp::TContExp& CCerror_Base::C_ContExp::GetContExp(void) const
{
    return m_ContExp;
}

inline
CCerror_Base::C_ContExp::TContExp& CCerror_Base::C_ContExp::SetContExp(void)
{
    m_set_State[0] |= 0x1;
    return m_ContExp;
}

inline
bool CCerror_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CCerror_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CCerror_Base::TAttlist& CCerror_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CCerror_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CCerror_Base::TAttlist& CCerror_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CCerror_Base::IsSetCsymbol(void) const
{
    return m_Csymbol.NotEmpty();
}

inline
bool CCerror_Base::CanGetCsymbol(void) const
{
    return true;
}

inline
const CCerror_Base::TCsymbol& CCerror_Base::GetCsymbol(void) const
{
    if ( !m_Csymbol ) {
        const_cast<CCerror_Base*>(this)->ResetCsymbol();
    }
    return (*m_Csymbol);
}

inline
CCerror_Base::TCsymbol& CCerror_Base::SetCsymbol(void)
{
    if ( !m_Csymbol ) {
        ResetCsymbol();
    }
    return (*m_Csymbol);
}

inline
bool CCerror_Base::IsSetContExp(void) const
{
    return m_ContExp.NotEmpty();
}

inline
bool CCerror_Base::CanGetContExp(void) const
{
    return IsSetContExp();
}

inline
const CCerror_Base::TContExp& CCerror_Base::GetContExp(void) const
{
    if (!CanGetContExp()) {
        ThrowUnassigned(2);
    }
    return (*m_ContExp);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_CERROR_BASE_HPP
