/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Book_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_BOOK_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_BOOK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAuthorList;
class CBeginningDate;
class CBookTitle;
class CCollectionTitle;
class CELocationID;
class CEdition;
class CEndingDate;
class CInvestigatorList;
class CIsbn;
class CMedium;
class CPubDate;
class CPublisher;
class CReportNumber;
class CVolume;
class CVolumeTitle;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CBook_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CBook_Base(void);
    // destructor
    virtual ~CBook_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPublisher TPublisher;
    typedef CBookTitle TBookTitle;
    typedef CPubDate TPubDate;
    typedef CBeginningDate TBeginningDate;
    typedef CEndingDate TEndingDate;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthorList > > TAuthorList;
    typedef CInvestigatorList TInvestigatorList;
    typedef CVolume TVolume;
    typedef CVolumeTitle TVolumeTitle;
    typedef CEdition TEdition;
    typedef CCollectionTitle TCollectionTitle;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIsbn > > TIsbn;
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > TELocationID;
    typedef CMedium TMedium;
    typedef CReportNumber TReportNumber;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_Publisher,
        e_BookTitle,
        e_PubDate,
        e_BeginningDate,
        e_EndingDate,
        e_AuthorList,
        e_InvestigatorList,
        e_Volume,
        e_VolumeTitle,
        e_Edition,
        e_CollectionTitle,
        e_Isbn,
        e_ELocationID,
        e_Medium,
        e_ReportNumber
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 16> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CPublisher TPublisher
    ///  Check whether the Publisher data member has been assigned a value.
    bool IsSetPublisher(void) const;
    /// Check whether it is safe or not to call GetPublisher method.
    bool CanGetPublisher(void) const;
    void ResetPublisher(void);
    const TPublisher& GetPublisher(void) const;
    void SetPublisher(TPublisher& value);
    TPublisher& SetPublisher(void);

    /// mandatory
    /// typedef CBookTitle TBookTitle
    ///  Check whether the BookTitle data member has been assigned a value.
    bool IsSetBookTitle(void) const;
    /// Check whether it is safe or not to call GetBookTitle method.
    bool CanGetBookTitle(void) const;
    void ResetBookTitle(void);
    const TBookTitle& GetBookTitle(void) const;
    void SetBookTitle(TBookTitle& value);
    TBookTitle& SetBookTitle(void);

    /// mandatory
    /// typedef CPubDate TPubDate
    ///  Check whether the PubDate data member has been assigned a value.
    bool IsSetPubDate(void) const;
    /// Check whether it is safe or not to call GetPubDate method.
    bool CanGetPubDate(void) const;
    void ResetPubDate(void);
    const TPubDate& GetPubDate(void) const;
    void SetPubDate(TPubDate& value);
    TPubDate& SetPubDate(void);

    /// optional
    /// typedef CBeginningDate TBeginningDate
    ///  Check whether the BeginningDate data member has been assigned a value.
    bool IsSetBeginningDate(void) const;
    /// Check whether it is safe or not to call GetBeginningDate method.
    bool CanGetBeginningDate(void) const;
    void ResetBeginningDate(void);
    const TBeginningDate& GetBeginningDate(void) const;
    void SetBeginningDate(TBeginningDate& value);
    TBeginningDate& SetBeginningDate(void);

    /// optional
    /// typedef CEndingDate TEndingDate
    ///  Check whether the EndingDate data member has been assigned a value.
    bool IsSetEndingDate(void) const;
    /// Check whether it is safe or not to call GetEndingDate method.
    bool CanGetEndingDate(void) const;
    void ResetEndingDate(void);
    const TEndingDate& GetEndingDate(void) const;
    void SetEndingDate(TEndingDate& value);
    TEndingDate& SetEndingDate(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthorList > > TAuthorList
    ///  Check whether the AuthorList data member has been assigned a value.
    bool IsSetAuthorList(void) const;
    /// Check whether it is safe or not to call GetAuthorList method.
    bool CanGetAuthorList(void) const;
    void ResetAuthorList(void);
    const TAuthorList& GetAuthorList(void) const;
    TAuthorList& SetAuthorList(void);

    /// optional
    /// typedef CInvestigatorList TInvestigatorList
    ///  Check whether the InvestigatorList data member has been assigned a value.
    bool IsSetInvestigatorList(void) const;
    /// Check whether it is safe or not to call GetInvestigatorList method.
    bool CanGetInvestigatorList(void) const;
    void ResetInvestigatorList(void);
    const TInvestigatorList& GetInvestigatorList(void) const;
    void SetInvestigatorList(TInvestigatorList& value);
    TInvestigatorList& SetInvestigatorList(void);

    /// optional
    /// typedef CVolume TVolume
    ///  Check whether the Volume data member has been assigned a value.
    bool IsSetVolume(void) const;
    /// Check whether it is safe or not to call GetVolume method.
    bool CanGetVolume(void) const;
    void ResetVolume(void);
    const TVolume& GetVolume(void) const;
    void SetVolume(TVolume& value);
    TVolume& SetVolume(void);

    /// optional
    /// typedef CVolumeTitle TVolumeTitle
    ///  Check whether the VolumeTitle data member has been assigned a value.
    bool IsSetVolumeTitle(void) const;
    /// Check whether it is safe or not to call GetVolumeTitle method.
    bool CanGetVolumeTitle(void) const;
    void ResetVolumeTitle(void);
    const TVolumeTitle& GetVolumeTitle(void) const;
    void SetVolumeTitle(TVolumeTitle& value);
    TVolumeTitle& SetVolumeTitle(void);

    /// optional
    /// typedef CEdition TEdition
    ///  Check whether the Edition data member has been assigned a value.
    bool IsSetEdition(void) const;
    /// Check whether it is safe or not to call GetEdition method.
    bool CanGetEdition(void) const;
    void ResetEdition(void);
    const TEdition& GetEdition(void) const;
    void SetEdition(TEdition& value);
    TEdition& SetEdition(void);

    /// optional
    /// typedef CCollectionTitle TCollectionTitle
    ///  Check whether the CollectionTitle data member has been assigned a value.
    bool IsSetCollectionTitle(void) const;
    /// Check whether it is safe or not to call GetCollectionTitle method.
    bool CanGetCollectionTitle(void) const;
    void ResetCollectionTitle(void);
    const TCollectionTitle& GetCollectionTitle(void) const;
    void SetCollectionTitle(TCollectionTitle& value);
    TCollectionTitle& SetCollectionTitle(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIsbn > > TIsbn
    ///  Check whether the Isbn data member has been assigned a value.
    bool IsSetIsbn(void) const;
    /// Check whether it is safe or not to call GetIsbn method.
    bool CanGetIsbn(void) const;
    void ResetIsbn(void);
    const TIsbn& GetIsbn(void) const;
    TIsbn& SetIsbn(void);

    /// optional
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > TELocationID
    ///  Check whether the ELocationID data member has been assigned a value.
    bool IsSetELocationID(void) const;
    /// Check whether it is safe or not to call GetELocationID method.
    bool CanGetELocationID(void) const;
    void ResetELocationID(void);
    const TELocationID& GetELocationID(void) const;
    TELocationID& SetELocationID(void);

    /// optional
    /// typedef CMedium TMedium
    ///  Check whether the Medium data member has been assigned a value.
    bool IsSetMedium(void) const;
    /// Check whether it is safe or not to call GetMedium method.
    bool CanGetMedium(void) const;
    void ResetMedium(void);
    const TMedium& GetMedium(void) const;
    void SetMedium(TMedium& value);
    TMedium& SetMedium(void);

    /// optional
    /// typedef CReportNumber TReportNumber
    ///  Check whether the ReportNumber data member has been assigned a value.
    bool IsSetReportNumber(void) const;
    /// Check whether it is safe or not to call GetReportNumber method.
    bool CanGetReportNumber(void) const;
    void ResetReportNumber(void);
    const TReportNumber& GetReportNumber(void) const;
    void SetReportNumber(TReportNumber& value);
    TReportNumber& SetReportNumber(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBook_Base(const CBook_Base&);
    CBook_Base& operator=(const CBook_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_NCBI::CRef< TPublisher > m_Publisher;
    NCBI_NS_NCBI::CRef< TBookTitle > m_BookTitle;
    NCBI_NS_NCBI::CRef< TPubDate > m_PubDate;
    NCBI_NS_NCBI::CRef< TBeginningDate > m_BeginningDate;
    NCBI_NS_NCBI::CRef< TEndingDate > m_EndingDate;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAuthorList > > m_AuthorList;
    NCBI_NS_NCBI::CRef< TInvestigatorList > m_InvestigatorList;
    NCBI_NS_NCBI::CRef< TVolume > m_Volume;
    NCBI_NS_NCBI::CRef< TVolumeTitle > m_VolumeTitle;
    NCBI_NS_NCBI::CRef< TEdition > m_Edition;
    NCBI_NS_NCBI::CRef< TCollectionTitle > m_CollectionTitle;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CIsbn > > m_Isbn;
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CELocationID > > m_ELocationID;
    NCBI_NS_NCBI::CRef< TMedium > m_Medium;
    NCBI_NS_NCBI::CRef< TReportNumber > m_ReportNumber;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBook_Base::IsSetPublisher(void) const
{
    return m_Publisher.NotEmpty();
}

inline
bool CBook_Base::CanGetPublisher(void) const
{
    return true;
}

inline
const CBook_Base::TPublisher& CBook_Base::GetPublisher(void) const
{
    if ( !m_Publisher ) {
        const_cast<CBook_Base*>(this)->ResetPublisher();
    }
    return (*m_Publisher);
}

inline
CBook_Base::TPublisher& CBook_Base::SetPublisher(void)
{
    if ( !m_Publisher ) {
        ResetPublisher();
    }
    return (*m_Publisher);
}

inline
bool CBook_Base::IsSetBookTitle(void) const
{
    return m_BookTitle.NotEmpty();
}

inline
bool CBook_Base::CanGetBookTitle(void) const
{
    return true;
}

inline
const CBook_Base::TBookTitle& CBook_Base::GetBookTitle(void) const
{
    if ( !m_BookTitle ) {
        const_cast<CBook_Base*>(this)->ResetBookTitle();
    }
    return (*m_BookTitle);
}

inline
CBook_Base::TBookTitle& CBook_Base::SetBookTitle(void)
{
    if ( !m_BookTitle ) {
        ResetBookTitle();
    }
    return (*m_BookTitle);
}

inline
bool CBook_Base::IsSetPubDate(void) const
{
    return m_PubDate.NotEmpty();
}

inline
bool CBook_Base::CanGetPubDate(void) const
{
    return true;
}

inline
const CBook_Base::TPubDate& CBook_Base::GetPubDate(void) const
{
    if ( !m_PubDate ) {
        const_cast<CBook_Base*>(this)->ResetPubDate();
    }
    return (*m_PubDate);
}

inline
CBook_Base::TPubDate& CBook_Base::SetPubDate(void)
{
    if ( !m_PubDate ) {
        ResetPubDate();
    }
    return (*m_PubDate);
}

inline
bool CBook_Base::IsSetBeginningDate(void) const
{
    return m_BeginningDate.NotEmpty();
}

inline
bool CBook_Base::CanGetBeginningDate(void) const
{
    return IsSetBeginningDate();
}

inline
const CBook_Base::TBeginningDate& CBook_Base::GetBeginningDate(void) const
{
    if (!CanGetBeginningDate()) {
        ThrowUnassigned(3);
    }
    return (*m_BeginningDate);
}

inline
bool CBook_Base::IsSetEndingDate(void) const
{
    return m_EndingDate.NotEmpty();
}

inline
bool CBook_Base::CanGetEndingDate(void) const
{
    return IsSetEndingDate();
}

inline
const CBook_Base::TEndingDate& CBook_Base::GetEndingDate(void) const
{
    if (!CanGetEndingDate()) {
        ThrowUnassigned(4);
    }
    return (*m_EndingDate);
}

inline
bool CBook_Base::IsSetAuthorList(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CBook_Base::CanGetAuthorList(void) const
{
    return true;
}

inline
const CBook_Base::TAuthorList& CBook_Base::GetAuthorList(void) const
{
    return m_AuthorList;
}

inline
CBook_Base::TAuthorList& CBook_Base::SetAuthorList(void)
{
    m_set_State[0] |= 0x400;
    return m_AuthorList;
}

inline
bool CBook_Base::IsSetInvestigatorList(void) const
{
    return m_InvestigatorList.NotEmpty();
}

inline
bool CBook_Base::CanGetInvestigatorList(void) const
{
    return IsSetInvestigatorList();
}

inline
const CBook_Base::TInvestigatorList& CBook_Base::GetInvestigatorList(void) const
{
    if (!CanGetInvestigatorList()) {
        ThrowUnassigned(6);
    }
    return (*m_InvestigatorList);
}

inline
bool CBook_Base::IsSetVolume(void) const
{
    return m_Volume.NotEmpty();
}

inline
bool CBook_Base::CanGetVolume(void) const
{
    return IsSetVolume();
}

inline
const CBook_Base::TVolume& CBook_Base::GetVolume(void) const
{
    if (!CanGetVolume()) {
        ThrowUnassigned(7);
    }
    return (*m_Volume);
}

inline
bool CBook_Base::IsSetVolumeTitle(void) const
{
    return m_VolumeTitle.NotEmpty();
}

inline
bool CBook_Base::CanGetVolumeTitle(void) const
{
    return IsSetVolumeTitle();
}

inline
const CBook_Base::TVolumeTitle& CBook_Base::GetVolumeTitle(void) const
{
    if (!CanGetVolumeTitle()) {
        ThrowUnassigned(8);
    }
    return (*m_VolumeTitle);
}

inline
bool CBook_Base::IsSetEdition(void) const
{
    return m_Edition.NotEmpty();
}

inline
bool CBook_Base::CanGetEdition(void) const
{
    return IsSetEdition();
}

inline
const CBook_Base::TEdition& CBook_Base::GetEdition(void) const
{
    if (!CanGetEdition()) {
        ThrowUnassigned(9);
    }
    return (*m_Edition);
}

inline
bool CBook_Base::IsSetCollectionTitle(void) const
{
    return m_CollectionTitle.NotEmpty();
}

inline
bool CBook_Base::CanGetCollectionTitle(void) const
{
    return IsSetCollectionTitle();
}

inline
const CBook_Base::TCollectionTitle& CBook_Base::GetCollectionTitle(void) const
{
    if (!CanGetCollectionTitle()) {
        ThrowUnassigned(10);
    }
    return (*m_CollectionTitle);
}

inline
bool CBook_Base::IsSetIsbn(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CBook_Base::CanGetIsbn(void) const
{
    return true;
}

inline
const CBook_Base::TIsbn& CBook_Base::GetIsbn(void) const
{
    return m_Isbn;
}

inline
CBook_Base::TIsbn& CBook_Base::SetIsbn(void)
{
    m_set_State[0] |= 0x400000;
    return m_Isbn;
}

inline
bool CBook_Base::IsSetELocationID(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CBook_Base::CanGetELocationID(void) const
{
    return true;
}

inline
const CBook_Base::TELocationID& CBook_Base::GetELocationID(void) const
{
    return m_ELocationID;
}

inline
CBook_Base::TELocationID& CBook_Base::SetELocationID(void)
{
    m_set_State[0] |= 0x1000000;
    return m_ELocationID;
}

inline
bool CBook_Base::IsSetMedium(void) const
{
    return m_Medium.NotEmpty();
}

inline
bool CBook_Base::CanGetMedium(void) const
{
    return IsSetMedium();
}

inline
const CBook_Base::TMedium& CBook_Base::GetMedium(void) const
{
    if (!CanGetMedium()) {
        ThrowUnassigned(13);
    }
    return (*m_Medium);
}

inline
bool CBook_Base::IsSetReportNumber(void) const
{
    return m_ReportNumber.NotEmpty();
}

inline
bool CBook_Base::CanGetReportNumber(void) const
{
    return IsSetReportNumber();
}

inline
const CBook_Base::TReportNumber& CBook_Base::GetReportNumber(void) const
{
    if (!CanGetReportNumber()) {
        ThrowUnassigned(14);
    }
    return (*m_ReportNumber);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_BOOK_BASE_HPP
