/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file AccessionNumberList_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'efetch.xsd'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef eutils__OBJTOOLS_EUTILS_EFETCH_ACCESSIONNUMBERLIST_BASE_HPP
#define eutils__OBJTOOLS_EUTILS_EFETCH_ACCESSIONNUMBERLIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

#ifndef BEGIN_eutils_SCOPE
#  define BEGIN_eutils_SCOPE BEGIN_SCOPE(eutils)
#  define END_eutils_SCOPE END_SCOPE(eutils)
#endif
BEGIN_eutils_SCOPE // namespace eutils::


// forward declarations
class CAccessionNumber;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAccessionNumberList_Base : public NCBI_NS_NCBI::CSerialObject
{
    typedef NCBI_NS_NCBI::CSerialObject Tparent;
public:
    // constructor
    CAccessionNumberList_Base(void);
    // destructor
    virtual ~CAccessionNumberList_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAccessionNumber > > TAccessionNumber;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_AccessionNumber
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAccessionNumber > > TAccessionNumber
    ///  Check whether the AccessionNumber data member has been assigned a value.
    bool IsSetAccessionNumber(void) const;
    /// Check whether it is safe or not to call GetAccessionNumber method.
    bool CanGetAccessionNumber(void) const;
    void ResetAccessionNumber(void);
    const TAccessionNumber& GetAccessionNumber(void) const;
    TAccessionNumber& SetAccessionNumber(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAccessionNumberList_Base(const CAccessionNumberList_Base&);
    CAccessionNumberList_Base& operator=(const CAccessionNumberList_Base&);

    // data
    Uint4 m_set_State[1];
    NCBI_NS_STD::list< NCBI_NS_NCBI::CRef< CAccessionNumber > > m_AccessionNumber;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAccessionNumberList_Base::IsSetAccessionNumber(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAccessionNumberList_Base::CanGetAccessionNumber(void) const
{
    return true;
}

inline
const CAccessionNumberList_Base::TAccessionNumber& CAccessionNumberList_Base::GetAccessionNumber(void) const
{
    return m_AccessionNumber;
}

inline
CAccessionNumberList_Base::TAccessionNumber& CAccessionNumberList_Base::SetAccessionNumber(void)
{
    m_set_State[0] |= 0x1;
    return m_AccessionNumber;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_eutils_SCOPE // namespace eutils::


#endif // eutils__OBJTOOLS_EUTILS_EFETCH_ACCESSIONNUMBERLIST_BASE_HPP
