/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Subsequence_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_SUBSEQUENCE_BASE_HPP
#define OBJECTS_VARREP_SUBSEQUENCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/varrep/VariantSeqType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeqInterval;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSubsequence_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSubsequence_Base(void);
    // destructor
    virtual ~CSubsequence_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TIdentifier;
    typedef int TType;
    typedef CSeqInterval TInt;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_identifier,
        e_type,
        e_int
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// For example, an accession id
    /// mandatory
    /// typedef string TIdentifier
    ///  Check whether the Identifier data member has been assigned a value.
    bool IsSetIdentifier(void) const;
    /// Check whether it is safe or not to call GetIdentifier method.
    bool CanGetIdentifier(void) const;
    void ResetIdentifier(void);
    const TIdentifier& GetIdentifier(void) const;
    void SetIdentifier(const TIdentifier& value);
    void SetIdentifier(TIdentifier&& value);
    TIdentifier& SetIdentifier(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef CSeqInterval TInt
    ///  Check whether the Int data member has been assigned a value.
    bool IsSetInt(void) const;
    /// Check whether it is safe or not to call GetInt method.
    bool CanGetInt(void) const;
    void ResetInt(void);
    const TInt& GetInt(void) const;
    void SetInt(TInt& value);
    TInt& SetInt(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSubsequence_Base(const CSubsequence_Base&);
    CSubsequence_Base& operator=(const CSubsequence_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Identifier;
    int m_Type;
    CRef< TInt > m_Int;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSubsequence_Base::IsSetIdentifier(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSubsequence_Base::CanGetIdentifier(void) const
{
    return IsSetIdentifier();
}

inline
const CSubsequence_Base::TIdentifier& CSubsequence_Base::GetIdentifier(void) const
{
    if (!CanGetIdentifier()) {
        ThrowUnassigned(0);
    }
    return m_Identifier;
}

inline
void CSubsequence_Base::SetIdentifier(const CSubsequence_Base::TIdentifier& value)
{
    m_Identifier = value;
    m_set_State[0] |= 0x3;
}

inline
void CSubsequence_Base::SetIdentifier(CSubsequence_Base::TIdentifier&& value)
{
    m_Identifier = std::forward<CSubsequence_Base::TIdentifier>(value);
    m_set_State[0] |= 0x3;
}

inline
CSubsequence_Base::TIdentifier& CSubsequence_Base::SetIdentifier(void)
{
#ifdef _DEBUG
    if (!IsSetIdentifier()) {
        m_Identifier = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Identifier;
}

inline
bool CSubsequence_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSubsequence_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CSubsequence_Base::ResetType(void)
{
    m_Type = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSubsequence_Base::TType CSubsequence_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CSubsequence_Base::SetType(CSubsequence_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CSubsequence_Base::TType& CSubsequence_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CSubsequence_Base::IsSetInt(void) const
{
    return m_Int.NotEmpty();
}

inline
bool CSubsequence_Base::CanGetInt(void) const
{
    return true;
}

inline
const CSubsequence_Base::TInt& CSubsequence_Base::GetInt(void) const
{
    if ( !m_Int ) {
        const_cast<CSubsequence_Base*>(this)->ResetInt();
    }
    return (*m_Int);
}

inline
CSubsequence_Base::TInt& CSubsequence_Base::SetInt(void)
{
    if ( !m_Int ) {
        ResetInt();
    }
    return (*m_Int);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_SUBSEQUENCE_BASE_HPP
