/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ProteinSub_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_PROTEINSUB_BASE_HPP
#define OBJECTS_VARREP_PROTEINSUB_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAaSite;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CProteinSub_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProteinSub_Base(void);
    // destructor
    virtual ~CProteinSub_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_missense = 0,
        eType_nonsense = 1,
        eType_unknown  = 2
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TType;
    typedef CAaSite TInitial;
    typedef string TFinal;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_initial,
        e_final
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef CAaSite TInitial
    ///  Check whether the Initial data member has been assigned a value.
    bool IsSetInitial(void) const;
    /// Check whether it is safe or not to call GetInitial method.
    bool CanGetInitial(void) const;
    void ResetInitial(void);
    const TInitial& GetInitial(void) const;
    void SetInitial(TInitial& value);
    TInitial& SetInitial(void);

    /// optional
    /// typedef string TFinal
    ///  Check whether the Final data member has been assigned a value.
    bool IsSetFinal(void) const;
    /// Check whether it is safe or not to call GetFinal method.
    bool CanGetFinal(void) const;
    void ResetFinal(void);
    const TFinal& GetFinal(void) const;
    void SetFinal(const TFinal& value);
    void SetFinal(TFinal&& value);
    TFinal& SetFinal(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProteinSub_Base(const CProteinSub_Base&);
    CProteinSub_Base& operator=(const CProteinSub_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    CRef< TInitial > m_Initial;
    string m_Final;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProteinSub_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CProteinSub_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CProteinSub_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CProteinSub_Base::TType CProteinSub_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CProteinSub_Base::SetType(CProteinSub_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CProteinSub_Base::TType& CProteinSub_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CProteinSub_Base::IsSetInitial(void) const
{
    return m_Initial.NotEmpty();
}

inline
bool CProteinSub_Base::CanGetInitial(void) const
{
    return true;
}

inline
const CProteinSub_Base::TInitial& CProteinSub_Base::GetInitial(void) const
{
    if ( !m_Initial ) {
        const_cast<CProteinSub_Base*>(this)->ResetInitial();
    }
    return (*m_Initial);
}

inline
CProteinSub_Base::TInitial& CProteinSub_Base::SetInitial(void)
{
    if ( !m_Initial ) {
        ResetInitial();
    }
    return (*m_Initial);
}

inline
bool CProteinSub_Base::IsSetFinal(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CProteinSub_Base::CanGetFinal(void) const
{
    return IsSetFinal();
}

inline
const CProteinSub_Base::TFinal& CProteinSub_Base::GetFinal(void) const
{
    if (!CanGetFinal()) {
        ThrowUnassigned(2);
    }
    return m_Final;
}

inline
void CProteinSub_Base::SetFinal(const CProteinSub_Base::TFinal& value)
{
    m_Final = value;
    m_set_State[0] |= 0x30;
}

inline
void CProteinSub_Base::SetFinal(CProteinSub_Base::TFinal&& value)
{
    m_Final = std::forward<CProteinSub_Base::TFinal>(value);
    m_set_State[0] |= 0x30;
}

inline
CProteinSub_Base::TFinal& CProteinSub_Base::SetFinal(void)
{
#ifdef _DEBUG
    if (!IsSetFinal()) {
        m_Final = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Final;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_PROTEINSUB_BASE_HPP
