/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Inversion_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'varrep.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARREP_INVERSION_BASE_HPP
#define OBJECTS_VARREP_INVERSION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNtInterval;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CInversion_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CInversion_Base(void);
    // destructor
    virtual ~CInversion_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CNtInterval TNtint;
    typedef string TRaw_seq;
    typedef int TSize;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_ntint,
        e_raw_seq,
        e_size
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CNtInterval TNtint
    ///  Check whether the Ntint data member has been assigned a value.
    bool IsSetNtint(void) const;
    /// Check whether it is safe or not to call GetNtint method.
    bool CanGetNtint(void) const;
    void ResetNtint(void);
    const TNtint& GetNtint(void) const;
    void SetNtint(TNtint& value);
    TNtint& SetNtint(void);

    /// optional
    /// typedef string TRaw_seq
    ///  Check whether the Raw_seq data member has been assigned a value.
    bool IsSetRaw_seq(void) const;
    /// Check whether it is safe or not to call GetRaw_seq method.
    bool CanGetRaw_seq(void) const;
    void ResetRaw_seq(void);
    const TRaw_seq& GetRaw_seq(void) const;
    void SetRaw_seq(const TRaw_seq& value);
    void SetRaw_seq(TRaw_seq&& value);
    TRaw_seq& SetRaw_seq(void);

    /// optionall specify the size of the inverted sequence
    /// optional
    /// typedef int TSize
    ///  Check whether the Size data member has been assigned a value.
    bool IsSetSize(void) const;
    /// Check whether it is safe or not to call GetSize method.
    bool CanGetSize(void) const;
    void ResetSize(void);
    TSize GetSize(void) const;
    void SetSize(TSize value);
    TSize& SetSize(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CInversion_Base(const CInversion_Base&);
    CInversion_Base& operator=(const CInversion_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TNtint > m_Ntint;
    string m_Raw_seq;
    int m_Size;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CInversion_Base::IsSetNtint(void) const
{
    return m_Ntint.NotEmpty();
}

inline
bool CInversion_Base::CanGetNtint(void) const
{
    return true;
}

inline
const CInversion_Base::TNtint& CInversion_Base::GetNtint(void) const
{
    if ( !m_Ntint ) {
        const_cast<CInversion_Base*>(this)->ResetNtint();
    }
    return (*m_Ntint);
}

inline
CInversion_Base::TNtint& CInversion_Base::SetNtint(void)
{
    if ( !m_Ntint ) {
        ResetNtint();
    }
    return (*m_Ntint);
}

inline
bool CInversion_Base::IsSetRaw_seq(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CInversion_Base::CanGetRaw_seq(void) const
{
    return IsSetRaw_seq();
}

inline
const CInversion_Base::TRaw_seq& CInversion_Base::GetRaw_seq(void) const
{
    if (!CanGetRaw_seq()) {
        ThrowUnassigned(1);
    }
    return m_Raw_seq;
}

inline
void CInversion_Base::SetRaw_seq(const CInversion_Base::TRaw_seq& value)
{
    m_Raw_seq = value;
    m_set_State[0] |= 0xc;
}

inline
void CInversion_Base::SetRaw_seq(CInversion_Base::TRaw_seq&& value)
{
    m_Raw_seq = std::forward<CInversion_Base::TRaw_seq>(value);
    m_set_State[0] |= 0xc;
}

inline
CInversion_Base::TRaw_seq& CInversion_Base::SetRaw_seq(void)
{
#ifdef _DEBUG
    if (!IsSetRaw_seq()) {
        m_Raw_seq = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Raw_seq;
}

inline
bool CInversion_Base::IsSetSize(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CInversion_Base::CanGetSize(void) const
{
    return IsSetSize();
}

inline
void CInversion_Base::ResetSize(void)
{
    m_Size = 0;
    m_set_State[0] &= ~0x30;
}

inline
CInversion_Base::TSize CInversion_Base::GetSize(void) const
{
    if (!CanGetSize()) {
        ThrowUnassigned(2);
    }
    return m_Size;
}

inline
void CInversion_Base::SetSize(CInversion_Base::TSize value)
{
    m_Size = value;
    m_set_State[0] |= 0x30;
}

inline
CInversion_Base::TSize& CInversion_Base::SetSize(void)
{
#ifdef _DEBUG
    if (!IsSetSize()) {
        memset(&m_Size,UnassignedByte(),sizeof(m_Size));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Size;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARREP_INVERSION_BASE_HPP
