/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file VariationMethod_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'variation.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VARIATION_VARIATIONMETHOD_BASE_HPP
#define OBJECTS_VARIATION_VARIATIONMETHOD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_VARIATION_EXPORT CVariationMethod_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CVariationMethod_Base(void);
    // destructor
    virtual ~CVariationMethod_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EMethod_E {
        eMethod_E_unknown            =   0,
        eMethod_E_bac_acgh           =   1,
        eMethod_E_computational      =   2,
        eMethod_E_curated            =   3,
        eMethod_E_digital_array      =   4,
        eMethod_E_expression_array   =   5,
        eMethod_E_fish               =   6,
        eMethod_E_flanking_sequence  =   7,
        eMethod_E_maph               =   8,
        eMethod_E_mcd_analysis       =   9,
        eMethod_E_mlpa               =  10,
        eMethod_E_oea_assembly       =  11,
        eMethod_E_oligo_acgh         =  12,
        eMethod_E_paired_end         =  13,
        eMethod_E_pcr                =  14,
        eMethod_E_qpcr               =  15,
        eMethod_E_read_depth         =  16,
        eMethod_E_roma               =  17,
        eMethod_E_rt_pcr             =  18,
        eMethod_E_sage               =  19,
        eMethod_E_sequence_alignment =  20,
        eMethod_E_sequencing         =  21,
        eMethod_E_snp_array          =  22,
        eMethod_E_snp_genoytyping    =  23,
        eMethod_E_southern           =  24,
        eMethod_E_western            =  25,
        eMethod_E_optical_mapping    =  26,
        eMethod_E_other              = 255
    };
    
    /// Access to EMethod_E's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMethod_E)(void);
    
    // types
    typedef list< int > TMethod;
    typedef CSeq_loc TReference_location;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_method,
        e_reference_location
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< int > TMethod
    ///  Check whether the Method data member has been assigned a value.
    bool IsSetMethod(void) const;
    /// Check whether it is safe or not to call GetMethod method.
    bool CanGetMethod(void) const;
    void ResetMethod(void);
    const TMethod& GetMethod(void) const;
    TMethod& SetMethod(void);

    /// if sequence-based validation methods are used,
    /// what reference sequence location validated the presence of this?
    /// optional
    /// typedef CSeq_loc TReference_location
    ///  Check whether the Reference_location data member has been assigned a value.
    bool IsSetReference_location(void) const;
    /// Check whether it is safe or not to call GetReference_location method.
    bool CanGetReference_location(void) const;
    void ResetReference_location(void);
    const TReference_location& GetReference_location(void) const;
    void SetReference_location(TReference_location& value);
    TReference_location& SetReference_location(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CVariationMethod_Base(const CVariationMethod_Base&);
    CVariationMethod_Base& operator=(const CVariationMethod_Base&);

    // data
    Uint4 m_set_State[1];
    list< int > m_Method;
    CRef< TReference_location > m_Reference_location;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CVariationMethod_Base::IsSetMethod(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariationMethod_Base::CanGetMethod(void) const
{
    return true;
}

inline
const CVariationMethod_Base::TMethod& CVariationMethod_Base::GetMethod(void) const
{
    return m_Method;
}

inline
CVariationMethod_Base::TMethod& CVariationMethod_Base::SetMethod(void)
{
    m_set_State[0] |= 0x1;
    return m_Method;
}

inline
bool CVariationMethod_Base::IsSetReference_location(void) const
{
    return m_Reference_location.NotEmpty();
}

inline
bool CVariationMethod_Base::CanGetReference_location(void) const
{
    return IsSetReference_location();
}

inline
const CVariationMethod_Base::TReference_location& CVariationMethod_Base::GetReference_location(void) const
{
    if (!CanGetReference_location()) {
        ThrowUnassigned(1);
    }
    return (*m_Reference_location);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VARIATION_VARIATIONMETHOD_BASE_HPP
