/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Comment_rule_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'valid.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_VALID_COMMENT_RULE_BASE_HPP
#define OBJECTS_VALID_COMMENT_RULE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDependent_field_set;
class CField_set;
class CPhrase_list;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_VALID_EXPORT CComment_rule_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CComment_rule_Base(void);
    // destructor
    virtual ~CComment_rule_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TPrefix;
    typedef bool TUpdated;
    typedef CField_set TFields;
    typedef bool TRequire_order;
    typedef bool TAllow_unlisted;
    typedef CDependent_field_set TDependent_rules;
    typedef CPhrase_list TForbidden_phrases;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_prefix,
        e_updated,
        e_fields,
        e_require_order,
        e_allow_unlisted,
        e_dependent_rules,
        e_forbidden_phrases
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TPrefix
    ///  Check whether the Prefix data member has been assigned a value.
    bool IsSetPrefix(void) const;
    /// Check whether it is safe or not to call GetPrefix method.
    bool CanGetPrefix(void) const;
    void ResetPrefix(void);
    const TPrefix& GetPrefix(void) const;
    void SetPrefix(const TPrefix& value);
    void SetPrefix(TPrefix&& value);
    TPrefix& SetPrefix(void);

    /// optional with default false
    /// typedef bool TUpdated
    ///  Check whether the Updated data member has been assigned a value.
    bool IsSetUpdated(void) const;
    /// Check whether it is safe or not to call GetUpdated method.
    bool CanGetUpdated(void) const;
    void ResetUpdated(void);
    void SetDefaultUpdated(void);
    TUpdated GetUpdated(void) const;
    void SetUpdated(TUpdated value);
    TUpdated& SetUpdated(void);

    /// mandatory
    /// typedef CField_set TFields
    ///  Check whether the Fields data member has been assigned a value.
    bool IsSetFields(void) const;
    /// Check whether it is safe or not to call GetFields method.
    bool CanGetFields(void) const;
    void ResetFields(void);
    const TFields& GetFields(void) const;
    void SetFields(TFields& value);
    TFields& SetFields(void);

    /// optional with default true
    /// typedef bool TRequire_order
    ///  Check whether the Require_order data member has been assigned a value.
    bool IsSetRequire_order(void) const;
    /// Check whether it is safe or not to call GetRequire_order method.
    bool CanGetRequire_order(void) const;
    void ResetRequire_order(void);
    void SetDefaultRequire_order(void);
    TRequire_order GetRequire_order(void) const;
    void SetRequire_order(TRequire_order value);
    TRequire_order& SetRequire_order(void);

    /// optional with default false
    /// typedef bool TAllow_unlisted
    ///  Check whether the Allow_unlisted data member has been assigned a value.
    bool IsSetAllow_unlisted(void) const;
    /// Check whether it is safe or not to call GetAllow_unlisted method.
    bool CanGetAllow_unlisted(void) const;
    void ResetAllow_unlisted(void);
    void SetDefaultAllow_unlisted(void);
    TAllow_unlisted GetAllow_unlisted(void) const;
    void SetAllow_unlisted(TAllow_unlisted value);
    TAllow_unlisted& SetAllow_unlisted(void);

    /// optional
    /// typedef CDependent_field_set TDependent_rules
    ///  Check whether the Dependent_rules data member has been assigned a value.
    bool IsSetDependent_rules(void) const;
    /// Check whether it is safe or not to call GetDependent_rules method.
    bool CanGetDependent_rules(void) const;
    void ResetDependent_rules(void);
    const TDependent_rules& GetDependent_rules(void) const;
    void SetDependent_rules(TDependent_rules& value);
    TDependent_rules& SetDependent_rules(void);

    /// optional
    /// typedef CPhrase_list TForbidden_phrases
    ///  Check whether the Forbidden_phrases data member has been assigned a value.
    bool IsSetForbidden_phrases(void) const;
    /// Check whether it is safe or not to call GetForbidden_phrases method.
    bool CanGetForbidden_phrases(void) const;
    void ResetForbidden_phrases(void);
    const TForbidden_phrases& GetForbidden_phrases(void) const;
    void SetForbidden_phrases(TForbidden_phrases& value);
    TForbidden_phrases& SetForbidden_phrases(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CComment_rule_Base(const CComment_rule_Base&);
    CComment_rule_Base& operator=(const CComment_rule_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Prefix;
    bool m_Updated;
    CRef< TFields > m_Fields;
    bool m_Require_order;
    bool m_Allow_unlisted;
    CRef< TDependent_rules > m_Dependent_rules;
    CRef< TForbidden_phrases > m_Forbidden_phrases;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CComment_rule_Base::IsSetPrefix(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CComment_rule_Base::CanGetPrefix(void) const
{
    return IsSetPrefix();
}

inline
const CComment_rule_Base::TPrefix& CComment_rule_Base::GetPrefix(void) const
{
    if (!CanGetPrefix()) {
        ThrowUnassigned(0);
    }
    return m_Prefix;
}

inline
void CComment_rule_Base::SetPrefix(const CComment_rule_Base::TPrefix& value)
{
    m_Prefix = value;
    m_set_State[0] |= 0x3;
}

inline
void CComment_rule_Base::SetPrefix(CComment_rule_Base::TPrefix&& value)
{
    m_Prefix = std::forward<CComment_rule_Base::TPrefix>(value);
    m_set_State[0] |= 0x3;
}

inline
CComment_rule_Base::TPrefix& CComment_rule_Base::SetPrefix(void)
{
#ifdef _DEBUG
    if (!IsSetPrefix()) {
        m_Prefix = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Prefix;
}

inline
bool CComment_rule_Base::IsSetUpdated(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CComment_rule_Base::CanGetUpdated(void) const
{
    return true;
}

inline
void CComment_rule_Base::ResetUpdated(void)
{
    m_Updated = false;
    m_set_State[0] &= ~0xc;
}

inline
void CComment_rule_Base::SetDefaultUpdated(void)
{
    ResetUpdated();
}

inline
CComment_rule_Base::TUpdated CComment_rule_Base::GetUpdated(void) const
{
    return m_Updated;
}

inline
void CComment_rule_Base::SetUpdated(CComment_rule_Base::TUpdated value)
{
    m_Updated = value;
    m_set_State[0] |= 0xc;
}

inline
CComment_rule_Base::TUpdated& CComment_rule_Base::SetUpdated(void)
{
#ifdef _DEBUG
    if (!IsSetUpdated()) {
        memset(&m_Updated,UnassignedByte(),sizeof(m_Updated));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Updated;
}

inline
bool CComment_rule_Base::IsSetFields(void) const
{
    return m_Fields.NotEmpty();
}

inline
bool CComment_rule_Base::CanGetFields(void) const
{
    return true;
}

inline
const CComment_rule_Base::TFields& CComment_rule_Base::GetFields(void) const
{
    if ( !m_Fields ) {
        const_cast<CComment_rule_Base*>(this)->ResetFields();
    }
    return (*m_Fields);
}

inline
CComment_rule_Base::TFields& CComment_rule_Base::SetFields(void)
{
    if ( !m_Fields ) {
        ResetFields();
    }
    return (*m_Fields);
}

inline
bool CComment_rule_Base::IsSetRequire_order(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CComment_rule_Base::CanGetRequire_order(void) const
{
    return true;
}

inline
void CComment_rule_Base::ResetRequire_order(void)
{
    m_Require_order = true;
    m_set_State[0] &= ~0xc0;
}

inline
void CComment_rule_Base::SetDefaultRequire_order(void)
{
    ResetRequire_order();
}

inline
CComment_rule_Base::TRequire_order CComment_rule_Base::GetRequire_order(void) const
{
    return m_Require_order;
}

inline
void CComment_rule_Base::SetRequire_order(CComment_rule_Base::TRequire_order value)
{
    m_Require_order = value;
    m_set_State[0] |= 0xc0;
}

inline
CComment_rule_Base::TRequire_order& CComment_rule_Base::SetRequire_order(void)
{
#ifdef _DEBUG
    if (!IsSetRequire_order()) {
        memset(&m_Require_order,UnassignedByte(),sizeof(m_Require_order));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Require_order;
}

inline
bool CComment_rule_Base::IsSetAllow_unlisted(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CComment_rule_Base::CanGetAllow_unlisted(void) const
{
    return true;
}

inline
void CComment_rule_Base::ResetAllow_unlisted(void)
{
    m_Allow_unlisted = false;
    m_set_State[0] &= ~0x300;
}

inline
void CComment_rule_Base::SetDefaultAllow_unlisted(void)
{
    ResetAllow_unlisted();
}

inline
CComment_rule_Base::TAllow_unlisted CComment_rule_Base::GetAllow_unlisted(void) const
{
    return m_Allow_unlisted;
}

inline
void CComment_rule_Base::SetAllow_unlisted(CComment_rule_Base::TAllow_unlisted value)
{
    m_Allow_unlisted = value;
    m_set_State[0] |= 0x300;
}

inline
CComment_rule_Base::TAllow_unlisted& CComment_rule_Base::SetAllow_unlisted(void)
{
#ifdef _DEBUG
    if (!IsSetAllow_unlisted()) {
        memset(&m_Allow_unlisted,UnassignedByte(),sizeof(m_Allow_unlisted));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Allow_unlisted;
}

inline
bool CComment_rule_Base::IsSetDependent_rules(void) const
{
    return m_Dependent_rules.NotEmpty();
}

inline
bool CComment_rule_Base::CanGetDependent_rules(void) const
{
    return IsSetDependent_rules();
}

inline
const CComment_rule_Base::TDependent_rules& CComment_rule_Base::GetDependent_rules(void) const
{
    if (!CanGetDependent_rules()) {
        ThrowUnassigned(5);
    }
    return (*m_Dependent_rules);
}

inline
bool CComment_rule_Base::IsSetForbidden_phrases(void) const
{
    return m_Forbidden_phrases.NotEmpty();
}

inline
bool CComment_rule_Base::CanGetForbidden_phrases(void) const
{
    return IsSetForbidden_phrases();
}

inline
const CComment_rule_Base::TForbidden_phrases& CComment_rule_Base::GetForbidden_phrases(void) const
{
    if (!CanGetForbidden_phrases()) {
        ThrowUnassigned(6);
    }
    return (*m_Forbidden_phrases);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_VALID_COMMENT_RULE_BASE_HPP
