/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_TypeStat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_TYPESTAT_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_TYPESTAT_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/trackmgr/TMgr_AnnotType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_LengthStats;
class CTMgr_PositionStats;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_TypeStat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_TypeStat_Base(void);
    // destructor
    virtual ~CTMgr_TypeStat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TType;
    typedef int TCount;
    typedef CTMgr_LengthStats TLength_stats;
    typedef CTMgr_PositionStats TPosition_stats;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_count,
        e_length_stats,
        e_position_stats
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef int TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    TCount GetCount(void) const;
    void SetCount(TCount value);
    TCount& SetCount(void);

    /// optional
    /// typedef CTMgr_LengthStats TLength_stats
    ///  Check whether the Length_stats data member has been assigned a value.
    bool IsSetLength_stats(void) const;
    /// Check whether it is safe or not to call GetLength_stats method.
    bool CanGetLength_stats(void) const;
    void ResetLength_stats(void);
    const TLength_stats& GetLength_stats(void) const;
    void SetLength_stats(TLength_stats& value);
    TLength_stats& SetLength_stats(void);

    /// optional
    /// typedef CTMgr_PositionStats TPosition_stats
    ///  Check whether the Position_stats data member has been assigned a value.
    bool IsSetPosition_stats(void) const;
    /// Check whether it is safe or not to call GetPosition_stats method.
    bool CanGetPosition_stats(void) const;
    void ResetPosition_stats(void);
    const TPosition_stats& GetPosition_stats(void) const;
    void SetPosition_stats(TPosition_stats& value);
    TPosition_stats& SetPosition_stats(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_TypeStat_Base(const CTMgr_TypeStat_Base&);
    CTMgr_TypeStat_Base& operator=(const CTMgr_TypeStat_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    int m_Count;
    CRef< TLength_stats > m_Length_stats;
    CRef< TPosition_stats > m_Position_stats;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_TypeStat_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_TypeStat_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CTMgr_TypeStat_Base::ResetType(void)
{
    m_Type = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CTMgr_TypeStat_Base::TType CTMgr_TypeStat_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CTMgr_TypeStat_Base::SetType(CTMgr_TypeStat_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CTMgr_TypeStat_Base::TType& CTMgr_TypeStat_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CTMgr_TypeStat_Base::IsSetCount(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_TypeStat_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
void CTMgr_TypeStat_Base::ResetCount(void)
{
    m_Count = 0;
    m_set_State[0] &= ~0xc;
}

inline
CTMgr_TypeStat_Base::TCount CTMgr_TypeStat_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(1);
    }
    return m_Count;
}

inline
void CTMgr_TypeStat_Base::SetCount(CTMgr_TypeStat_Base::TCount value)
{
    m_Count = value;
    m_set_State[0] |= 0xc;
}

inline
CTMgr_TypeStat_Base::TCount& CTMgr_TypeStat_Base::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        memset(&m_Count,UnassignedByte(),sizeof(m_Count));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Count;
}

inline
bool CTMgr_TypeStat_Base::IsSetLength_stats(void) const
{
    return m_Length_stats.NotEmpty();
}

inline
bool CTMgr_TypeStat_Base::CanGetLength_stats(void) const
{
    return IsSetLength_stats();
}

inline
const CTMgr_TypeStat_Base::TLength_stats& CTMgr_TypeStat_Base::GetLength_stats(void) const
{
    if (!CanGetLength_stats()) {
        ThrowUnassigned(2);
    }
    return (*m_Length_stats);
}

inline
bool CTMgr_TypeStat_Base::IsSetPosition_stats(void) const
{
    return m_Position_stats.NotEmpty();
}

inline
bool CTMgr_TypeStat_Base::CanGetPosition_stats(void) const
{
    return IsSetPosition_stats();
}

inline
const CTMgr_TypeStat_Base::TPosition_stats& CTMgr_TypeStat_Base::GetPosition_stats(void) const
{
    if (!CanGetPosition_stats()) {
        ThrowUnassigned(3);
    }
    return (*m_Position_stats);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_TYPESTAT_BASE_HPP
