/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_SwitchTrackContextReq_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_SWITCHTRACKCONTEXTREQ_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_SWITCHTRACKCONTEXTREQ_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_ClientInfo;
class CTMgr_DTrackId;
class CTMgr_GenomeContext;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_SwitchTrackContextRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_SwitchTrackContextRequest_Base(void);
    // destructor
    virtual ~CTMgr_SwitchTrackContextRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_ClientInfo TClient;
    typedef CTMgr_GenomeContext TNew_genome_context;
    typedef list< CRef< CTMgr_DTrackId > > TCurrent_dtrack_ids;
    typedef int TAnnotation_release_number;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_client,
        e_new_genome_context,
        e_current_dtrack_ids,
        e_annotation_release_number
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CTMgr_ClientInfo TClient
    ///  Check whether the Client data member has been assigned a value.
    bool IsSetClient(void) const;
    /// Check whether it is safe or not to call GetClient method.
    bool CanGetClient(void) const;
    void ResetClient(void);
    const TClient& GetClient(void) const;
    void SetClient(TClient& value);
    TClient& SetClient(void);

    /// mandatory
    /// typedef CTMgr_GenomeContext TNew_genome_context
    ///  Check whether the New_genome_context data member has been assigned a value.
    bool IsSetNew_genome_context(void) const;
    /// Check whether it is safe or not to call GetNew_genome_context method.
    bool CanGetNew_genome_context(void) const;
    void ResetNew_genome_context(void);
    const TNew_genome_context& GetNew_genome_context(void) const;
    void SetNew_genome_context(TNew_genome_context& value);
    TNew_genome_context& SetNew_genome_context(void);

    /// mandatory
    /// typedef list< CRef< CTMgr_DTrackId > > TCurrent_dtrack_ids
    ///  Check whether the Current_dtrack_ids data member has been assigned a value.
    bool IsSetCurrent_dtrack_ids(void) const;
    /// Check whether it is safe or not to call GetCurrent_dtrack_ids method.
    bool CanGetCurrent_dtrack_ids(void) const;
    void ResetCurrent_dtrack_ids(void);
    const TCurrent_dtrack_ids& GetCurrent_dtrack_ids(void) const;
    TCurrent_dtrack_ids& SetCurrent_dtrack_ids(void);

    /// optional
    /// typedef int TAnnotation_release_number
    ///  Check whether the Annotation_release_number data member has been assigned a value.
    bool IsSetAnnotation_release_number(void) const;
    /// Check whether it is safe or not to call GetAnnotation_release_number method.
    bool CanGetAnnotation_release_number(void) const;
    void ResetAnnotation_release_number(void);
    TAnnotation_release_number GetAnnotation_release_number(void) const;
    void SetAnnotation_release_number(TAnnotation_release_number value);
    TAnnotation_release_number& SetAnnotation_release_number(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_SwitchTrackContextRequest_Base(const CTMgr_SwitchTrackContextRequest_Base&);
    CTMgr_SwitchTrackContextRequest_Base& operator=(const CTMgr_SwitchTrackContextRequest_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TClient > m_Client;
    CRef< TNew_genome_context > m_New_genome_context;
    list< CRef< CTMgr_DTrackId > > m_Current_dtrack_ids;
    int m_Annotation_release_number;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_SwitchTrackContextRequest_Base::IsSetClient(void) const
{
    return m_Client.NotEmpty();
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::CanGetClient(void) const
{
    return true;
}

inline
const CTMgr_SwitchTrackContextRequest_Base::TClient& CTMgr_SwitchTrackContextRequest_Base::GetClient(void) const
{
    if ( !m_Client ) {
        const_cast<CTMgr_SwitchTrackContextRequest_Base*>(this)->ResetClient();
    }
    return (*m_Client);
}

inline
CTMgr_SwitchTrackContextRequest_Base::TClient& CTMgr_SwitchTrackContextRequest_Base::SetClient(void)
{
    if ( !m_Client ) {
        ResetClient();
    }
    return (*m_Client);
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::IsSetNew_genome_context(void) const
{
    return m_New_genome_context.NotEmpty();
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::CanGetNew_genome_context(void) const
{
    return true;
}

inline
const CTMgr_SwitchTrackContextRequest_Base::TNew_genome_context& CTMgr_SwitchTrackContextRequest_Base::GetNew_genome_context(void) const
{
    if ( !m_New_genome_context ) {
        const_cast<CTMgr_SwitchTrackContextRequest_Base*>(this)->ResetNew_genome_context();
    }
    return (*m_New_genome_context);
}

inline
CTMgr_SwitchTrackContextRequest_Base::TNew_genome_context& CTMgr_SwitchTrackContextRequest_Base::SetNew_genome_context(void)
{
    if ( !m_New_genome_context ) {
        ResetNew_genome_context();
    }
    return (*m_New_genome_context);
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::IsSetCurrent_dtrack_ids(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::CanGetCurrent_dtrack_ids(void) const
{
    return true;
}

inline
const CTMgr_SwitchTrackContextRequest_Base::TCurrent_dtrack_ids& CTMgr_SwitchTrackContextRequest_Base::GetCurrent_dtrack_ids(void) const
{
    return m_Current_dtrack_ids;
}

inline
CTMgr_SwitchTrackContextRequest_Base::TCurrent_dtrack_ids& CTMgr_SwitchTrackContextRequest_Base::SetCurrent_dtrack_ids(void)
{
    m_set_State[0] |= 0x10;
    return m_Current_dtrack_ids;
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::IsSetAnnotation_release_number(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_SwitchTrackContextRequest_Base::CanGetAnnotation_release_number(void) const
{
    return IsSetAnnotation_release_number();
}

inline
void CTMgr_SwitchTrackContextRequest_Base::ResetAnnotation_release_number(void)
{
    m_Annotation_release_number = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CTMgr_SwitchTrackContextRequest_Base::TAnnotation_release_number CTMgr_SwitchTrackContextRequest_Base::GetAnnotation_release_number(void) const
{
    if (!CanGetAnnotation_release_number()) {
        ThrowUnassigned(3);
    }
    return m_Annotation_release_number;
}

inline
void CTMgr_SwitchTrackContextRequest_Base::SetAnnotation_release_number(CTMgr_SwitchTrackContextRequest_Base::TAnnotation_release_number value)
{
    m_Annotation_release_number = value;
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_SwitchTrackContextRequest_Base::TAnnotation_release_number& CTMgr_SwitchTrackContextRequest_Base::SetAnnotation_release_number(void)
{
#ifdef _DEBUG
    if (!IsSetAnnotation_release_number()) {
        memset(&m_Annotation_release_number,UnassignedByte(),sizeof(m_Annotation_release_number));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Annotation_release_number;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_SWITCHTRACKCONTEXTREQ_BASE_HPP
