/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_SeqTrackIdRequest_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_SEQTRACKIDREQUEST_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_SEQTRACKIDREQUEST_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_SeqTrackIdRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_SeqTrackIdRequest_Base(void);
    // destructor
    virtual ~CTMgr_SeqTrackIdRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TSeq_accession;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_accession
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TSeq_accession
    ///  Check whether the Seq_accession data member has been assigned a value.
    bool IsSetSeq_accession(void) const;
    /// Check whether it is safe or not to call GetSeq_accession method.
    bool CanGetSeq_accession(void) const;
    void ResetSeq_accession(void);
    const TSeq_accession& GetSeq_accession(void) const;
    void SetSeq_accession(const TSeq_accession& value);
    void SetSeq_accession(TSeq_accession&& value);
    TSeq_accession& SetSeq_accession(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_SeqTrackIdRequest_Base(const CTMgr_SeqTrackIdRequest_Base&);
    CTMgr_SeqTrackIdRequest_Base& operator=(const CTMgr_SeqTrackIdRequest_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Seq_accession;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_SeqTrackIdRequest_Base::IsSetSeq_accession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_SeqTrackIdRequest_Base::CanGetSeq_accession(void) const
{
    return IsSetSeq_accession();
}

inline
const CTMgr_SeqTrackIdRequest_Base::TSeq_accession& CTMgr_SeqTrackIdRequest_Base::GetSeq_accession(void) const
{
    if (!CanGetSeq_accession()) {
        ThrowUnassigned(0);
    }
    return m_Seq_accession;
}

inline
void CTMgr_SeqTrackIdRequest_Base::SetSeq_accession(const CTMgr_SeqTrackIdRequest_Base::TSeq_accession& value)
{
    m_Seq_accession = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_SeqTrackIdRequest_Base::SetSeq_accession(CTMgr_SeqTrackIdRequest_Base::TSeq_accession&& value)
{
    m_Seq_accession = std::forward<CTMgr_SeqTrackIdRequest_Base::TSeq_accession>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_SeqTrackIdRequest_Base::TSeq_accession& CTMgr_SeqTrackIdRequest_Base::SetSeq_accession(void)
{
#ifdef _DEBUG
    if (!IsSetSeq_accession()) {
        m_Seq_accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Seq_accession;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_SEQTRACKIDREQUEST_BASE_HPP
