/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_IdentityId_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_IDENTITYID_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_IDENTITYID_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/trackmgr/TMgr_IdentityIdType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_IdentityId_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_IdentityId_Base(void);
    // destructor
    virtual ~CTMgr_IdentityId_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TId;
    typedef int TId_type;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_id_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    void SetId(TId&& value);
    TId& SetId(void);

    /// mandatory
    /// typedef int TId_type
    ///  Check whether the Id_type data member has been assigned a value.
    bool IsSetId_type(void) const;
    /// Check whether it is safe or not to call GetId_type method.
    bool CanGetId_type(void) const;
    void ResetId_type(void);
    TId_type GetId_type(void) const;
    void SetId_type(TId_type value);
    TId_type& SetId_type(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_IdentityId_Base(const CTMgr_IdentityId_Base&);
    CTMgr_IdentityId_Base& operator=(const CTMgr_IdentityId_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Id;
    int m_Id_type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_IdentityId_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_IdentityId_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CTMgr_IdentityId_Base::TId& CTMgr_IdentityId_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CTMgr_IdentityId_Base::SetId(const CTMgr_IdentityId_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_IdentityId_Base::SetId(CTMgr_IdentityId_Base::TId&& value)
{
    m_Id = std::forward<CTMgr_IdentityId_Base::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_IdentityId_Base::TId& CTMgr_IdentityId_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CTMgr_IdentityId_Base::IsSetId_type(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_IdentityId_Base::CanGetId_type(void) const
{
    return IsSetId_type();
}

inline
void CTMgr_IdentityId_Base::ResetId_type(void)
{
    m_Id_type = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CTMgr_IdentityId_Base::TId_type CTMgr_IdentityId_Base::GetId_type(void) const
{
    if (!CanGetId_type()) {
        ThrowUnassigned(1);
    }
    return m_Id_type;
}

inline
void CTMgr_IdentityId_Base::SetId_type(CTMgr_IdentityId_Base::TId_type value)
{
    m_Id_type = value;
    m_set_State[0] |= 0xc;
}

inline
CTMgr_IdentityId_Base::TId_type& CTMgr_IdentityId_Base::SetId_type(void)
{
#ifdef _DEBUG
    if (!IsSetId_type()) {
        memset(&m_Id_type,UnassignedByte(),sizeof(m_Id_type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Id_type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_IDENTITYID_BASE_HPP
