/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_CreateRemoteTrackRequ_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_CREATEREMOTETRACKREQU_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_CREATEREMOTETRACKREQU_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/trackmgr/TMgr_TypeTrackType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_Attribute;
class CTMgr_ClientInfo;
class CTMgr_Hub;
class CTMgr_HubTrack;
class CTMgr_Identity;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///-
///- Used to create remote tracks, hubs and tracks in hubs
///-
class NCBI_TRACKMGR_EXPORT CTMgr_CreateRemoteTrackRequest_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_CreateRemoteTrackRequest_Base(void);
    // destructor
    virtual ~CTMgr_CreateRemoteTrackRequest_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// Hub Track Database specific fields
    class NCBI_TRACKMGR_EXPORT C_Track_db : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Track_db(void);
        // destructor
        ~C_Track_db(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Hub,
            e_Track
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Track+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CTMgr_Hub THub;
        typedef CTMgr_HubTrack TTrack;
    
        // getters
        // setters
    
        // typedef CTMgr_Hub THub
        bool IsHub(void) const;
        const THub& GetHub(void) const;
        THub& SetHub(void);
        void SetHub(THub& value);
    
        // typedef CTMgr_HubTrack TTrack
        bool IsTrack(void) const;
        const TTrack& GetTrack(void) const;
        TTrack& SetTrack(void);
        void SetTrack(TTrack& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Track_db(const C_Track_db& );
        C_Track_db& operator=(const C_Track_db& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef CTMgr_Identity TIdentity;
    typedef string TAssembly_acc;
    typedef string TUrl;
    typedef int TType;
    typedef string TTrack_name;
    typedef string TIndex_url;
    typedef C_Track_db TTrack_db;
    typedef list< CRef< CTMgr_Attribute > > TAttrs;
    typedef CTMgr_ClientInfo TClient;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_identity,
        e_assembly_acc,
        e_url,
        e_type,
        e_track_name,
        e_index_url,
        e_track_db,
        e_attrs,
        e_client
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// common to hubs and tracks
    /// identity of user
    /// mandatory
    /// typedef CTMgr_Identity TIdentity
    ///  Check whether the Identity data member has been assigned a value.
    bool IsSetIdentity(void) const;
    /// Check whether it is safe or not to call GetIdentity method.
    bool CanGetIdentity(void) const;
    void ResetIdentity(void);
    const TIdentity& GetIdentity(void) const;
    void SetIdentity(TIdentity& value);
    TIdentity& SetIdentity(void);

    ///  NCBI assembly accession
    /// mandatory
    /// typedef string TAssembly_acc
    ///  Check whether the Assembly_acc data member has been assigned a value.
    bool IsSetAssembly_acc(void) const;
    /// Check whether it is safe or not to call GetAssembly_acc method.
    bool CanGetAssembly_acc(void) const;
    void ResetAssembly_acc(void);
    const TAssembly_acc& GetAssembly_acc(void) const;
    void SetAssembly_acc(const TAssembly_acc& value);
    void SetAssembly_acc(TAssembly_acc&& value);
    TAssembly_acc& SetAssembly_acc(void);

    /// url to track data or hub.txt
    /// mandatory
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// track specific, i.e., when type != hub
    /// optional
    /// typedef string TTrack_name
    ///  Check whether the Track_name data member has been assigned a value.
    bool IsSetTrack_name(void) const;
    /// Check whether it is safe or not to call GetTrack_name method.
    bool CanGetTrack_name(void) const;
    void ResetTrack_name(void);
    const TTrack_name& GetTrack_name(void) const;
    void SetTrack_name(const TTrack_name& value);
    void SetTrack_name(TTrack_name&& value);
    TTrack_name& SetTrack_name(void);

    /// for tracks only, not hubs
    /// optional
    /// typedef string TIndex_url
    ///  Check whether the Index_url data member has been assigned a value.
    bool IsSetIndex_url(void) const;
    /// Check whether it is safe or not to call GetIndex_url method.
    bool CanGetIndex_url(void) const;
    void ResetIndex_url(void);
    const TIndex_url& GetIndex_url(void) const;
    void SetIndex_url(const TIndex_url& value);
    void SetIndex_url(TIndex_url&& value);
    TIndex_url& SetIndex_url(void);

    /// optional
    /// typedef C_Track_db TTrack_db
    ///  Check whether the Track_db data member has been assigned a value.
    bool IsSetTrack_db(void) const;
    /// Check whether it is safe or not to call GetTrack_db method.
    bool CanGetTrack_db(void) const;
    void ResetTrack_db(void);
    const TTrack_db& GetTrack_db(void) const;
    void SetTrack_db(TTrack_db& value);
    TTrack_db& SetTrack_db(void);

    /// future use
    /// optional
    /// typedef list< CRef< CTMgr_Attribute > > TAttrs
    ///  Check whether the Attrs data member has been assigned a value.
    bool IsSetAttrs(void) const;
    /// Check whether it is safe or not to call GetAttrs method.
    bool CanGetAttrs(void) const;
    void ResetAttrs(void);
    const TAttrs& GetAttrs(void) const;
    TAttrs& SetAttrs(void);

    /// Client information
    /// optional
    /// typedef CTMgr_ClientInfo TClient
    ///  Check whether the Client data member has been assigned a value.
    bool IsSetClient(void) const;
    /// Check whether it is safe or not to call GetClient method.
    bool CanGetClient(void) const;
    void ResetClient(void);
    const TClient& GetClient(void) const;
    void SetClient(TClient& value);
    TClient& SetClient(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_CreateRemoteTrackRequest_Base(const CTMgr_CreateRemoteTrackRequest_Base&);
    CTMgr_CreateRemoteTrackRequest_Base& operator=(const CTMgr_CreateRemoteTrackRequest_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TIdentity > m_Identity;
    string m_Assembly_acc;
    string m_Url;
    int m_Type;
    string m_Track_name;
    string m_Index_url;
    CRef< TTrack_db > m_Track_db;
    list< CRef< CTMgr_Attribute > > m_Attrs;
    CRef< TClient > m_Client;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::E_Choice CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::Which(void) const
{
    return m_choice;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::IsHub(void) const
{
    return m_choice == e_Hub;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::C_Track_db::IsTrack(void) const
{
    return m_choice == e_Track;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetIdentity(void) const
{
    return m_Identity.NotEmpty();
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetIdentity(void) const
{
    return true;
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TIdentity& CTMgr_CreateRemoteTrackRequest_Base::GetIdentity(void) const
{
    if ( !m_Identity ) {
        const_cast<CTMgr_CreateRemoteTrackRequest_Base*>(this)->ResetIdentity();
    }
    return (*m_Identity);
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TIdentity& CTMgr_CreateRemoteTrackRequest_Base::SetIdentity(void)
{
    if ( !m_Identity ) {
        ResetIdentity();
    }
    return (*m_Identity);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetAssembly_acc(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetAssembly_acc(void) const
{
    return IsSetAssembly_acc();
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TAssembly_acc& CTMgr_CreateRemoteTrackRequest_Base::GetAssembly_acc(void) const
{
    if (!CanGetAssembly_acc()) {
        ThrowUnassigned(1);
    }
    return m_Assembly_acc;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetAssembly_acc(const CTMgr_CreateRemoteTrackRequest_Base::TAssembly_acc& value)
{
    m_Assembly_acc = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetAssembly_acc(CTMgr_CreateRemoteTrackRequest_Base::TAssembly_acc&& value)
{
    m_Assembly_acc = std::forward<CTMgr_CreateRemoteTrackRequest_Base::TAssembly_acc>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TAssembly_acc& CTMgr_CreateRemoteTrackRequest_Base::SetAssembly_acc(void)
{
#ifdef _DEBUG
    if (!IsSetAssembly_acc()) {
        m_Assembly_acc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Assembly_acc;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TUrl& CTMgr_CreateRemoteTrackRequest_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(2);
    }
    return m_Url;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetUrl(const CTMgr_CreateRemoteTrackRequest_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0x30;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetUrl(CTMgr_CreateRemoteTrackRequest_Base::TUrl&& value)
{
    m_Url = std::forward<CTMgr_CreateRemoteTrackRequest_Base::TUrl>(value);
    m_set_State[0] |= 0x30;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TUrl& CTMgr_CreateRemoteTrackRequest_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Url;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::ResetType(void)
{
    m_Type = (int)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TType CTMgr_CreateRemoteTrackRequest_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(3);
    }
    return m_Type;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetType(CTMgr_CreateRemoteTrackRequest_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TType& CTMgr_CreateRemoteTrackRequest_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Type;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetTrack_name(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetTrack_name(void) const
{
    return IsSetTrack_name();
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TTrack_name& CTMgr_CreateRemoteTrackRequest_Base::GetTrack_name(void) const
{
    if (!CanGetTrack_name()) {
        ThrowUnassigned(4);
    }
    return m_Track_name;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetTrack_name(const CTMgr_CreateRemoteTrackRequest_Base::TTrack_name& value)
{
    m_Track_name = value;
    m_set_State[0] |= 0x300;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetTrack_name(CTMgr_CreateRemoteTrackRequest_Base::TTrack_name&& value)
{
    m_Track_name = std::forward<CTMgr_CreateRemoteTrackRequest_Base::TTrack_name>(value);
    m_set_State[0] |= 0x300;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TTrack_name& CTMgr_CreateRemoteTrackRequest_Base::SetTrack_name(void)
{
#ifdef _DEBUG
    if (!IsSetTrack_name()) {
        m_Track_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Track_name;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetIndex_url(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetIndex_url(void) const
{
    return IsSetIndex_url();
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TIndex_url& CTMgr_CreateRemoteTrackRequest_Base::GetIndex_url(void) const
{
    if (!CanGetIndex_url()) {
        ThrowUnassigned(5);
    }
    return m_Index_url;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetIndex_url(const CTMgr_CreateRemoteTrackRequest_Base::TIndex_url& value)
{
    m_Index_url = value;
    m_set_State[0] |= 0xc00;
}

inline
void CTMgr_CreateRemoteTrackRequest_Base::SetIndex_url(CTMgr_CreateRemoteTrackRequest_Base::TIndex_url&& value)
{
    m_Index_url = std::forward<CTMgr_CreateRemoteTrackRequest_Base::TIndex_url>(value);
    m_set_State[0] |= 0xc00;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TIndex_url& CTMgr_CreateRemoteTrackRequest_Base::SetIndex_url(void)
{
#ifdef _DEBUG
    if (!IsSetIndex_url()) {
        m_Index_url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Index_url;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetTrack_db(void) const
{
    return m_Track_db.NotEmpty();
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetTrack_db(void) const
{
    return IsSetTrack_db();
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TTrack_db& CTMgr_CreateRemoteTrackRequest_Base::GetTrack_db(void) const
{
    if (!CanGetTrack_db()) {
        ThrowUnassigned(6);
    }
    return (*m_Track_db);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetAttrs(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetAttrs(void) const
{
    return true;
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TAttrs& CTMgr_CreateRemoteTrackRequest_Base::GetAttrs(void) const
{
    return m_Attrs;
}

inline
CTMgr_CreateRemoteTrackRequest_Base::TAttrs& CTMgr_CreateRemoteTrackRequest_Base::SetAttrs(void)
{
    m_set_State[0] |= 0x4000;
    return m_Attrs;
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::IsSetClient(void) const
{
    return m_Client.NotEmpty();
}

inline
bool CTMgr_CreateRemoteTrackRequest_Base::CanGetClient(void) const
{
    return IsSetClient();
}

inline
const CTMgr_CreateRemoteTrackRequest_Base::TClient& CTMgr_CreateRemoteTrackRequest_Base::GetClient(void) const
{
    if (!CanGetClient()) {
        ThrowUnassigned(8);
    }
    return (*m_Client);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_CREATEREMOTETRACKREQU_BASE_HPP
