/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_Assembly_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_ASSEMBLY_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_ASSEMBLY_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_Assembly_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_Assembly_Base(void);
    // destructor
    virtual ~CTMgr_Assembly_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TAccession;
    typedef CStringUTF8 TName;
    typedef CStringUTF8 TShort_name;
    typedef CStringUTF8 TDescription;
    typedef bool TIs_complete;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_accession,
        e_name,
        e_short_name,
        e_description,
        e_is_complete
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// mandatory
    /// typedef CStringUTF8 TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef CStringUTF8 TShort_name
    ///  Check whether the Short_name data member has been assigned a value.
    bool IsSetShort_name(void) const;
    /// Check whether it is safe or not to call GetShort_name method.
    bool CanGetShort_name(void) const;
    void ResetShort_name(void);
    const TShort_name& GetShort_name(void) const;
    void SetShort_name(const TShort_name& value);
    void SetShort_name(TShort_name&& value);
    TShort_name& SetShort_name(void);

    /// optional
    /// typedef CStringUTF8 TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(const TDescription& value);
    void SetDescription(TDescription&& value);
    TDescription& SetDescription(void);

    /// optional
    /// typedef bool TIs_complete
    ///  Check whether the Is_complete data member has been assigned a value.
    bool IsSetIs_complete(void) const;
    /// Check whether it is safe or not to call GetIs_complete method.
    bool CanGetIs_complete(void) const;
    void ResetIs_complete(void);
    TIs_complete GetIs_complete(void) const;
    void SetIs_complete(TIs_complete value);
    TIs_complete& SetIs_complete(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_Assembly_Base(const CTMgr_Assembly_Base&);
    CTMgr_Assembly_Base& operator=(const CTMgr_Assembly_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Accession;
    CStringUTF8 m_Name;
    CStringUTF8 m_Short_name;
    CStringUTF8 m_Description;
    bool m_Is_complete;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_Assembly_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_Assembly_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CTMgr_Assembly_Base::TAccession& CTMgr_Assembly_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(0);
    }
    return m_Accession;
}

inline
void CTMgr_Assembly_Base::SetAccession(const CTMgr_Assembly_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x3;
}

inline
void CTMgr_Assembly_Base::SetAccession(CTMgr_Assembly_Base::TAccession&& value)
{
    m_Accession = std::forward<CTMgr_Assembly_Base::TAccession>(value);
    m_set_State[0] |= 0x3;
}

inline
CTMgr_Assembly_Base::TAccession& CTMgr_Assembly_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Accession;
}

inline
bool CTMgr_Assembly_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTMgr_Assembly_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CTMgr_Assembly_Base::TName& CTMgr_Assembly_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CTMgr_Assembly_Base::SetName(const CTMgr_Assembly_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CTMgr_Assembly_Base::SetName(CTMgr_Assembly_Base::TName&& value)
{
    m_Name = std::forward<CTMgr_Assembly_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CTMgr_Assembly_Base::TName& CTMgr_Assembly_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CTMgr_Assembly_Base::IsSetShort_name(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTMgr_Assembly_Base::CanGetShort_name(void) const
{
    return IsSetShort_name();
}

inline
const CTMgr_Assembly_Base::TShort_name& CTMgr_Assembly_Base::GetShort_name(void) const
{
    if (!CanGetShort_name()) {
        ThrowUnassigned(2);
    }
    return m_Short_name;
}

inline
void CTMgr_Assembly_Base::SetShort_name(const CTMgr_Assembly_Base::TShort_name& value)
{
    m_Short_name = value;
    m_set_State[0] |= 0x30;
}

inline
void CTMgr_Assembly_Base::SetShort_name(CTMgr_Assembly_Base::TShort_name&& value)
{
    m_Short_name = std::forward<CTMgr_Assembly_Base::TShort_name>(value);
    m_set_State[0] |= 0x30;
}

inline
CTMgr_Assembly_Base::TShort_name& CTMgr_Assembly_Base::SetShort_name(void)
{
#ifdef _DEBUG
    if (!IsSetShort_name()) {
        m_Short_name = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Short_name;
}

inline
bool CTMgr_Assembly_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTMgr_Assembly_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CTMgr_Assembly_Base::TDescription& CTMgr_Assembly_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(3);
    }
    return m_Description;
}

inline
void CTMgr_Assembly_Base::SetDescription(const CTMgr_Assembly_Base::TDescription& value)
{
    m_Description = value;
    m_set_State[0] |= 0xc0;
}

inline
void CTMgr_Assembly_Base::SetDescription(CTMgr_Assembly_Base::TDescription&& value)
{
    m_Description = std::forward<CTMgr_Assembly_Base::TDescription>(value);
    m_set_State[0] |= 0xc0;
}

inline
CTMgr_Assembly_Base::TDescription& CTMgr_Assembly_Base::SetDescription(void)
{
#ifdef _DEBUG
    if (!IsSetDescription()) {
        m_Description = UnassignedStringUTF8();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Description;
}

inline
bool CTMgr_Assembly_Base::IsSetIs_complete(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTMgr_Assembly_Base::CanGetIs_complete(void) const
{
    return IsSetIs_complete();
}

inline
void CTMgr_Assembly_Base::ResetIs_complete(void)
{
    m_Is_complete = 0;
    m_set_State[0] &= ~0x300;
}

inline
CTMgr_Assembly_Base::TIs_complete CTMgr_Assembly_Base::GetIs_complete(void) const
{
    if (!CanGetIs_complete()) {
        ThrowUnassigned(4);
    }
    return m_Is_complete;
}

inline
void CTMgr_Assembly_Base::SetIs_complete(CTMgr_Assembly_Base::TIs_complete value)
{
    m_Is_complete = value;
    m_set_State[0] |= 0x300;
}

inline
CTMgr_Assembly_Base::TIs_complete& CTMgr_Assembly_Base::SetIs_complete(void)
{
#ifdef _DEBUG
    if (!IsSetIs_complete()) {
        memset(&m_Is_complete,UnassignedByte(),sizeof(m_Is_complete));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Is_complete;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_ASSEMBLY_BASE_HPP
