/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file TMgr_AnnotCounts_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'trackmgr.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TRACKMGR_TMGR_ANNOTCOUNTS_BASE_HPP
#define OBJECTS_TRACKMGR_TMGR_ANNOTCOUNTS_BASE_HPP

// extra headers
#include <objects/trackmgr/trackmgr_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CTMgr_TypeStat;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TRACKMGR_EXPORT CTMgr_AnnotCounts_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTMgr_AnnotCounts_Base(void);
    // destructor
    virtual ~CTMgr_AnnotCounts_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CTMgr_TypeStat C_E;
    typedef list< CRef< CTMgr_TypeStat > > TCounts;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_counts
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< CTMgr_TypeStat > > TCounts
    ///  Check whether the Counts data member has been assigned a value.
    bool IsSetCounts(void) const;
    /// Check whether it is safe or not to call GetCounts method.
    bool CanGetCounts(void) const;
    void ResetCounts(void);
    const TCounts& GetCounts(void) const;
    TCounts& SetCounts(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTMgr_AnnotCounts_Base(const CTMgr_AnnotCounts_Base&);
    CTMgr_AnnotCounts_Base& operator=(const CTMgr_AnnotCounts_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CTMgr_TypeStat > > m_Counts;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTMgr_AnnotCounts_Base::IsSetCounts(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTMgr_AnnotCounts_Base::CanGetCounts(void) const
{
    return true;
}

inline
const CTMgr_AnnotCounts_Base::TCounts& CTMgr_AnnotCounts_Base::GetCounts(void) const
{
    return m_Counts;
}

inline
CTMgr_AnnotCounts_Base::TCounts& CTMgr_AnnotCounts_Base::SetCounts(void)
{
    m_set_State[0] |= 0x1;
    return m_Counts;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TRACKMGR_TMGR_ANNOTCOUNTS_BASE_HPP
