/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file T3Error_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'taxon3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_TAXON3_T3ERROR_BASE_HPP
#define OBJECTS_TAXON3_T3ERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class COrg_ref;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_TAXON3_EXPORT CT3Error_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CT3Error_Base(void);
    // destructor
    virtual ~CT3Error_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ELevel {
        eLevel_none  = 0,  ///< not an error, just a message
        eLevel_info  = 1,  ///< informational error
        eLevel_warn  = 2,
        eLevel_error = 3,
        eLevel_fatal = 4
    };
    
    /// Access to ELevel's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ELevel)(void);
    
    // types
    typedef ELevel TLevel;
    typedef string TMessage;
    typedef int TTaxid;
    typedef string TName;
    typedef COrg_ref TOrg;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_level,
        e_message,
        e_taxid,
        e_name,
        e_org
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ELevel TLevel
    ///  Check whether the Level data member has been assigned a value.
    bool IsSetLevel(void) const;
    /// Check whether it is safe or not to call GetLevel method.
    bool CanGetLevel(void) const;
    void ResetLevel(void);
    TLevel GetLevel(void) const;
    void SetLevel(TLevel value);
    TLevel& SetLevel(void);

    /// mandatory
    /// typedef string TMessage
    ///  Check whether the Message data member has been assigned a value.
    bool IsSetMessage(void) const;
    /// Check whether it is safe or not to call GetMessage method.
    bool CanGetMessage(void) const;
    void ResetMessage(void);
    const TMessage& GetMessage(void) const;
    void SetMessage(const TMessage& value);
    void SetMessage(TMessage&& value);
    TMessage& SetMessage(void);

    /// optional
    /// typedef int TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef COrg_ref TOrg
    ///  Check whether the Org data member has been assigned a value.
    bool IsSetOrg(void) const;
    /// Check whether it is safe or not to call GetOrg method.
    bool CanGetOrg(void) const;
    void ResetOrg(void);
    const TOrg& GetOrg(void) const;
    void SetOrg(TOrg& value);
    TOrg& SetOrg(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CT3Error_Base(const CT3Error_Base&);
    CT3Error_Base& operator=(const CT3Error_Base&);

    // data
    Uint4 m_set_State[1];
    ELevel m_Level;
    string m_Message;
    int m_Taxid;
    string m_Name;
    CRef< TOrg > m_Org;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CT3Error_Base::IsSetLevel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CT3Error_Base::CanGetLevel(void) const
{
    return IsSetLevel();
}

inline
void CT3Error_Base::ResetLevel(void)
{
    m_Level = (ELevel)(0);
    m_set_State[0] &= ~0x3;
}

inline
CT3Error_Base::TLevel CT3Error_Base::GetLevel(void) const
{
    if (!CanGetLevel()) {
        ThrowUnassigned(0);
    }
    return m_Level;
}

inline
void CT3Error_Base::SetLevel(CT3Error_Base::TLevel value)
{
    m_Level = value;
    m_set_State[0] |= 0x3;
}

inline
CT3Error_Base::TLevel& CT3Error_Base::SetLevel(void)
{
#ifdef _DEBUG
    if (!IsSetLevel()) {
        memset(&m_Level,UnassignedByte(),sizeof(m_Level));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Level;
}

inline
bool CT3Error_Base::IsSetMessage(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CT3Error_Base::CanGetMessage(void) const
{
    return IsSetMessage();
}

inline
const CT3Error_Base::TMessage& CT3Error_Base::GetMessage(void) const
{
    if (!CanGetMessage()) {
        ThrowUnassigned(1);
    }
    return m_Message;
}

inline
void CT3Error_Base::SetMessage(const CT3Error_Base::TMessage& value)
{
    m_Message = value;
    m_set_State[0] |= 0xc;
}

inline
void CT3Error_Base::SetMessage(CT3Error_Base::TMessage&& value)
{
    m_Message = std::forward<CT3Error_Base::TMessage>(value);
    m_set_State[0] |= 0xc;
}

inline
CT3Error_Base::TMessage& CT3Error_Base::SetMessage(void)
{
#ifdef _DEBUG
    if (!IsSetMessage()) {
        m_Message = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Message;
}

inline
bool CT3Error_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CT3Error_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CT3Error_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0x30;
}

inline
CT3Error_Base::TTaxid CT3Error_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(2);
    }
    return m_Taxid;
}

inline
void CT3Error_Base::SetTaxid(CT3Error_Base::TTaxid value)
{
    m_Taxid = value;
    m_set_State[0] |= 0x30;
}

inline
CT3Error_Base::TTaxid& CT3Error_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Taxid;
}

inline
bool CT3Error_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CT3Error_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CT3Error_Base::TName& CT3Error_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(3);
    }
    return m_Name;
}

inline
void CT3Error_Base::SetName(const CT3Error_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc0;
}

inline
void CT3Error_Base::SetName(CT3Error_Base::TName&& value)
{
    m_Name = std::forward<CT3Error_Base::TName>(value);
    m_set_State[0] |= 0xc0;
}

inline
CT3Error_Base::TName& CT3Error_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Name;
}

inline
bool CT3Error_Base::IsSetOrg(void) const
{
    return m_Org.NotEmpty();
}

inline
bool CT3Error_Base::CanGetOrg(void) const
{
    return IsSetOrg();
}

inline
const CT3Error_Base::TOrg& CT3Error_Base::GetOrg(void) const
{
    if (!CanGetOrg()) {
        ThrowUnassigned(4);
    }
    return (*m_Org);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_TAXON3_T3ERROR_BASE_HPP
