/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Submit_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'submit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SUBMIT_SUBMIT_BLOCK_BASE_HPP
#define OBJECTS_SUBMIT_SUBMIT_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCit_sub;
class CContact_info;
class CDate;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SUBMIT_EXPORT CSubmit_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSubmit_block_Base(void);
    // destructor
    virtual ~CSubmit_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// type of submission
    enum ESubtype {
        eSubtype_new      =   1,  ///< new data
        eSubtype_update   =   2,  ///< update by author
        eSubtype_revision =   3,  ///< 3rd party (non-author) update
        eSubtype_other    = 255
    };
    
    /// Access to ESubtype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESubtype)(void);
    
    // types
    typedef CContact_info TContact;
    typedef CCit_sub TCit;
    typedef bool THup;
    typedef CDate TReldate;
    typedef int TSubtype;
    typedef string TTool;
    typedef string TUser_tag;
    typedef string TComment;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_contact,
        e_cit,
        e_hup,
        e_reldate,
        e_subtype,
        e_tool,
        e_user_tag,
        e_comment
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// who to contact
    /// mandatory
    /// typedef CContact_info TContact
    ///  Check whether the Contact data member has been assigned a value.
    bool IsSetContact(void) const;
    /// Check whether it is safe or not to call GetContact method.
    bool CanGetContact(void) const;
    void ResetContact(void);
    const TContact& GetContact(void) const;
    void SetContact(TContact& value);
    TContact& SetContact(void);

    /// citation for this submission
    /// mandatory
    /// typedef CCit_sub TCit
    ///  Check whether the Cit data member has been assigned a value.
    bool IsSetCit(void) const;
    /// Check whether it is safe or not to call GetCit method.
    bool CanGetCit(void) const;
    void ResetCit(void);
    const TCit& GetCit(void) const;
    void SetCit(TCit& value);
    TCit& SetCit(void);

    /// hold until publish
    /// optional with default false
    /// typedef bool THup
    ///  Check whether the Hup data member has been assigned a value.
    bool IsSetHup(void) const;
    /// Check whether it is safe or not to call GetHup method.
    bool CanGetHup(void) const;
    void ResetHup(void);
    void SetDefaultHup(void);
    THup GetHup(void) const;
    void SetHup(THup value);
    THup& SetHup(void);

    /// release by date
    /// optional
    /// typedef CDate TReldate
    ///  Check whether the Reldate data member has been assigned a value.
    bool IsSetReldate(void) const;
    /// Check whether it is safe or not to call GetReldate method.
    bool CanGetReldate(void) const;
    void ResetReldate(void);
    const TReldate& GetReldate(void) const;
    void SetReldate(TReldate& value);
    TReldate& SetReldate(void);

    /// optional
    /// typedef int TSubtype
    ///  Check whether the Subtype data member has been assigned a value.
    bool IsSetSubtype(void) const;
    /// Check whether it is safe or not to call GetSubtype method.
    bool CanGetSubtype(void) const;
    void ResetSubtype(void);
    TSubtype GetSubtype(void) const;
    void SetSubtype(TSubtype value);
    TSubtype& SetSubtype(void);

    /// tool used to make submission
    /// optional
    /// typedef string TTool
    ///  Check whether the Tool data member has been assigned a value.
    bool IsSetTool(void) const;
    /// Check whether it is safe or not to call GetTool method.
    bool CanGetTool(void) const;
    void ResetTool(void);
    const TTool& GetTool(void) const;
    void SetTool(const TTool& value);
    void SetTool(TTool&& value);
    TTool& SetTool(void);

    /// user supplied id for this submission
    /// optional
    /// typedef string TUser_tag
    ///  Check whether the User_tag data member has been assigned a value.
    bool IsSetUser_tag(void) const;
    /// Check whether it is safe or not to call GetUser_tag method.
    bool CanGetUser_tag(void) const;
    void ResetUser_tag(void);
    const TUser_tag& GetUser_tag(void) const;
    void SetUser_tag(const TUser_tag& value);
    void SetUser_tag(TUser_tag&& value);
    TUser_tag& SetUser_tag(void);

    /// user comments/advice to database
    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSubmit_block_Base(const CSubmit_block_Base&);
    CSubmit_block_Base& operator=(const CSubmit_block_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TContact > m_Contact;
    CRef< TCit > m_Cit;
    bool m_Hup;
    CRef< TReldate > m_Reldate;
    int m_Subtype;
    string m_Tool;
    string m_User_tag;
    string m_Comment;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSubmit_block_Base::IsSetContact(void) const
{
    return m_Contact.NotEmpty();
}

inline
bool CSubmit_block_Base::CanGetContact(void) const
{
    return true;
}

inline
const CSubmit_block_Base::TContact& CSubmit_block_Base::GetContact(void) const
{
    if ( !m_Contact ) {
        const_cast<CSubmit_block_Base*>(this)->ResetContact();
    }
    return (*m_Contact);
}

inline
CSubmit_block_Base::TContact& CSubmit_block_Base::SetContact(void)
{
    if ( !m_Contact ) {
        ResetContact();
    }
    return (*m_Contact);
}

inline
bool CSubmit_block_Base::IsSetCit(void) const
{
    return m_Cit.NotEmpty();
}

inline
bool CSubmit_block_Base::CanGetCit(void) const
{
    return true;
}

inline
const CSubmit_block_Base::TCit& CSubmit_block_Base::GetCit(void) const
{
    if ( !m_Cit ) {
        const_cast<CSubmit_block_Base*>(this)->ResetCit();
    }
    return (*m_Cit);
}

inline
CSubmit_block_Base::TCit& CSubmit_block_Base::SetCit(void)
{
    if ( !m_Cit ) {
        ResetCit();
    }
    return (*m_Cit);
}

inline
bool CSubmit_block_Base::IsSetHup(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSubmit_block_Base::CanGetHup(void) const
{
    return true;
}

inline
void CSubmit_block_Base::ResetHup(void)
{
    m_Hup = false;
    m_set_State[0] &= ~0x30;
}

inline
void CSubmit_block_Base::SetDefaultHup(void)
{
    ResetHup();
}

inline
CSubmit_block_Base::THup CSubmit_block_Base::GetHup(void) const
{
    return m_Hup;
}

inline
void CSubmit_block_Base::SetHup(CSubmit_block_Base::THup value)
{
    m_Hup = value;
    m_set_State[0] |= 0x30;
}

inline
CSubmit_block_Base::THup& CSubmit_block_Base::SetHup(void)
{
#ifdef _DEBUG
    if (!IsSetHup()) {
        memset(&m_Hup,UnassignedByte(),sizeof(m_Hup));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Hup;
}

inline
bool CSubmit_block_Base::IsSetReldate(void) const
{
    return m_Reldate.NotEmpty();
}

inline
bool CSubmit_block_Base::CanGetReldate(void) const
{
    return IsSetReldate();
}

inline
const CSubmit_block_Base::TReldate& CSubmit_block_Base::GetReldate(void) const
{
    if (!CanGetReldate()) {
        ThrowUnassigned(3);
    }
    return (*m_Reldate);
}

inline
bool CSubmit_block_Base::IsSetSubtype(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSubmit_block_Base::CanGetSubtype(void) const
{
    return IsSetSubtype();
}

inline
void CSubmit_block_Base::ResetSubtype(void)
{
    m_Subtype = (ESubtype)(0);
    m_set_State[0] &= ~0x300;
}

inline
CSubmit_block_Base::TSubtype CSubmit_block_Base::GetSubtype(void) const
{
    if (!CanGetSubtype()) {
        ThrowUnassigned(4);
    }
    return m_Subtype;
}

inline
void CSubmit_block_Base::SetSubtype(CSubmit_block_Base::TSubtype value)
{
    m_Subtype = value;
    m_set_State[0] |= 0x300;
}

inline
CSubmit_block_Base::TSubtype& CSubmit_block_Base::SetSubtype(void)
{
#ifdef _DEBUG
    if (!IsSetSubtype()) {
        memset(&m_Subtype,UnassignedByte(),sizeof(m_Subtype));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Subtype;
}

inline
bool CSubmit_block_Base::IsSetTool(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSubmit_block_Base::CanGetTool(void) const
{
    return IsSetTool();
}

inline
const CSubmit_block_Base::TTool& CSubmit_block_Base::GetTool(void) const
{
    if (!CanGetTool()) {
        ThrowUnassigned(5);
    }
    return m_Tool;
}

inline
void CSubmit_block_Base::SetTool(const CSubmit_block_Base::TTool& value)
{
    m_Tool = value;
    m_set_State[0] |= 0xc00;
}

inline
void CSubmit_block_Base::SetTool(CSubmit_block_Base::TTool&& value)
{
    m_Tool = std::forward<CSubmit_block_Base::TTool>(value);
    m_set_State[0] |= 0xc00;
}

inline
CSubmit_block_Base::TTool& CSubmit_block_Base::SetTool(void)
{
#ifdef _DEBUG
    if (!IsSetTool()) {
        m_Tool = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Tool;
}

inline
bool CSubmit_block_Base::IsSetUser_tag(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CSubmit_block_Base::CanGetUser_tag(void) const
{
    return IsSetUser_tag();
}

inline
const CSubmit_block_Base::TUser_tag& CSubmit_block_Base::GetUser_tag(void) const
{
    if (!CanGetUser_tag()) {
        ThrowUnassigned(6);
    }
    return m_User_tag;
}

inline
void CSubmit_block_Base::SetUser_tag(const CSubmit_block_Base::TUser_tag& value)
{
    m_User_tag = value;
    m_set_State[0] |= 0x3000;
}

inline
void CSubmit_block_Base::SetUser_tag(CSubmit_block_Base::TUser_tag&& value)
{
    m_User_tag = std::forward<CSubmit_block_Base::TUser_tag>(value);
    m_set_State[0] |= 0x3000;
}

inline
CSubmit_block_Base::TUser_tag& CSubmit_block_Base::SetUser_tag(void)
{
#ifdef _DEBUG
    if (!IsSetUser_tag()) {
        m_User_tag = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_User_tag;
}

inline
bool CSubmit_block_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CSubmit_block_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CSubmit_block_Base::TComment& CSubmit_block_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(7);
    }
    return m_Comment;
}

inline
void CSubmit_block_Base::SetComment(const CSubmit_block_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0xc000;
}

inline
void CSubmit_block_Base::SetComment(CSubmit_block_Base::TComment&& value)
{
    m_Comment = std::forward<CSubmit_block_Base::TComment>(value);
    m_set_State[0] |= 0xc000;
}

inline
CSubmit_block_Base::TComment& CSubmit_block_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Comment;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SUBMIT_SUBMIT_BLOCK_BASE_HPP
