/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_submit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'submit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SUBMIT_SEQ_SUBMIT_BASE_HPP
#define OBJECTS_SUBMIT_SEQ_SUBMIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_annot;
class CSeq_entry;
class CSeq_id;
class CSubmit_block;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// deletions of entries
class NCBI_SUBMIT_EXPORT CSeq_submit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_submit_Base(void);
    // destructor
    virtual ~CSeq_submit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_SUBMIT_EXPORT C_Data : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Data(void);
        // destructor
        ~C_Data(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Entrys,       ///< sequence(s)
            e_Annots,       ///< annotation(s)
            e_Delete
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 4 ///< == e_Delete+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef list< CRef< CSeq_entry > > TEntrys;
        typedef list< CRef< CSeq_annot > > TAnnots;
        typedef list< CRef< CSeq_id > > TDelete;
    
        // getters
        // setters
    
        // typedef list< CRef< CSeq_entry > > TEntrys
        bool IsEntrys(void) const;
        const TEntrys& GetEntrys(void) const;
        TEntrys& SetEntrys(void);
    
        // typedef list< CRef< CSeq_annot > > TAnnots
        bool IsAnnots(void) const;
        const TAnnots& GetAnnots(void) const;
        TAnnots& SetAnnots(void);
    
        // typedef list< CRef< CSeq_id > > TDelete
        bool IsDelete(void) const;
        const TDelete& GetDelete(void) const;
        TDelete& SetDelete(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Data(const C_Data& );
        C_Data& operator=(const C_Data& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TEntrys> m_Entrys;
            NCBI_NS_NCBI::CUnionBuffer<TAnnots> m_Annots;
            NCBI_NS_NCBI::CUnionBuffer<TDelete> m_Delete;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef CSubmit_block TSub;
    typedef C_Data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_sub,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSubmit_block TSub
    ///  Check whether the Sub data member has been assigned a value.
    bool IsSetSub(void) const;
    /// Check whether it is safe or not to call GetSub method.
    bool CanGetSub(void) const;
    void ResetSub(void);
    const TSub& GetSub(void) const;
    void SetSub(TSub& value);
    TSub& SetSub(void);

    /// mandatory
    /// typedef C_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_submit_Base(const CSeq_submit_Base&);
    CSeq_submit_Base& operator=(const CSeq_submit_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSub > m_Sub;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_submit_Base::C_Data::E_Choice CSeq_submit_Base::C_Data::Which(void) const
{
    return m_choice;
}

inline
void CSeq_submit_Base::C_Data::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_submit_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_submit_Base::C_Data::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_submit_Base::C_Data::IsEntrys(void) const
{
    return m_choice == e_Entrys;
}

inline
const CSeq_submit_Base::C_Data::TEntrys& CSeq_submit_Base::C_Data::GetEntrys(void) const
{
    CheckSelected(e_Entrys);
    return *m_Entrys;
}

inline
CSeq_submit_Base::C_Data::TEntrys& CSeq_submit_Base::C_Data::SetEntrys(void)
{
    Select(e_Entrys, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Entrys;
}

inline
bool CSeq_submit_Base::C_Data::IsAnnots(void) const
{
    return m_choice == e_Annots;
}

inline
const CSeq_submit_Base::C_Data::TAnnots& CSeq_submit_Base::C_Data::GetAnnots(void) const
{
    CheckSelected(e_Annots);
    return *m_Annots;
}

inline
CSeq_submit_Base::C_Data::TAnnots& CSeq_submit_Base::C_Data::SetAnnots(void)
{
    Select(e_Annots, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Annots;
}

inline
bool CSeq_submit_Base::C_Data::IsDelete(void) const
{
    return m_choice == e_Delete;
}

inline
const CSeq_submit_Base::C_Data::TDelete& CSeq_submit_Base::C_Data::GetDelete(void) const
{
    CheckSelected(e_Delete);
    return *m_Delete;
}

inline
CSeq_submit_Base::C_Data::TDelete& CSeq_submit_Base::C_Data::SetDelete(void)
{
    Select(e_Delete, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Delete;
}

inline
bool CSeq_submit_Base::IsSetSub(void) const
{
    return m_Sub.NotEmpty();
}

inline
bool CSeq_submit_Base::CanGetSub(void) const
{
    return true;
}

inline
const CSeq_submit_Base::TSub& CSeq_submit_Base::GetSub(void) const
{
    if ( !m_Sub ) {
        const_cast<CSeq_submit_Base*>(this)->ResetSub();
    }
    return (*m_Sub);
}

inline
CSeq_submit_Base::TSub& CSeq_submit_Base::SetSub(void)
{
    if ( !m_Sub ) {
        ResetSub();
    }
    return (*m_Sub);
}

inline
bool CSeq_submit_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CSeq_submit_Base::CanGetData(void) const
{
    return true;
}

inline
const CSeq_submit_Base::TData& CSeq_submit_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CSeq_submit_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CSeq_submit_Base::TData& CSeq_submit_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SUBMIT_SEQ_SUBMIT_BASE_HPP
