/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqTable_column_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqtable.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQTABLE_SEQTABLE_COLUMN_INFO_BASE_HPP
#define OBJECTS_SEQTABLE_SEQTABLE_COLUMN_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeqTable_column_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqTable_column_info_Base(void);
    // destructor
    virtual ~CSeqTable_column_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// identification of the column data in the objects described by the table
    /// known column data types
    /// position types
    enum EField_id {
        eField_id_location               =  0,  ///< location as Seq-loc
        eField_id_location_id            =  1,  ///< location Seq-id
        eField_id_location_gi            =  2,  ///< gi
        eField_id_location_from          =  3,  ///< interval from
        eField_id_location_to            =  4,  ///< interval to
        eField_id_location_strand        =  5,  ///< location strand
        eField_id_location_fuzz_from_lim =  6,
        eField_id_location_fuzz_to_lim   =  7,
        eField_id_product                = 10,  ///< product as Seq-loc
        eField_id_product_id             = 11,  ///< product Seq-id
        eField_id_product_gi             = 12,  ///< product gi
        eField_id_product_from           = 13,  ///< product interval from
        eField_id_product_to             = 14,  ///< product interval to
        eField_id_product_strand         = 15,  ///< product strand
        eField_id_product_fuzz_from_lim  = 16,
        eField_id_product_fuzz_to_lim    = 17,
        eField_id_id_local               = 20,  ///< main feature fields  id.local.id
        eField_id_xref_id_local          = 21,  ///< xref.id.local.id
        eField_id_partial                = 22,
        eField_id_comment                = 23,
        eField_id_title                  = 24,
        eField_id_ext                    = 25,  ///< field-name must be "E.xxx", see below
        eField_id_qual                   = 26,  ///< field-name must be "Q.xxx", see below
        eField_id_dbxref                 = 27,  ///< field-name must be "D.xxx", see below
        eField_id_data_imp_key           = 30,  ///< various data fields
        eField_id_data_region            = 31,
        eField_id_data_cdregion_frame    = 32,
        eField_id_ext_type               = 40,  ///< extra fields, see also special values for str below
        eField_id_qual_qual              = 41,
        eField_id_qual_val               = 42,
        eField_id_dbxref_db              = 43,
        eField_id_dbxref_tag             = 44
    };
    
    /// Access to EField_id's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EField_id)(void);
    
    // types
    typedef string TTitle;
    typedef int TField_id;
    typedef string TField_name;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_title,
        e_field_id,
        e_field_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// user friendly column name, can be skipped
    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// optional
    /// typedef int TField_id
    ///  Check whether the Field_id data member has been assigned a value.
    bool IsSetField_id(void) const;
    /// Check whether it is safe or not to call GetField_id method.
    bool CanGetField_id(void) const;
    void ResetField_id(void);
    TField_id GetField_id(void) const;
    void SetField_id(TField_id value);
    TField_id& SetField_id(void);

    /// any column can be identified by ASN.1 text locator string
    /// with omitted object type.
    /// examples:
    ///   "data.gene.locus" for Seq-feat.data.gene.locus
    ///   "data.imp.key" for Seq-feat.data.imp.key
    ///   "qual.qual"
    ///    - Seq-feat.qual is SEQUENCE so several columns are allowed
    ///      see also "Q.xxx" special value for shorter qual representation
    ///   "ext.type.str"
    ///   "ext.data.label.str"
    ///   "ext.data.data.int"
    ///      see also "E.xxx" special value for shorter ext representation
    /// special values start with capital letter:
    ///   "E.xxx" - ext.data.label.str = xxx, ext.data.data = data
    ///    - Seq-feat.ext.data is SEQUENCE so several columns are allowed
    ///   "Q.xxx" - qual.qual = xxx, qual.val = data
    ///    - Seq-feat.qual is SEQUENCE so several columns are allowed
    ///   "D.xxx" - dbxref.id = xxx, dbxref.tag = data
    ///    - Seq-feat.dbxref is SET so several columns are allowed
    /// optional
    /// typedef string TField_name
    ///  Check whether the Field_name data member has been assigned a value.
    bool IsSetField_name(void) const;
    /// Check whether it is safe or not to call GetField_name method.
    bool CanGetField_name(void) const;
    void ResetField_name(void);
    const TField_name& GetField_name(void) const;
    void SetField_name(const TField_name& value);
    void SetField_name(TField_name&& value);
    TField_name& SetField_name(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqTable_column_info_Base(const CSeqTable_column_info_Base&);
    CSeqTable_column_info_Base& operator=(const CSeqTable_column_info_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Title;
    int m_Field_id;
    string m_Field_name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqTable_column_info_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeqTable_column_info_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CSeqTable_column_info_Base::TTitle& CSeqTable_column_info_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(0);
    }
    return m_Title;
}

inline
void CSeqTable_column_info_Base::SetTitle(const CSeqTable_column_info_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x3;
}

inline
void CSeqTable_column_info_Base::SetTitle(CSeqTable_column_info_Base::TTitle&& value)
{
    m_Title = std::forward<CSeqTable_column_info_Base::TTitle>(value);
    m_set_State[0] |= 0x3;
}

inline
CSeqTable_column_info_Base::TTitle& CSeqTable_column_info_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Title;
}

inline
bool CSeqTable_column_info_Base::IsSetField_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeqTable_column_info_Base::CanGetField_id(void) const
{
    return IsSetField_id();
}

inline
void CSeqTable_column_info_Base::ResetField_id(void)
{
    m_Field_id = (EField_id)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSeqTable_column_info_Base::TField_id CSeqTable_column_info_Base::GetField_id(void) const
{
    if (!CanGetField_id()) {
        ThrowUnassigned(1);
    }
    return m_Field_id;
}

inline
void CSeqTable_column_info_Base::SetField_id(CSeqTable_column_info_Base::TField_id value)
{
    m_Field_id = value;
    m_set_State[0] |= 0xc;
}

inline
CSeqTable_column_info_Base::TField_id& CSeqTable_column_info_Base::SetField_id(void)
{
#ifdef _DEBUG
    if (!IsSetField_id()) {
        memset(&m_Field_id,UnassignedByte(),sizeof(m_Field_id));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Field_id;
}

inline
bool CSeqTable_column_info_Base::IsSetField_name(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeqTable_column_info_Base::CanGetField_name(void) const
{
    return IsSetField_name();
}

inline
const CSeqTable_column_info_Base::TField_name& CSeqTable_column_info_Base::GetField_name(void) const
{
    if (!CanGetField_name()) {
        ThrowUnassigned(2);
    }
    return m_Field_name;
}

inline
void CSeqTable_column_info_Base::SetField_name(const CSeqTable_column_info_Base::TField_name& value)
{
    m_Field_name = value;
    m_set_State[0] |= 0x30;
}

inline
void CSeqTable_column_info_Base::SetField_name(CSeqTable_column_info_Base::TField_name&& value)
{
    m_Field_name = std::forward<CSeqTable_column_info_Base::TField_name>(value);
    m_set_State[0] |= 0x30;
}

inline
CSeqTable_column_info_Base::TField_name& CSeqTable_column_info_Base::SetField_name(void)
{
#ifdef _DEBUG
    if (!IsSetField_name()) {
        m_Field_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Field_name;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQTABLE_SEQTABLE_COLUMN_INFO_BASE_HPP
