/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Seq_id_Ints_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_SEQ_ID_INTS_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_SEQ_ID_INTS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Interval;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Seq_id_Ints_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Seq_id_Ints_Base(void);
    // destructor
    virtual ~CID2S_Seq_id_Ints_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TSeq_id;
    typedef list< CRef< CID2S_Interval > > TInts;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seq_id,
        e_ints
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeq_id TSeq_id
    ///  Check whether the Seq_id data member has been assigned a value.
    bool IsSetSeq_id(void) const;
    /// Check whether it is safe or not to call GetSeq_id method.
    bool CanGetSeq_id(void) const;
    void ResetSeq_id(void);
    const TSeq_id& GetSeq_id(void) const;
    void SetSeq_id(TSeq_id& value);
    TSeq_id& SetSeq_id(void);

    /// mandatory
    /// typedef list< CRef< CID2S_Interval > > TInts
    ///  Check whether the Ints data member has been assigned a value.
    bool IsSetInts(void) const;
    /// Check whether it is safe or not to call GetInts method.
    bool CanGetInts(void) const;
    void ResetInts(void);
    const TInts& GetInts(void) const;
    TInts& SetInts(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Seq_id_Ints_Base(const CID2S_Seq_id_Ints_Base&);
    CID2S_Seq_id_Ints_Base& operator=(const CID2S_Seq_id_Ints_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSeq_id > m_Seq_id;
    list< CRef< CID2S_Interval > > m_Ints;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Seq_id_Ints_Base::IsSetSeq_id(void) const
{
    return m_Seq_id.NotEmpty();
}

inline
bool CID2S_Seq_id_Ints_Base::CanGetSeq_id(void) const
{
    return true;
}

inline
const CID2S_Seq_id_Ints_Base::TSeq_id& CID2S_Seq_id_Ints_Base::GetSeq_id(void) const
{
    if ( !m_Seq_id ) {
        const_cast<CID2S_Seq_id_Ints_Base*>(this)->ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
CID2S_Seq_id_Ints_Base::TSeq_id& CID2S_Seq_id_Ints_Base::SetSeq_id(void)
{
    if ( !m_Seq_id ) {
        ResetSeq_id();
    }
    return (*m_Seq_id);
}

inline
bool CID2S_Seq_id_Ints_Base::IsSetInts(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Seq_id_Ints_Base::CanGetInts(void) const
{
    return true;
}

inline
const CID2S_Seq_id_Ints_Base::TInts& CID2S_Seq_id_Ints_Base::GetInts(void) const
{
    return m_Ints;
}

inline
CID2S_Seq_id_Ints_Base::TInts& CID2S_Seq_id_Ints_Base::SetInts(void)
{
    m_set_State[0] |= 0x4;
    return m_Ints;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_SEQ_ID_INTS_BASE_HPP
