/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Feat_type_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_FEAT_TYPE_INFO_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_FEAT_TYPE_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Feat_type_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Feat_type_Info_Base(void);
    // destructor
    virtual ~CID2S_Feat_type_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TType;
    typedef list< int > TSubtypes;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_subtypes
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef list< int > TSubtypes
    ///  Check whether the Subtypes data member has been assigned a value.
    bool IsSetSubtypes(void) const;
    /// Check whether it is safe or not to call GetSubtypes method.
    bool CanGetSubtypes(void) const;
    void ResetSubtypes(void);
    const TSubtypes& GetSubtypes(void) const;
    TSubtypes& SetSubtypes(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Feat_type_Info_Base(const CID2S_Feat_type_Info_Base&);
    CID2S_Feat_type_Info_Base& operator=(const CID2S_Feat_type_Info_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    list< int > m_Subtypes;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Feat_type_Info_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2S_Feat_type_Info_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CID2S_Feat_type_Info_Base::ResetType(void)
{
    m_Type = 0;
    m_set_State[0] &= ~0x3;
}

inline
CID2S_Feat_type_Info_Base::TType CID2S_Feat_type_Info_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CID2S_Feat_type_Info_Base::SetType(CID2S_Feat_type_Info_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CID2S_Feat_type_Info_Base::TType& CID2S_Feat_type_Info_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CID2S_Feat_type_Info_Base::IsSetSubtypes(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Feat_type_Info_Base::CanGetSubtypes(void) const
{
    return true;
}

inline
const CID2S_Feat_type_Info_Base::TSubtypes& CID2S_Feat_type_Info_Base::GetSubtypes(void) const
{
    return m_Subtypes;
}

inline
CID2S_Feat_type_Info_Base::TSubtypes& CID2S_Feat_type_Info_Base::SetSubtypes(void)
{
    m_set_State[0] |= 0x4;
    return m_Subtypes;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_FEAT_TYPE_INFO_BASE_HPP
