/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Chunk_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_CHUNK_INFO_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_CHUNK_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/seqsplit/ID2S_Chunk_Id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Chunk_Content;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Chunk_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Chunk_Info_Base(void);
    // destructor
    virtual ~CID2S_Chunk_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID2S_Chunk_Id TId;
    typedef list< CRef< CID2S_Chunk_Content > > TContent;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_content
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID2S_Chunk_Id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    TId& SetId(void);

    /// mandatory
    /// typedef list< CRef< CID2S_Chunk_Content > > TContent
    ///  Check whether the Content data member has been assigned a value.
    bool IsSetContent(void) const;
    /// Check whether it is safe or not to call GetContent method.
    bool CanGetContent(void) const;
    void ResetContent(void);
    const TContent& GetContent(void) const;
    TContent& SetContent(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Chunk_Info_Base(const CID2S_Chunk_Info_Base&);
    CID2S_Chunk_Info_Base& operator=(const CID2S_Chunk_Info_Base&);

    // data
    Uint4 m_set_State[1];
    CID2S_Chunk_Id m_Id;
    list< CRef< CID2S_Chunk_Content > > m_Content;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Chunk_Info_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2S_Chunk_Info_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CID2S_Chunk_Info_Base::ResetId(void)
{
    m_Id = CID2S_Chunk_Id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CID2S_Chunk_Info_Base::TId& CID2S_Chunk_Info_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CID2S_Chunk_Info_Base::SetId(const CID2S_Chunk_Info_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CID2S_Chunk_Info_Base::TId& CID2S_Chunk_Info_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CID2S_Chunk_Info_Base::IsSetContent(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Chunk_Info_Base::CanGetContent(void) const
{
    return true;
}

inline
const CID2S_Chunk_Info_Base::TContent& CID2S_Chunk_Info_Base::GetContent(void) const
{
    return m_Content;
}

inline
CID2S_Chunk_Info_Base::TContent& CID2S_Chunk_Info_Base::SetContent(void)
{
    m_set_State[0] |= 0x4;
    return m_Content;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_CHUNK_INFO_BASE_HPP
