/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Bioseqs_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_BIOSEQS_INFO_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_BIOSEQS_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2S_Bioseq_Ids;
class CID2S_Bioseq_Info;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Bioseqs_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Bioseqs_Info_Base(void);
    // destructor
    virtual ~CID2S_Bioseqs_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID2S_Bioseq_Info TInfo;
    typedef CID2S_Bioseq_Ids TBioseqs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_info,
        e_bioseqs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID2S_Bioseq_Info TInfo
    ///  Check whether the Info data member has been assigned a value.
    bool IsSetInfo(void) const;
    /// Check whether it is safe or not to call GetInfo method.
    bool CanGetInfo(void) const;
    void ResetInfo(void);
    const TInfo& GetInfo(void) const;
    void SetInfo(TInfo& value);
    TInfo& SetInfo(void);

    /// mandatory
    /// typedef CID2S_Bioseq_Ids TBioseqs
    ///  Check whether the Bioseqs data member has been assigned a value.
    bool IsSetBioseqs(void) const;
    /// Check whether it is safe or not to call GetBioseqs method.
    bool CanGetBioseqs(void) const;
    void ResetBioseqs(void);
    const TBioseqs& GetBioseqs(void) const;
    void SetBioseqs(TBioseqs& value);
    TBioseqs& SetBioseqs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Bioseqs_Info_Base(const CID2S_Bioseqs_Info_Base&);
    CID2S_Bioseqs_Info_Base& operator=(const CID2S_Bioseqs_Info_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TInfo > m_Info;
    CRef< TBioseqs > m_Bioseqs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Bioseqs_Info_Base::IsSetInfo(void) const
{
    return m_Info.NotEmpty();
}

inline
bool CID2S_Bioseqs_Info_Base::CanGetInfo(void) const
{
    return true;
}

inline
const CID2S_Bioseqs_Info_Base::TInfo& CID2S_Bioseqs_Info_Base::GetInfo(void) const
{
    if ( !m_Info ) {
        const_cast<CID2S_Bioseqs_Info_Base*>(this)->ResetInfo();
    }
    return (*m_Info);
}

inline
CID2S_Bioseqs_Info_Base::TInfo& CID2S_Bioseqs_Info_Base::SetInfo(void)
{
    if ( !m_Info ) {
        ResetInfo();
    }
    return (*m_Info);
}

inline
bool CID2S_Bioseqs_Info_Base::IsSetBioseqs(void) const
{
    return m_Bioseqs.NotEmpty();
}

inline
bool CID2S_Bioseqs_Info_Base::CanGetBioseqs(void) const
{
    return true;
}

inline
const CID2S_Bioseqs_Info_Base::TBioseqs& CID2S_Bioseqs_Info_Base::GetBioseqs(void) const
{
    if ( !m_Bioseqs ) {
        const_cast<CID2S_Bioseqs_Info_Base*>(this)->ResetBioseqs();
    }
    return (*m_Bioseqs);
}

inline
CID2S_Bioseqs_Info_Base::TBioseqs& CID2S_Bioseqs_Info_Base::SetBioseqs(void)
{
    if ( !m_Bioseqs ) {
        ResetBioseqs();
    }
    return (*m_Bioseqs);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_BIOSEQS_INFO_BASE_HPP
