/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Bioseq_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqsplit.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQSPLIT_ID2S_BIOSEQ_INFO_BASE_HPP
#define OBJECTS_SEQSPLIT_ID2S_BIOSEQ_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2S_Bioseq_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Bioseq_Info_Base(void);
    // destructor
    virtual ~CID2S_Bioseq_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TGap_count;
    typedef bool TSeq_map_has_ref;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_gap_count,
        e_seq_map_has_ref
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TGap_count
    ///  Check whether the Gap_count data member has been assigned a value.
    bool IsSetGap_count(void) const;
    /// Check whether it is safe or not to call GetGap_count method.
    bool CanGetGap_count(void) const;
    void ResetGap_count(void);
    TGap_count GetGap_count(void) const;
    void SetGap_count(TGap_count value);
    TGap_count& SetGap_count(void);

    /// optional
    /// typedef bool TSeq_map_has_ref
    ///  Check whether the Seq_map_has_ref data member has been assigned a value.
    bool IsSetSeq_map_has_ref(void) const;
    /// Check whether it is safe or not to call GetSeq_map_has_ref method.
    bool CanGetSeq_map_has_ref(void) const;
    void ResetSeq_map_has_ref(void);
    TSeq_map_has_ref GetSeq_map_has_ref(void) const;
    void SetSeq_map_has_ref(TSeq_map_has_ref value);
    TSeq_map_has_ref& SetSeq_map_has_ref(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Bioseq_Info_Base(const CID2S_Bioseq_Info_Base&);
    CID2S_Bioseq_Info_Base& operator=(const CID2S_Bioseq_Info_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Gap_count;
    bool m_Seq_map_has_ref;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Bioseq_Info_Base::IsSetGap_count(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2S_Bioseq_Info_Base::CanGetGap_count(void) const
{
    return IsSetGap_count();
}

inline
void CID2S_Bioseq_Info_Base::ResetGap_count(void)
{
    m_Gap_count = 0;
    m_set_State[0] &= ~0x3;
}

inline
CID2S_Bioseq_Info_Base::TGap_count CID2S_Bioseq_Info_Base::GetGap_count(void) const
{
    if (!CanGetGap_count()) {
        ThrowUnassigned(0);
    }
    return m_Gap_count;
}

inline
void CID2S_Bioseq_Info_Base::SetGap_count(CID2S_Bioseq_Info_Base::TGap_count value)
{
    m_Gap_count = value;
    m_set_State[0] |= 0x3;
}

inline
CID2S_Bioseq_Info_Base::TGap_count& CID2S_Bioseq_Info_Base::SetGap_count(void)
{
#ifdef _DEBUG
    if (!IsSetGap_count()) {
        memset(&m_Gap_count,UnassignedByte(),sizeof(m_Gap_count));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Gap_count;
}

inline
bool CID2S_Bioseq_Info_Base::IsSetSeq_map_has_ref(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Bioseq_Info_Base::CanGetSeq_map_has_ref(void) const
{
    return IsSetSeq_map_has_ref();
}

inline
void CID2S_Bioseq_Info_Base::ResetSeq_map_has_ref(void)
{
    m_Seq_map_has_ref = 0;
    m_set_State[0] &= ~0xc;
}

inline
CID2S_Bioseq_Info_Base::TSeq_map_has_ref CID2S_Bioseq_Info_Base::GetSeq_map_has_ref(void) const
{
    if (!CanGetSeq_map_has_ref()) {
        ThrowUnassigned(1);
    }
    return m_Seq_map_has_ref;
}

inline
void CID2S_Bioseq_Info_Base::SetSeq_map_has_ref(CID2S_Bioseq_Info_Base::TSeq_map_has_ref value)
{
    m_Seq_map_has_ref = value;
    m_set_State[0] |= 0xc;
}

inline
CID2S_Bioseq_Info_Base::TSeq_map_has_ref& CID2S_Bioseq_Info_Base::SetSeq_map_has_ref(void)
{
#ifdef _DEBUG
    if (!IsSetSeq_map_has_ref()) {
        memset(&m_Seq_map_has_ref,UnassignedByte(),sizeof(m_Seq_map_has_ref));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Seq_map_has_ref;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQSPLIT_ID2S_BIOSEQ_INFO_BASE_HPP
