/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_SEQ_ID_BASE_HPP
#define OBJECTS_SEQLOC_SEQ_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CGiimport_id;
class CObject_id;
class CPDB_seq_id;
class CPatent_seq_id;
class CTextseq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Sequence identifiers ********************************
///*
class NCBI_SEQLOC_EXPORT CSeq_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_id_Base(void);
    // destructor
    virtual ~CSeq_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,        ///< No variant selected
        e_Local,              ///< local use
        e_Gibbsq,             ///< Geninfo backbone seqid
        e_Gibbmt,             ///< Geninfo backbone moltype
        e_Giim,               ///< Geninfo import id
        e_Genbank,
        e_Embl,
        e_Pir,
        e_Swissprot,
        e_Patent,
        e_Other,              ///< for historical reasons, 'other' = 'refseq'
        e_General,            ///< for other databases
        e_Gi,                 ///< GenInfo Integrated Database
        e_Ddbj,               ///< DDBJ
        e_Prf,                ///< PRF SEQDB
        e_Pdb,                ///< PDB sequence
        e_Tpg,                ///< Third Party Annot/Seq Genbank
        e_Tpe,                ///< Third Party Annot/Seq EMBL
        e_Tpd,                ///< Third Party Annot/Seq DDBJ
        e_Gpipe,              ///< Internal NCBI genome pipeline processing ID
        e_Named_annot_track   ///< Internal named annotation tracking ID
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 21 ///< == e_Named_annot_track+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CObject_id TLocal;
    typedef int TGibbsq;
    typedef int TGibbmt;
    typedef CGiimport_id TGiim;
    typedef CTextseq_id TGenbank;
    typedef CTextseq_id TEmbl;
    typedef CTextseq_id TPir;
    typedef CTextseq_id TSwissprot;
    typedef CPatent_seq_id TPatent;
    typedef CTextseq_id TOther;
    typedef CDbtag TGeneral;
    typedef NCBI_NS_NCBI::TGi TGi;
    typedef CTextseq_id TDdbj;
    typedef CTextseq_id TPrf;
    typedef CPDB_seq_id TPdb;
    typedef CTextseq_id TTpg;
    typedef CTextseq_id TTpe;
    typedef CTextseq_id TTpd;
    typedef CTextseq_id TGpipe;
    typedef CTextseq_id TNamed_annot_track;

    // getters
    // setters

    // typedef CObject_id TLocal
    bool IsLocal(void) const;
    const TLocal& GetLocal(void) const;
    TLocal& SetLocal(void);
    void SetLocal(TLocal& value);

    // typedef int TGibbsq
    bool IsGibbsq(void) const;
    TGibbsq GetGibbsq(void) const;
    TGibbsq& SetGibbsq(void);
    void SetGibbsq(TGibbsq value);

    // typedef int TGibbmt
    bool IsGibbmt(void) const;
    TGibbmt GetGibbmt(void) const;
    TGibbmt& SetGibbmt(void);
    void SetGibbmt(TGibbmt value);

    // typedef CGiimport_id TGiim
    bool IsGiim(void) const;
    const TGiim& GetGiim(void) const;
    TGiim& SetGiim(void);
    void SetGiim(TGiim& value);

    // typedef CTextseq_id TGenbank
    bool IsGenbank(void) const;
    const TGenbank& GetGenbank(void) const;
    TGenbank& SetGenbank(void);
    void SetGenbank(TGenbank& value);

    // typedef CTextseq_id TEmbl
    bool IsEmbl(void) const;
    const TEmbl& GetEmbl(void) const;
    TEmbl& SetEmbl(void);
    void SetEmbl(TEmbl& value);

    // typedef CTextseq_id TPir
    bool IsPir(void) const;
    const TPir& GetPir(void) const;
    TPir& SetPir(void);
    void SetPir(TPir& value);

    // typedef CTextseq_id TSwissprot
    bool IsSwissprot(void) const;
    const TSwissprot& GetSwissprot(void) const;
    TSwissprot& SetSwissprot(void);
    void SetSwissprot(TSwissprot& value);

    // typedef CPatent_seq_id TPatent
    bool IsPatent(void) const;
    const TPatent& GetPatent(void) const;
    TPatent& SetPatent(void);
    void SetPatent(TPatent& value);

    // typedef CTextseq_id TOther
    bool IsOther(void) const;
    const TOther& GetOther(void) const;
    TOther& SetOther(void);
    void SetOther(TOther& value);

    // typedef CDbtag TGeneral
    bool IsGeneral(void) const;
    const TGeneral& GetGeneral(void) const;
    TGeneral& SetGeneral(void);
    void SetGeneral(TGeneral& value);

    // typedef NCBI_NS_NCBI::TGi TGi
    bool IsGi(void) const;
    TGi GetGi(void) const;
    TGi& SetGi(void);
    void SetGi(TGi value);

    // typedef CTextseq_id TDdbj
    bool IsDdbj(void) const;
    const TDdbj& GetDdbj(void) const;
    TDdbj& SetDdbj(void);
    void SetDdbj(TDdbj& value);

    // typedef CTextseq_id TPrf
    bool IsPrf(void) const;
    const TPrf& GetPrf(void) const;
    TPrf& SetPrf(void);
    void SetPrf(TPrf& value);

    // typedef CPDB_seq_id TPdb
    bool IsPdb(void) const;
    const TPdb& GetPdb(void) const;
    TPdb& SetPdb(void);
    void SetPdb(TPdb& value);

    // typedef CTextseq_id TTpg
    bool IsTpg(void) const;
    const TTpg& GetTpg(void) const;
    TTpg& SetTpg(void);
    void SetTpg(TTpg& value);

    // typedef CTextseq_id TTpe
    bool IsTpe(void) const;
    const TTpe& GetTpe(void) const;
    TTpe& SetTpe(void);
    void SetTpe(TTpe& value);

    // typedef CTextseq_id TTpd
    bool IsTpd(void) const;
    const TTpd& GetTpd(void) const;
    TTpd& SetTpd(void);
    void SetTpd(TTpd& value);

    // typedef CTextseq_id TGpipe
    bool IsGpipe(void) const;
    const TGpipe& GetGpipe(void) const;
    TGpipe& SetGpipe(void);
    void SetGpipe(TGpipe& value);

    // typedef CTextseq_id TNamed_annot_track
    bool IsNamed_annot_track(void) const;
    const TNamed_annot_track& GetNamed_annot_track(void) const;
    TNamed_annot_track& SetNamed_annot_track(void);
    void SetNamed_annot_track(TNamed_annot_track& value);


private:
    // copy constructor and assignment operator
    CSeq_id_Base(const CSeq_id_Base& );
    CSeq_id_Base& operator=(const CSeq_id_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TGibbsq m_Gibbsq;
        TGibbmt m_Gibbmt;
        ncbi::TIntId m_Gi;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSeq_id_Base::E_Choice CSeq_id_Base::Which(void) const
{
    return m_choice;
}

inline
void CSeq_id_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSeq_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSeq_id_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSeq_id_Base::IsLocal(void) const
{
    return m_choice == e_Local;
}

inline
bool CSeq_id_Base::IsGibbsq(void) const
{
    return m_choice == e_Gibbsq;
}

inline
CSeq_id_Base::TGibbsq CSeq_id_Base::GetGibbsq(void) const
{
    CheckSelected(e_Gibbsq);
    return m_Gibbsq;
}

inline
CSeq_id_Base::TGibbsq& CSeq_id_Base::SetGibbsq(void)
{
    Select(e_Gibbsq, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Gibbsq;
}

inline
void CSeq_id_Base::SetGibbsq(CSeq_id_Base::TGibbsq value)
{
    Select(e_Gibbsq, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Gibbsq = value;
}

inline
bool CSeq_id_Base::IsGibbmt(void) const
{
    return m_choice == e_Gibbmt;
}

inline
CSeq_id_Base::TGibbmt CSeq_id_Base::GetGibbmt(void) const
{
    CheckSelected(e_Gibbmt);
    return m_Gibbmt;
}

inline
CSeq_id_Base::TGibbmt& CSeq_id_Base::SetGibbmt(void)
{
    Select(e_Gibbmt, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Gibbmt;
}

inline
void CSeq_id_Base::SetGibbmt(CSeq_id_Base::TGibbmt value)
{
    Select(e_Gibbmt, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Gibbmt = value;
}

inline
bool CSeq_id_Base::IsGiim(void) const
{
    return m_choice == e_Giim;
}

inline
bool CSeq_id_Base::IsGenbank(void) const
{
    return m_choice == e_Genbank;
}

inline
bool CSeq_id_Base::IsEmbl(void) const
{
    return m_choice == e_Embl;
}

inline
bool CSeq_id_Base::IsPir(void) const
{
    return m_choice == e_Pir;
}

inline
bool CSeq_id_Base::IsSwissprot(void) const
{
    return m_choice == e_Swissprot;
}

inline
bool CSeq_id_Base::IsPatent(void) const
{
    return m_choice == e_Patent;
}

inline
bool CSeq_id_Base::IsOther(void) const
{
    return m_choice == e_Other;
}

inline
bool CSeq_id_Base::IsGeneral(void) const
{
    return m_choice == e_General;
}

inline
bool CSeq_id_Base::IsGi(void) const
{
    return m_choice == e_Gi;
}

inline
CSeq_id_Base::TGi CSeq_id_Base::GetGi(void) const
{
    CheckSelected(e_Gi);
    return reinterpret_cast<const TGi&>(m_Gi);
}

inline
CSeq_id_Base::TGi& CSeq_id_Base::SetGi(void)
{
    Select(e_Gi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGi&>(m_Gi);
}

inline
void CSeq_id_Base::SetGi(CSeq_id_Base::TGi value)
{
    Select(e_Gi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGi&>(m_Gi) = value;
}

inline
bool CSeq_id_Base::IsDdbj(void) const
{
    return m_choice == e_Ddbj;
}

inline
bool CSeq_id_Base::IsPrf(void) const
{
    return m_choice == e_Prf;
}

inline
bool CSeq_id_Base::IsPdb(void) const
{
    return m_choice == e_Pdb;
}

inline
bool CSeq_id_Base::IsTpg(void) const
{
    return m_choice == e_Tpg;
}

inline
bool CSeq_id_Base::IsTpe(void) const
{
    return m_choice == e_Tpe;
}

inline
bool CSeq_id_Base::IsTpd(void) const
{
    return m_choice == e_Tpd;
}

inline
bool CSeq_id_Base::IsGpipe(void) const
{
    return m_choice == e_Gpipe;
}

inline
bool CSeq_id_Base::IsNamed_annot_track(void) const
{
    return m_choice == e_Named_annot_track;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_SEQ_ID_BASE_HPP
