/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Patent_seq_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQLOC_PATENT_SEQ_ID_BASE_HPP
#define OBJECTS_SEQLOC_PATENT_SEQ_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CId_pat;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQLOC_EXPORT CPatent_seq_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPatent_seq_id_Base(void);
    // destructor
    virtual ~CPatent_seq_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TSeqid;
    typedef CId_pat TCit;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_seqid,
        e_cit
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// number of sequence in patent
    /// mandatory
    /// typedef int TSeqid
    ///  Check whether the Seqid data member has been assigned a value.
    bool IsSetSeqid(void) const;
    /// Check whether it is safe or not to call GetSeqid method.
    bool CanGetSeqid(void) const;
    void ResetSeqid(void);
    TSeqid GetSeqid(void) const;
    void SetSeqid(TSeqid value);
    TSeqid& SetSeqid(void);

    /// patent citation
    /// mandatory
    /// typedef CId_pat TCit
    ///  Check whether the Cit data member has been assigned a value.
    bool IsSetCit(void) const;
    /// Check whether it is safe or not to call GetCit method.
    bool CanGetCit(void) const;
    void ResetCit(void);
    const TCit& GetCit(void) const;
    void SetCit(TCit& value);
    TCit& SetCit(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPatent_seq_id_Base(const CPatent_seq_id_Base&);
    CPatent_seq_id_Base& operator=(const CPatent_seq_id_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Seqid;
    CRef< TCit > m_Cit;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPatent_seq_id_Base::IsSetSeqid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPatent_seq_id_Base::CanGetSeqid(void) const
{
    return IsSetSeqid();
}

inline
void CPatent_seq_id_Base::ResetSeqid(void)
{
    m_Seqid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPatent_seq_id_Base::TSeqid CPatent_seq_id_Base::GetSeqid(void) const
{
    if (!CanGetSeqid()) {
        ThrowUnassigned(0);
    }
    return m_Seqid;
}

inline
void CPatent_seq_id_Base::SetSeqid(CPatent_seq_id_Base::TSeqid value)
{
    m_Seqid = value;
    m_set_State[0] |= 0x3;
}

inline
CPatent_seq_id_Base::TSeqid& CPatent_seq_id_Base::SetSeqid(void)
{
#ifdef _DEBUG
    if (!IsSetSeqid()) {
        memset(&m_Seqid,UnassignedByte(),sizeof(m_Seqid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Seqid;
}

inline
bool CPatent_seq_id_Base::IsSetCit(void) const
{
    return m_Cit.NotEmpty();
}

inline
bool CPatent_seq_id_Base::CanGetCit(void) const
{
    return true;
}

inline
const CPatent_seq_id_Base::TCit& CPatent_seq_id_Base::GetCit(void) const
{
    if ( !m_Cit ) {
        const_cast<CPatent_seq_id_Base*>(this)->ResetCit();
    }
    return (*m_Cit);
}

inline
CPatent_seq_id_Base::TCit& CPatent_seq_id_Base::SetCit(void)
{
    if ( !m_Cit ) {
        ResetCit();
    }
    return (*m_Cit);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQLOC_PATENT_SEQ_ID_BASE_HPP
