/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Variation_inst_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_VARIATION_INST_BASE_HPP
#define OBJECTS_SEQFEAT_VARIATION_INST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDelta_item;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Variation instance
class NCBI_SEQFEAT_EXPORT CVariation_inst_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CVariation_inst_Base(void);
    // destructor
    virtual ~CVariation_inst_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_unknown         =   0,  ///< delta=[]
        eType_identity        =   1,  ///< delta=[]
        eType_inv             =   2,  ///< delta=[del, ins.seq=  RevComp(variation-location)]
        eType_snv             =   3,  ///< delta=[morph of length 1]  NOTE: this is snV not snP; the latter  requires frequency-based validation to be  established in VariantProperties  the strict definition of SNP is an SNV with  an established population frequency of at  least 1% in at least 1 popuplation
        eType_mnp             =   4,  ///< delta=[morph of length >1]
        eType_delins          =   5,  ///< delta=[del, ins]
        eType_del             =   6,  ///< delta=[del]
        eType_ins             =   7,  ///< delta=[ins]
        eType_microsatellite  =   8,  ///< delta=[del, ins.seq= repeat-unit with fuzzy  multiplier]  variation-location is the microsat expansion  on the sequence
        eType_transposon      =   9,  ///< delta=[del, ins.seq= known donor or 'this']  variation-location is equiv of transposon  locs.
        eType_cnv             =  10,  ///< delta=[del, ins= 'this' with fuzzy  multiplier]
        eType_direct_copy     =  11,  ///< delta=[ins.seq= upstream location on the  same strand]
        eType_rev_direct_copy =  12,  ///< delta=[ins.seq= downstream location on the  same strand]
        eType_inverted_copy   =  13,  ///< delta=[ins.seq= upstream location on the  opposite strand]
        eType_everted_copy    =  14,  ///< delta=[ins.seq= downstream location on the  opposite strand]
        eType_translocation   =  15,  ///< delta=like delins
        eType_prot_missense   =  16,  ///< delta=[morph of length 1]
        eType_prot_nonsense   =  17,  ///< delta=[del]; variation-location is the tail  of the protein being truncated
        eType_prot_neutral    =  18,  ///< delta=[morph of length 1]
        eType_prot_silent     =  19,  ///< delta=[morph of length 1, same AA as at  variation-location]
        eType_prot_other      =  20,  ///< delta=any
        eType_other           = 255  ///< delta=any
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    /// 'observation' is used to label items in a Variation-ref package
    /// This field is explicitly a bit-field, so the bitwise OR (= sum) of any
    /// of the values may be observed.
    enum EObservation {
        eObservation_asserted  = 1,  ///< inst represents the asserted base at a  position
        eObservation_reference = 2,  ///< inst represents the reference base at the  position
        eObservation_variant   = 4  ///< inst represent the observed variant at a  given position
    };
    
    /// Access to EObservation's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EObservation)(void);
    
    // types
    typedef int TType;
    typedef list< CRef< CDelta_item > > TDelta;
    typedef int TObservation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_delta,
        e_observation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// Sequence that replaces the location, in biological order.
    /// mandatory
    /// typedef list< CRef< CDelta_item > > TDelta
    ///  Check whether the Delta data member has been assigned a value.
    bool IsSetDelta(void) const;
    /// Check whether it is safe or not to call GetDelta method.
    bool CanGetDelta(void) const;
    void ResetDelta(void);
    const TDelta& GetDelta(void) const;
    TDelta& SetDelta(void);

    /// optional
    /// typedef int TObservation
    ///  Check whether the Observation data member has been assigned a value.
    bool IsSetObservation(void) const;
    /// Check whether it is safe or not to call GetObservation method.
    bool CanGetObservation(void) const;
    void ResetObservation(void);
    TObservation GetObservation(void) const;
    void SetObservation(TObservation value);
    TObservation& SetObservation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CVariation_inst_Base(const CVariation_inst_Base&);
    CVariation_inst_Base& operator=(const CVariation_inst_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    list< CRef< CDelta_item > > m_Delta;
    int m_Observation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CVariation_inst_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CVariation_inst_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CVariation_inst_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CVariation_inst_Base::TType CVariation_inst_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CVariation_inst_Base::SetType(CVariation_inst_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CVariation_inst_Base::TType& CVariation_inst_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CVariation_inst_Base::IsSetDelta(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CVariation_inst_Base::CanGetDelta(void) const
{
    return true;
}

inline
const CVariation_inst_Base::TDelta& CVariation_inst_Base::GetDelta(void) const
{
    return m_Delta;
}

inline
CVariation_inst_Base::TDelta& CVariation_inst_Base::SetDelta(void)
{
    m_set_State[0] |= 0x4;
    return m_Delta;
}

inline
bool CVariation_inst_Base::IsSetObservation(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CVariation_inst_Base::CanGetObservation(void) const
{
    return IsSetObservation();
}

inline
void CVariation_inst_Base::ResetObservation(void)
{
    m_Observation = (EObservation)(0);
    m_set_State[0] &= ~0x30;
}

inline
CVariation_inst_Base::TObservation CVariation_inst_Base::GetObservation(void) const
{
    if (!CanGetObservation()) {
        ThrowUnassigned(2);
    }
    return m_Observation;
}

inline
void CVariation_inst_Base::SetObservation(CVariation_inst_Base::TObservation value)
{
    m_Observation = value;
    m_set_State[0] |= 0x30;
}

inline
CVariation_inst_Base::TObservation& CVariation_inst_Base::SetObservation(void)
{
#ifdef _DEBUG
    if (!IsSetObservation()) {
        memset(&m_Observation,UnassignedByte(),sizeof(m_Observation));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Observation;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_VARIATION_INST_BASE_HPP
