/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file SeqFeatXref_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_SEQFEATXREF_BASE_HPP
#define OBJECTS_SEQFEAT_SEQFEATXREF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CFeat_id;
class CSeqFeatData;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// both optional because can have one or both
class NCBI_SEQFEAT_EXPORT CSeqFeatXref_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeqFeatXref_Base(void);
    // destructor
    virtual ~CSeqFeatXref_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CFeat_id TId;
    typedef CSeqFeatData TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// the feature copied
    /// optional
    /// typedef CFeat_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// the specific data
    /// optional
    /// typedef CSeqFeatData TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeqFeatXref_Base(const CSeqFeatXref_Base&);
    CSeqFeatXref_Base& operator=(const CSeqFeatXref_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeqFeatXref_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CSeqFeatXref_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CSeqFeatXref_Base::TId& CSeqFeatXref_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return (*m_Id);
}

inline
bool CSeqFeatXref_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CSeqFeatXref_Base::CanGetData(void) const
{
    return IsSetData();
}

inline
const CSeqFeatXref_Base::TData& CSeqFeatXref_Base::GetData(void) const
{
    if (!CanGetData()) {
        ThrowUnassigned(1);
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_SEQFEATXREF_BASE_HPP
