/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ModelEvidenceItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQFEAT_MODELEVIDENCEITEM_BASE_HPP
#define OBJECTS_SEQFEAT_MODELEVIDENCEITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CModelEvidenceItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CModelEvidenceItem_Base(void);
    // destructor
    virtual ~CModelEvidenceItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_id TId;
    typedef int TExon_count;
    typedef int TExon_length;
    typedef bool TFull_length;
    typedef bool TSupports_all_exon_combo;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_exon_count,
        e_exon_length,
        e_full_length,
        e_supports_all_exon_combo
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeq_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// optional
    /// typedef int TExon_count
    ///  Check whether the Exon_count data member has been assigned a value.
    bool IsSetExon_count(void) const;
    /// Check whether it is safe or not to call GetExon_count method.
    bool CanGetExon_count(void) const;
    void ResetExon_count(void);
    TExon_count GetExon_count(void) const;
    void SetExon_count(TExon_count value);
    TExon_count& SetExon_count(void);

    /// optional
    /// typedef int TExon_length
    ///  Check whether the Exon_length data member has been assigned a value.
    bool IsSetExon_length(void) const;
    /// Check whether it is safe or not to call GetExon_length method.
    bool CanGetExon_length(void) const;
    void ResetExon_length(void);
    TExon_length GetExon_length(void) const;
    void SetExon_length(TExon_length value);
    TExon_length& SetExon_length(void);

    /// optional with default false
    /// typedef bool TFull_length
    ///  Check whether the Full_length data member has been assigned a value.
    bool IsSetFull_length(void) const;
    /// Check whether it is safe or not to call GetFull_length method.
    bool CanGetFull_length(void) const;
    void ResetFull_length(void);
    void SetDefaultFull_length(void);
    TFull_length GetFull_length(void) const;
    void SetFull_length(TFull_length value);
    TFull_length& SetFull_length(void);

    /// optional with default false
    /// typedef bool TSupports_all_exon_combo
    ///  Check whether the Supports_all_exon_combo data member has been assigned a value.
    bool IsSetSupports_all_exon_combo(void) const;
    /// Check whether it is safe or not to call GetSupports_all_exon_combo method.
    bool CanGetSupports_all_exon_combo(void) const;
    void ResetSupports_all_exon_combo(void);
    void SetDefaultSupports_all_exon_combo(void);
    TSupports_all_exon_combo GetSupports_all_exon_combo(void) const;
    void SetSupports_all_exon_combo(TSupports_all_exon_combo value);
    TSupports_all_exon_combo& SetSupports_all_exon_combo(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CModelEvidenceItem_Base(const CModelEvidenceItem_Base&);
    CModelEvidenceItem_Base& operator=(const CModelEvidenceItem_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TId > m_Id;
    int m_Exon_count;
    int m_Exon_length;
    bool m_Full_length;
    bool m_Supports_all_exon_combo;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CModelEvidenceItem_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CModelEvidenceItem_Base::CanGetId(void) const
{
    return true;
}

inline
const CModelEvidenceItem_Base::TId& CModelEvidenceItem_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CModelEvidenceItem_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CModelEvidenceItem_Base::TId& CModelEvidenceItem_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CModelEvidenceItem_Base::IsSetExon_count(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CModelEvidenceItem_Base::CanGetExon_count(void) const
{
    return IsSetExon_count();
}

inline
void CModelEvidenceItem_Base::ResetExon_count(void)
{
    m_Exon_count = 0;
    m_set_State[0] &= ~0xc;
}

inline
CModelEvidenceItem_Base::TExon_count CModelEvidenceItem_Base::GetExon_count(void) const
{
    if (!CanGetExon_count()) {
        ThrowUnassigned(1);
    }
    return m_Exon_count;
}

inline
void CModelEvidenceItem_Base::SetExon_count(CModelEvidenceItem_Base::TExon_count value)
{
    m_Exon_count = value;
    m_set_State[0] |= 0xc;
}

inline
CModelEvidenceItem_Base::TExon_count& CModelEvidenceItem_Base::SetExon_count(void)
{
#ifdef _DEBUG
    if (!IsSetExon_count()) {
        memset(&m_Exon_count,UnassignedByte(),sizeof(m_Exon_count));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Exon_count;
}

inline
bool CModelEvidenceItem_Base::IsSetExon_length(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CModelEvidenceItem_Base::CanGetExon_length(void) const
{
    return IsSetExon_length();
}

inline
void CModelEvidenceItem_Base::ResetExon_length(void)
{
    m_Exon_length = 0;
    m_set_State[0] &= ~0x30;
}

inline
CModelEvidenceItem_Base::TExon_length CModelEvidenceItem_Base::GetExon_length(void) const
{
    if (!CanGetExon_length()) {
        ThrowUnassigned(2);
    }
    return m_Exon_length;
}

inline
void CModelEvidenceItem_Base::SetExon_length(CModelEvidenceItem_Base::TExon_length value)
{
    m_Exon_length = value;
    m_set_State[0] |= 0x30;
}

inline
CModelEvidenceItem_Base::TExon_length& CModelEvidenceItem_Base::SetExon_length(void)
{
#ifdef _DEBUG
    if (!IsSetExon_length()) {
        memset(&m_Exon_length,UnassignedByte(),sizeof(m_Exon_length));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Exon_length;
}

inline
bool CModelEvidenceItem_Base::IsSetFull_length(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CModelEvidenceItem_Base::CanGetFull_length(void) const
{
    return true;
}

inline
void CModelEvidenceItem_Base::ResetFull_length(void)
{
    m_Full_length = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CModelEvidenceItem_Base::SetDefaultFull_length(void)
{
    ResetFull_length();
}

inline
CModelEvidenceItem_Base::TFull_length CModelEvidenceItem_Base::GetFull_length(void) const
{
    return m_Full_length;
}

inline
void CModelEvidenceItem_Base::SetFull_length(CModelEvidenceItem_Base::TFull_length value)
{
    m_Full_length = value;
    m_set_State[0] |= 0xc0;
}

inline
CModelEvidenceItem_Base::TFull_length& CModelEvidenceItem_Base::SetFull_length(void)
{
#ifdef _DEBUG
    if (!IsSetFull_length()) {
        memset(&m_Full_length,UnassignedByte(),sizeof(m_Full_length));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Full_length;
}

inline
bool CModelEvidenceItem_Base::IsSetSupports_all_exon_combo(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CModelEvidenceItem_Base::CanGetSupports_all_exon_combo(void) const
{
    return true;
}

inline
void CModelEvidenceItem_Base::ResetSupports_all_exon_combo(void)
{
    m_Supports_all_exon_combo = false;
    m_set_State[0] &= ~0x300;
}

inline
void CModelEvidenceItem_Base::SetDefaultSupports_all_exon_combo(void)
{
    ResetSupports_all_exon_combo();
}

inline
CModelEvidenceItem_Base::TSupports_all_exon_combo CModelEvidenceItem_Base::GetSupports_all_exon_combo(void) const
{
    return m_Supports_all_exon_combo;
}

inline
void CModelEvidenceItem_Base::SetSupports_all_exon_combo(CModelEvidenceItem_Base::TSupports_all_exon_combo value)
{
    m_Supports_all_exon_combo = value;
    m_set_State[0] |= 0x300;
}

inline
CModelEvidenceItem_Base::TSupports_all_exon_combo& CModelEvidenceItem_Base::SetSupports_all_exon_combo(void)
{
#ifdef _DEBUG
    if (!IsSetSupports_all_exon_combo()) {
        memset(&m_Supports_all_exon_combo,UnassignedByte(),sizeof(m_Supports_all_exon_combo));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Supports_all_exon_combo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_MODELEVIDENCEITEM_BASE_HPP
