/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_code_set_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqcode.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQCODE_SEQ_CODE_SET_BASE_HPP
#define OBJECTS_SEQCODE_SEQ_CODE_SET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_code_table;
class CSeq_map_table;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// for distribution
class NCBI_SEQCODE_EXPORT CSeq_code_set_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_code_set_Base(void);
    // destructor
    virtual ~CSeq_code_set_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CSeq_code_table > > TCodes;
    typedef list< CRef< CSeq_map_table > > TMaps;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_codes,
        e_maps
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CSeq_code_table > > TCodes
    ///  Check whether the Codes data member has been assigned a value.
    bool IsSetCodes(void) const;
    /// Check whether it is safe or not to call GetCodes method.
    bool CanGetCodes(void) const;
    void ResetCodes(void);
    const TCodes& GetCodes(void) const;
    TCodes& SetCodes(void);

    /// optional
    /// typedef list< CRef< CSeq_map_table > > TMaps
    ///  Check whether the Maps data member has been assigned a value.
    bool IsSetMaps(void) const;
    /// Check whether it is safe or not to call GetMaps method.
    bool CanGetMaps(void) const;
    void ResetMaps(void);
    const TMaps& GetMaps(void) const;
    TMaps& SetMaps(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_code_set_Base(const CSeq_code_set_Base&);
    CSeq_code_set_Base& operator=(const CSeq_code_set_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_code_table > > m_Codes;
    list< CRef< CSeq_map_table > > m_Maps;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_code_set_Base::IsSetCodes(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_code_set_Base::CanGetCodes(void) const
{
    return true;
}

inline
const CSeq_code_set_Base::TCodes& CSeq_code_set_Base::GetCodes(void) const
{
    return m_Codes;
}

inline
CSeq_code_set_Base::TCodes& CSeq_code_set_Base::SetCodes(void)
{
    m_set_State[0] |= 0x1;
    return m_Codes;
}

inline
bool CSeq_code_set_Base::IsSetMaps(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_code_set_Base::CanGetMaps(void) const
{
    return true;
}

inline
const CSeq_code_set_Base::TMaps& CSeq_code_set_Base::GetMaps(void) const
{
    return m_Maps;
}

inline
CSeq_code_set_Base::TMaps& CSeq_code_set_Base::SetMaps(void)
{
    m_set_State[0] |= 0x4;
    return m_Maps;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQCODE_SEQ_CODE_SET_BASE_HPP
