/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PRF_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seqblock.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQBLOCK_PRF_BLOCK_BASE_HPP
#define OBJECTS_SEQBLOCK_PRF_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPRF_ExtraSrc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQBLOCK_EXPORT CPRF_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPRF_block_Base(void);
    // destructor
    virtual ~CPRF_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPRF_ExtraSrc TExtra_src;
    typedef list< string > TKeywords;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_extra_src,
        e_keywords
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CPRF_ExtraSrc TExtra_src
    ///  Check whether the Extra_src data member has been assigned a value.
    bool IsSetExtra_src(void) const;
    /// Check whether it is safe or not to call GetExtra_src method.
    bool CanGetExtra_src(void) const;
    void ResetExtra_src(void);
    const TExtra_src& GetExtra_src(void) const;
    void SetExtra_src(TExtra_src& value);
    TExtra_src& SetExtra_src(void);

    /// optional
    /// typedef list< string > TKeywords
    ///  Check whether the Keywords data member has been assigned a value.
    bool IsSetKeywords(void) const;
    /// Check whether it is safe or not to call GetKeywords method.
    bool CanGetKeywords(void) const;
    void ResetKeywords(void);
    const TKeywords& GetKeywords(void) const;
    TKeywords& SetKeywords(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPRF_block_Base(const CPRF_block_Base&);
    CPRF_block_Base& operator=(const CPRF_block_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TExtra_src > m_Extra_src;
    list< string > m_Keywords;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPRF_block_Base::IsSetExtra_src(void) const
{
    return m_Extra_src.NotEmpty();
}

inline
bool CPRF_block_Base::CanGetExtra_src(void) const
{
    return IsSetExtra_src();
}

inline
const CPRF_block_Base::TExtra_src& CPRF_block_Base::GetExtra_src(void) const
{
    if (!CanGetExtra_src()) {
        ThrowUnassigned(0);
    }
    return (*m_Extra_src);
}

inline
bool CPRF_block_Base::IsSetKeywords(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPRF_block_Base::CanGetKeywords(void) const
{
    return true;
}

inline
const CPRF_block_Base::TKeywords& CPRF_block_Base::GetKeywords(void) const
{
    return m_Keywords;
}

inline
CPRF_block_Base::TKeywords& CPRF_block_Base::SetKeywords(void)
{
    m_set_State[0] |= 0x4;
    return m_Keywords;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQBLOCK_PRF_BLOCK_BASE_HPP
