/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_literal_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQ_LITERAL_BASE_HPP
#define OBJECTS_SEQ_SEQ_LITERAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeq_data;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CSeq_literal_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_literal_Base(void);
    // destructor
    virtual ~CSeq_literal_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef TSeqPos TLength;
    typedef CInt_fuzz TFuzz;
    typedef CSeq_data TSeq_data;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_length,
        e_fuzz,
        e_seq_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// must give a length in residues
    /// mandatory
    /// typedef TSeqPos TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    TLength GetLength(void) const;
    void SetLength(TLength value);
    TLength& SetLength(void);

    /// could be unsure
    /// optional
    /// typedef CInt_fuzz TFuzz
    ///  Check whether the Fuzz data member has been assigned a value.
    bool IsSetFuzz(void) const;
    /// Check whether it is safe or not to call GetFuzz method.
    bool CanGetFuzz(void) const;
    void ResetFuzz(void);
    const TFuzz& GetFuzz(void) const;
    void SetFuzz(TFuzz& value);
    TFuzz& SetFuzz(void);

    /// may have the data
    /// optional
    /// typedef CSeq_data TSeq_data
    ///  Check whether the Seq_data data member has been assigned a value.
    bool IsSetSeq_data(void) const;
    /// Check whether it is safe or not to call GetSeq_data method.
    bool CanGetSeq_data(void) const;
    void ResetSeq_data(void);
    const TSeq_data& GetSeq_data(void) const;
    void SetSeq_data(TSeq_data& value);
    TSeq_data& SetSeq_data(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_literal_Base(const CSeq_literal_Base&);
    CSeq_literal_Base& operator=(const CSeq_literal_Base&);

    // data
    Uint4 m_set_State[1];
    TSeqPos m_Length;
    CRef< TFuzz > m_Fuzz;
    CRef< TSeq_data > m_Seq_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_literal_Base::IsSetLength(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_literal_Base::CanGetLength(void) const
{
    return IsSetLength();
}

inline
void CSeq_literal_Base::ResetLength(void)
{
    m_Length = 0;
    m_set_State[0] &= ~0x3;
}

inline
CSeq_literal_Base::TLength CSeq_literal_Base::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(0);
    }
    return m_Length;
}

inline
void CSeq_literal_Base::SetLength(CSeq_literal_Base::TLength value)
{
    m_Length = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_literal_Base::TLength& CSeq_literal_Base::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        memset(&m_Length,UnassignedByte(),sizeof(m_Length));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Length;
}

inline
bool CSeq_literal_Base::IsSetFuzz(void) const
{
    return m_Fuzz.NotEmpty();
}

inline
bool CSeq_literal_Base::CanGetFuzz(void) const
{
    return IsSetFuzz();
}

inline
const CSeq_literal_Base::TFuzz& CSeq_literal_Base::GetFuzz(void) const
{
    if (!CanGetFuzz()) {
        ThrowUnassigned(1);
    }
    return (*m_Fuzz);
}

inline
bool CSeq_literal_Base::IsSetSeq_data(void) const
{
    return m_Seq_data.NotEmpty();
}

inline
bool CSeq_literal_Base::CanGetSeq_data(void) const
{
    return IsSetSeq_data();
}

inline
const CSeq_literal_Base::TSeq_data& CSeq_literal_Base::GetSeq_data(void) const
{
    if (!CanGetSeq_data()) {
        ThrowUnassigned(2);
    }
    return (*m_Seq_data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQ_LITERAL_BASE_HPP
