/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Seq_inst_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_SEQ_INST_BASE_HPP
#define OBJECTS_SEQ_SEQ_INST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CInt_fuzz;
class CSeq_data;
class CSeq_ext;
class CSeq_hist;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*** Instances of sequences *******************************
///*
/// the sequence data itself
class NCBI_SEQ_EXPORT CSeq_inst_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSeq_inst_Base(void);
    // destructor
    virtual ~CSeq_inst_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// representation class
    enum ERepr {
        eRepr_not_set =   0,  ///< empty
        eRepr_virtual =   1,  ///< no seq data
        eRepr_raw     =   2,  ///< continuous sequence
        eRepr_seg     =   3,  ///< segmented sequence
        eRepr_const   =   4,  ///< constructed sequence
        eRepr_ref     =   5,  ///< reference to another sequence
        eRepr_consen  =   6,  ///< consensus sequence or pattern
        eRepr_map     =   7,  ///< ordered map of any kind
        eRepr_delta   =   8,  ///< sequence made by changes (delta) to others
        eRepr_other   = 255
    };
    
    /// Access to ERepr's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ERepr)(void);
    
    /// molecule class in living organism
    enum EMol {
        eMol_not_set =   0,  ///<   > cdna = rna
        eMol_dna     =   1,
        eMol_rna     =   2,
        eMol_aa      =   3,
        eMol_na      =   4,  ///< just a nucleic acid
        eMol_other   = 255
    };
    
    /// Access to EMol's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMol)(void);
    
    /// topology of molecule
    enum ETopology {
        eTopology_not_set  =   0,
        eTopology_linear   =   1,
        eTopology_circular =   2,
        eTopology_tandem   =   3,  ///< some part of tandem repeat
        eTopology_other    = 255
    };
    
    /// Access to ETopology's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ETopology)(void);
    
    /// strandedness in living organism
    enum EStrand {
        eStrand_not_set =   0,
        eStrand_ss      =   1,  ///< single strand
        eStrand_ds      =   2,  ///< double strand
        eStrand_mixed   =   3,
        eStrand_other   = 255  ///< default ds for DNA, ss for RNA, pept
    };
    
    /// Access to EStrand's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EStrand)(void);
    
    // types
    typedef ERepr TRepr;
    typedef EMol TMol;
    typedef TSeqPos TLength;
    typedef CInt_fuzz TFuzz;
    typedef ETopology TTopology;
    typedef EStrand TStrand;
    typedef CSeq_data TSeq_data;
    typedef CSeq_ext TExt;
    typedef CSeq_hist THist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_repr,
        e_mol,
        e_length,
        e_fuzz,
        e_topology,
        e_strand,
        e_seq_data,
        e_ext,
        e_hist
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ERepr TRepr
    ///  Check whether the Repr data member has been assigned a value.
    bool IsSetRepr(void) const;
    /// Check whether it is safe or not to call GetRepr method.
    bool CanGetRepr(void) const;
    void ResetRepr(void);
    TRepr GetRepr(void) const;
    void SetRepr(TRepr value);
    TRepr& SetRepr(void);

    /// mandatory
    /// typedef EMol TMol
    ///  Check whether the Mol data member has been assigned a value.
    bool IsSetMol(void) const;
    /// Check whether it is safe or not to call GetMol method.
    bool CanGetMol(void) const;
    void ResetMol(void);
    TMol GetMol(void) const;
    void SetMol(TMol value);
    TMol& SetMol(void);

    /// length of sequence in residues
    /// optional
    /// typedef TSeqPos TLength
    ///  Check whether the Length data member has been assigned a value.
    bool IsSetLength(void) const;
    /// Check whether it is safe or not to call GetLength method.
    bool CanGetLength(void) const;
    void ResetLength(void);
    TLength GetLength(void) const;
    void SetLength(TLength value);
    TLength& SetLength(void);

    /// length uncertainty
    /// optional
    /// typedef CInt_fuzz TFuzz
    ///  Check whether the Fuzz data member has been assigned a value.
    bool IsSetFuzz(void) const;
    /// Check whether it is safe or not to call GetFuzz method.
    bool CanGetFuzz(void) const;
    void ResetFuzz(void);
    const TFuzz& GetFuzz(void) const;
    void SetFuzz(TFuzz& value);
    TFuzz& SetFuzz(void);

    /// optional with default eTopology_linear
    /// typedef ETopology TTopology
    ///  Check whether the Topology data member has been assigned a value.
    bool IsSetTopology(void) const;
    /// Check whether it is safe or not to call GetTopology method.
    bool CanGetTopology(void) const;
    void ResetTopology(void);
    void SetDefaultTopology(void);
    TTopology GetTopology(void) const;
    void SetTopology(TTopology value);
    TTopology& SetTopology(void);

    /// optional
    /// typedef EStrand TStrand
    ///  Check whether the Strand data member has been assigned a value.
    bool IsSetStrand(void) const;
    /// Check whether it is safe or not to call GetStrand method.
    bool CanGetStrand(void) const;
    void ResetStrand(void);
    TStrand GetStrand(void) const;
    void SetStrand(TStrand value);
    TStrand& SetStrand(void);

    /// the sequence
    /// optional
    /// typedef CSeq_data TSeq_data
    ///  Check whether the Seq_data data member has been assigned a value.
    bool IsSetSeq_data(void) const;
    /// Check whether it is safe or not to call GetSeq_data method.
    bool CanGetSeq_data(void) const;
    void ResetSeq_data(void);
    const TSeq_data& GetSeq_data(void) const;
    void SetSeq_data(TSeq_data& value);
    TSeq_data& SetSeq_data(void);

    /// extensions for special types
    /// optional
    /// typedef CSeq_ext TExt
    ///  Check whether the Ext data member has been assigned a value.
    bool IsSetExt(void) const;
    /// Check whether it is safe or not to call GetExt method.
    bool CanGetExt(void) const;
    void ResetExt(void);
    const TExt& GetExt(void) const;
    void SetExt(TExt& value);
    TExt& SetExt(void);

    /// sequence history
    /// optional
    /// typedef CSeq_hist THist
    ///  Check whether the Hist data member has been assigned a value.
    bool IsSetHist(void) const;
    /// Check whether it is safe or not to call GetHist method.
    bool CanGetHist(void) const;
    void ResetHist(void);
    const THist& GetHist(void) const;
    void SetHist(THist& value);
    THist& SetHist(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSeq_inst_Base(const CSeq_inst_Base&);
    CSeq_inst_Base& operator=(const CSeq_inst_Base&);

    // data
    Uint4 m_set_State[1];
    ERepr m_Repr;
    EMol m_Mol;
    TSeqPos m_Length;
    CRef< TFuzz > m_Fuzz;
    ETopology m_Topology;
    EStrand m_Strand;
    CRef< TSeq_data > m_Seq_data;
    CRef< TExt > m_Ext;
    CRef< THist > m_Hist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSeq_inst_Base::IsSetRepr(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSeq_inst_Base::CanGetRepr(void) const
{
    return IsSetRepr();
}

inline
void CSeq_inst_Base::ResetRepr(void)
{
    m_Repr = (ERepr)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSeq_inst_Base::TRepr CSeq_inst_Base::GetRepr(void) const
{
    if (!CanGetRepr()) {
        ThrowUnassigned(0);
    }
    return m_Repr;
}

inline
void CSeq_inst_Base::SetRepr(CSeq_inst_Base::TRepr value)
{
    m_Repr = value;
    m_set_State[0] |= 0x3;
}

inline
CSeq_inst_Base::TRepr& CSeq_inst_Base::SetRepr(void)
{
#ifdef _DEBUG
    if (!IsSetRepr()) {
        memset(&m_Repr,UnassignedByte(),sizeof(m_Repr));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Repr;
}

inline
bool CSeq_inst_Base::IsSetMol(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSeq_inst_Base::CanGetMol(void) const
{
    return IsSetMol();
}

inline
void CSeq_inst_Base::ResetMol(void)
{
    m_Mol = (EMol)(0);
    m_set_State[0] &= ~0xc;
}

inline
CSeq_inst_Base::TMol CSeq_inst_Base::GetMol(void) const
{
    if (!CanGetMol()) {
        ThrowUnassigned(1);
    }
    return m_Mol;
}

inline
void CSeq_inst_Base::SetMol(CSeq_inst_Base::TMol value)
{
    m_Mol = value;
    m_set_State[0] |= 0xc;
}

inline
CSeq_inst_Base::TMol& CSeq_inst_Base::SetMol(void)
{
#ifdef _DEBUG
    if (!IsSetMol()) {
        memset(&m_Mol,UnassignedByte(),sizeof(m_Mol));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Mol;
}

inline
bool CSeq_inst_Base::IsSetLength(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CSeq_inst_Base::CanGetLength(void) const
{
    return IsSetLength();
}

inline
void CSeq_inst_Base::ResetLength(void)
{
    m_Length = 0;
    m_set_State[0] &= ~0x30;
}

inline
CSeq_inst_Base::TLength CSeq_inst_Base::GetLength(void) const
{
    if (!CanGetLength()) {
        ThrowUnassigned(2);
    }
    return m_Length;
}

inline
void CSeq_inst_Base::SetLength(CSeq_inst_Base::TLength value)
{
    m_Length = value;
    m_set_State[0] |= 0x30;
}

inline
CSeq_inst_Base::TLength& CSeq_inst_Base::SetLength(void)
{
#ifdef _DEBUG
    if (!IsSetLength()) {
        memset(&m_Length,UnassignedByte(),sizeof(m_Length));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Length;
}

inline
bool CSeq_inst_Base::IsSetFuzz(void) const
{
    return m_Fuzz.NotEmpty();
}

inline
bool CSeq_inst_Base::CanGetFuzz(void) const
{
    return IsSetFuzz();
}

inline
const CSeq_inst_Base::TFuzz& CSeq_inst_Base::GetFuzz(void) const
{
    if (!CanGetFuzz()) {
        ThrowUnassigned(3);
    }
    return (*m_Fuzz);
}

inline
bool CSeq_inst_Base::IsSetTopology(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CSeq_inst_Base::CanGetTopology(void) const
{
    return true;
}

inline
void CSeq_inst_Base::ResetTopology(void)
{
    m_Topology = eTopology_linear;
    m_set_State[0] &= ~0x300;
}

inline
void CSeq_inst_Base::SetDefaultTopology(void)
{
    ResetTopology();
}

inline
CSeq_inst_Base::TTopology CSeq_inst_Base::GetTopology(void) const
{
    return m_Topology;
}

inline
void CSeq_inst_Base::SetTopology(CSeq_inst_Base::TTopology value)
{
    m_Topology = value;
    m_set_State[0] |= 0x300;
}

inline
CSeq_inst_Base::TTopology& CSeq_inst_Base::SetTopology(void)
{
#ifdef _DEBUG
    if (!IsSetTopology()) {
        memset(&m_Topology,UnassignedByte(),sizeof(m_Topology));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Topology;
}

inline
bool CSeq_inst_Base::IsSetStrand(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CSeq_inst_Base::CanGetStrand(void) const
{
    return IsSetStrand();
}

inline
void CSeq_inst_Base::ResetStrand(void)
{
    m_Strand = (EStrand)(0);
    m_set_State[0] &= ~0xc00;
}

inline
CSeq_inst_Base::TStrand CSeq_inst_Base::GetStrand(void) const
{
    if (!CanGetStrand()) {
        ThrowUnassigned(5);
    }
    return m_Strand;
}

inline
void CSeq_inst_Base::SetStrand(CSeq_inst_Base::TStrand value)
{
    m_Strand = value;
    m_set_State[0] |= 0xc00;
}

inline
CSeq_inst_Base::TStrand& CSeq_inst_Base::SetStrand(void)
{
#ifdef _DEBUG
    if (!IsSetStrand()) {
        memset(&m_Strand,UnassignedByte(),sizeof(m_Strand));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Strand;
}

inline
bool CSeq_inst_Base::IsSetSeq_data(void) const
{
    return m_Seq_data.NotEmpty();
}

inline
bool CSeq_inst_Base::CanGetSeq_data(void) const
{
    return IsSetSeq_data();
}

inline
const CSeq_inst_Base::TSeq_data& CSeq_inst_Base::GetSeq_data(void) const
{
    if (!CanGetSeq_data()) {
        ThrowUnassigned(6);
    }
    return (*m_Seq_data);
}

inline
bool CSeq_inst_Base::IsSetExt(void) const
{
    return m_Ext.NotEmpty();
}

inline
bool CSeq_inst_Base::CanGetExt(void) const
{
    return IsSetExt();
}

inline
const CSeq_inst_Base::TExt& CSeq_inst_Base::GetExt(void) const
{
    if (!CanGetExt()) {
        ThrowUnassigned(7);
    }
    return (*m_Ext);
}

inline
bool CSeq_inst_Base::IsSetHist(void) const
{
    return m_Hist.NotEmpty();
}

inline
bool CSeq_inst_Base::CanGetHist(void) const
{
    return IsSetHist();
}

inline
const CSeq_inst_Base::THist& CSeq_inst_Base::GetHist(void) const
{
    if (!CanGetHist()) {
        ThrowUnassigned(8);
    }
    return (*m_Hist);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_SEQ_INST_BASE_HPP
