/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GIBB_method_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_GIBB_METHOD_BASE_HPP
#define OBJECTS_SEQ_GIBB_METHOD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// sequencing methods
enum EGIBB_method {
    eGIBB_method_concept_trans    =   1,  ///< conceptual translation
    eGIBB_method_seq_pept         =   2,  ///< peptide was sequenced
    eGIBB_method_both             =   3,  ///< concept transl. w/ partial pept. seq.
    eGIBB_method_seq_pept_overlap =   4,  ///< sequenced peptide, ordered by overlap
    eGIBB_method_seq_pept_homol   =   5,  ///< sequenced peptide, ordered by homology
    eGIBB_method_concept_trans_a  =   6,  ///< conceptual transl. supplied by author
    eGIBB_method_other            = 255
};

/// Access to EGIBB_method's attributes (values, names) as defined in spec
NCBI_SEQ_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EGIBB_method)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_GIBB_METHOD_BASE_HPP
