/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Align_def_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'seq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SEQ_ALIGN_DEF_BASE_HPP
#define OBJECTS_SEQ_ALIGN_DEF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQ_EXPORT CAlign_def_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAlign_def_Base(void);
    // destructor
    virtual ~CAlign_def_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// class of align Seq-annot
    enum EAlign_type {
        eAlign_type_ref    =   1,  ///< set of alignments to the same sequence
        eAlign_type_alt    =   2,  ///< set of alternate alignments of the same seqs
        eAlign_type_blocks =   3,  ///< set of aligned blocks in the same seqs
        eAlign_type_other  = 255
    };
    
    /// Access to EAlign_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAlign_type)(void);
    
    // types
    typedef int TAlign_type;
    typedef list< CRef< CSeq_id > > TIds;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_align_type,
        e_ids
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TAlign_type
    ///  Check whether the Align_type data member has been assigned a value.
    bool IsSetAlign_type(void) const;
    /// Check whether it is safe or not to call GetAlign_type method.
    bool CanGetAlign_type(void) const;
    void ResetAlign_type(void);
    TAlign_type GetAlign_type(void) const;
    void SetAlign_type(TAlign_type value);
    TAlign_type& SetAlign_type(void);

    /// used for the one ref seqid for now
    /// optional
    /// typedef list< CRef< CSeq_id > > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAlign_def_Base(const CAlign_def_Base&);
    CAlign_def_Base& operator=(const CAlign_def_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Align_type;
    list< CRef< CSeq_id > > m_Ids;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAlign_def_Base::IsSetAlign_type(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAlign_def_Base::CanGetAlign_type(void) const
{
    return IsSetAlign_type();
}

inline
void CAlign_def_Base::ResetAlign_type(void)
{
    m_Align_type = (EAlign_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CAlign_def_Base::TAlign_type CAlign_def_Base::GetAlign_type(void) const
{
    if (!CanGetAlign_type()) {
        ThrowUnassigned(0);
    }
    return m_Align_type;
}

inline
void CAlign_def_Base::SetAlign_type(CAlign_def_Base::TAlign_type value)
{
    m_Align_type = value;
    m_set_State[0] |= 0x3;
}

inline
CAlign_def_Base::TAlign_type& CAlign_def_Base::SetAlign_type(void)
{
#ifdef _DEBUG
    if (!IsSetAlign_type()) {
        memset(&m_Align_type,UnassignedByte(),sizeof(m_Align_type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Align_type;
}

inline
bool CAlign_def_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAlign_def_Base::CanGetIds(void) const
{
    return true;
}

inline
const CAlign_def_Base::TIds& CAlign_def_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CAlign_def_Base::TIds& CAlign_def_Base::SetIds(void)
{
    m_set_State[0] |= 0x4;
    return m_Ids;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQ_ALIGN_DEF_BASE_HPP
