/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PssmWithParameters_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_PSSMWITHPARAMETERS_BASE_HPP
#define OBJECTS_SCOREMAT_PSSMWITHPARAMETERS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPssm;
class CPssmParameters;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Envelope containing PSSM and the parameters used to create it. 
/// Provided for use in PSI-BLAST, formatrpsdb, and for the structure group.
class NCBI_SCOREMAT_EXPORT CPssmWithParameters_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPssmWithParameters_Base(void);
    // destructor
    virtual ~CPssmWithParameters_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPssm TPssm;
    typedef CPssmParameters TParams;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pssm,
        e_params
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// This field is applicable to PSI-BLAST and formatrpsdb.
    /// When both the intermediate and final PSSM data are provided in this
    /// field, the final data (matrix of scores and associated statistical
    /// parameters) takes precedence and that data is used for further
    /// processing. The rationale for this is that the PSSM's scores and
    /// statistical parameters might have been calculated by other applications
    /// and it might not be possible to recreate it by using PSI-BLAST's PSSM 
    /// engine.
    /// mandatory
    /// typedef CPssm TPssm
    ///  Check whether the Pssm data member has been assigned a value.
    bool IsSetPssm(void) const;
    /// Check whether it is safe or not to call GetPssm method.
    bool CanGetPssm(void) const;
    void ResetPssm(void);
    const TPssm& GetPssm(void) const;
    void SetPssm(TPssm& value);
    TPssm& SetPssm(void);

    /// This field's rpsdbparams is used to specify the values of options 
    /// for processing by formatrpsdb. If these are not set, the command 
    /// line defaults of formatrpsdb are applied. This field is used
    /// by PSI-BLAST to verify that the underlying scorem matrix used to BUILD
    /// the PSSM is the same as the one being specified through the BLAST
    /// Options API. If this field is omitted, no verification will be
    /// performed, so be careful to keep track of what matrix was used to build
    /// the PSSM or else the results produced by PSI-BLAST will be unreliable.
    /// optional
    /// typedef CPssmParameters TParams
    ///  Check whether the Params data member has been assigned a value.
    bool IsSetParams(void) const;
    /// Check whether it is safe or not to call GetParams method.
    bool CanGetParams(void) const;
    void ResetParams(void);
    const TParams& GetParams(void) const;
    void SetParams(TParams& value);
    TParams& SetParams(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPssmWithParameters_Base(const CPssmWithParameters_Base&);
    CPssmWithParameters_Base& operator=(const CPssmWithParameters_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TPssm > m_Pssm;
    CRef< TParams > m_Params;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPssmWithParameters_Base::IsSetPssm(void) const
{
    return m_Pssm.NotEmpty();
}

inline
bool CPssmWithParameters_Base::CanGetPssm(void) const
{
    return true;
}

inline
const CPssmWithParameters_Base::TPssm& CPssmWithParameters_Base::GetPssm(void) const
{
    if ( !m_Pssm ) {
        const_cast<CPssmWithParameters_Base*>(this)->ResetPssm();
    }
    return (*m_Pssm);
}

inline
CPssmWithParameters_Base::TPssm& CPssmWithParameters_Base::SetPssm(void)
{
    if ( !m_Pssm ) {
        ResetPssm();
    }
    return (*m_Pssm);
}

inline
bool CPssmWithParameters_Base::IsSetParams(void) const
{
    return m_Params.NotEmpty();
}

inline
bool CPssmWithParameters_Base::CanGetParams(void) const
{
    return IsSetParams();
}

inline
const CPssmWithParameters_Base::TParams& CPssmWithParameters_Base::GetParams(void) const
{
    if (!CanGetParams()) {
        ThrowUnassigned(1);
    }
    return (*m_Params);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSMWITHPARAMETERS_BASE_HPP
