/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file LoopConstraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_LOOPCONSTRAINT_BASE_HPP
#define OBJECTS_SCOREMAT_LOOPCONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_SCOREMAT_EXPORT CLoopConstraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CLoopConstraint_Base(void);
    // destructor
    virtual ~CLoopConstraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TMinlength;
    typedef int TMaxlength;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_minlength,
        e_maxlength
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// minimum length of unaligned region
    /// optional with default 0
    /// typedef int TMinlength
    ///  Check whether the Minlength data member has been assigned a value.
    bool IsSetMinlength(void) const;
    /// Check whether it is safe or not to call GetMinlength method.
    bool CanGetMinlength(void) const;
    void ResetMinlength(void);
    void SetDefaultMinlength(void);
    TMinlength GetMinlength(void) const;
    void SetMinlength(TMinlength value);
    TMinlength& SetMinlength(void);

    /// maximum length of unaligned region
    /// optional with default 100000
    /// typedef int TMaxlength
    ///  Check whether the Maxlength data member has been assigned a value.
    bool IsSetMaxlength(void) const;
    /// Check whether it is safe or not to call GetMaxlength method.
    bool CanGetMaxlength(void) const;
    void ResetMaxlength(void);
    void SetDefaultMaxlength(void);
    TMaxlength GetMaxlength(void) const;
    void SetMaxlength(TMaxlength value);
    TMaxlength& SetMaxlength(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLoopConstraint_Base(const CLoopConstraint_Base&);
    CLoopConstraint_Base& operator=(const CLoopConstraint_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Minlength;
    int m_Maxlength;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLoopConstraint_Base::IsSetMinlength(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLoopConstraint_Base::CanGetMinlength(void) const
{
    return true;
}

inline
void CLoopConstraint_Base::ResetMinlength(void)
{
    m_Minlength = 0;
    m_set_State[0] &= ~0x3;
}

inline
void CLoopConstraint_Base::SetDefaultMinlength(void)
{
    ResetMinlength();
}

inline
CLoopConstraint_Base::TMinlength CLoopConstraint_Base::GetMinlength(void) const
{
    return m_Minlength;
}

inline
void CLoopConstraint_Base::SetMinlength(CLoopConstraint_Base::TMinlength value)
{
    m_Minlength = value;
    m_set_State[0] |= 0x3;
}

inline
CLoopConstraint_Base::TMinlength& CLoopConstraint_Base::SetMinlength(void)
{
#ifdef _DEBUG
    if (!IsSetMinlength()) {
        memset(&m_Minlength,UnassignedByte(),sizeof(m_Minlength));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Minlength;
}

inline
bool CLoopConstraint_Base::IsSetMaxlength(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLoopConstraint_Base::CanGetMaxlength(void) const
{
    return true;
}

inline
void CLoopConstraint_Base::ResetMaxlength(void)
{
    m_Maxlength = 100000;
    m_set_State[0] &= ~0xc;
}

inline
void CLoopConstraint_Base::SetDefaultMaxlength(void)
{
    ResetMaxlength();
}

inline
CLoopConstraint_Base::TMaxlength CLoopConstraint_Base::GetMaxlength(void) const
{
    return m_Maxlength;
}

inline
void CLoopConstraint_Base::SetMaxlength(CLoopConstraint_Base::TMaxlength value)
{
    m_Maxlength = value;
    m_set_State[0] |= 0xc;
}

inline
CLoopConstraint_Base::TMaxlength& CLoopConstraint_Base::SetMaxlength(void)
{
#ifdef _DEBUG
    if (!IsSetMaxlength()) {
        memset(&m_Maxlength,UnassignedByte(),sizeof(m_Maxlength));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Maxlength;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_LOOPCONSTRAINT_BASE_HPP
